#include "mpi.h"
int main( int argc, char *argv[] )
{
    int          gsizes[2], distribs[2], dargs[2], psizes[2], rank, size;
    MPI_Datatype filetype;
    int          local_array_size, num_local_rows, num_local_cols;
    int          row_procs, col_procs, row_rank, col_rank;
    int          num_global_rows, num_global_cols;
    MPI_File     fh; 
    float        *local_array; 
    MPI_Status   status;

    MPI_Init( &argc, &argv );

    /* ... */

    /* This code is particular to a 2 x 3 process decomposition */
    MPI_Comm_size( MPI_COMM_WORLD, &size );
    if (size != 16) {
	printf( "Communicator size must be 16\n" );
	MPI_Abort( MPI_COMM_WORLD, 1 );
    }

    gsizes[0] = num_global_rows;
    gsizes[1] = num_global_cols;
    distribs[0] = distribs[1] = MPI_DISTRIBUTE_BLOCK;
    dargs[0] = dargs[1] = MPI_DISTRIBUTE_DFLT_DARG;
    psizes[0] = psizes[1] = 4;
    MPI_Comm_rank(MPI_COMM_WORLD, &rank);
    MPI_Type_create_darray(16, rank, 2, gsizes, distribs, dargs, psizes,
			   MPI_ORDER_C, MPI_FLOAT, &filetype);
    MPI_Type_commit(&filetype);
    local_array_size = num_local_rows * num_local_cols;
    MPI_File_open(MPI_COMM_WORLD, "/pfs/datafile", MPI_MODE_RDONLY,
		  MPI_INFO_NULL, &fh);
    MPI_File_set_view(fh, 0, MPI_FLOAT, filetype, "native", 
		      MPI_INFO_NULL);
    MPI_File_read_all(fh, local_array, local_array_size, 
		      MPI_FLOAT, &status);
    MPI_File_close(&fh);
    
    MPI_Finalize();
}
