#!/usr/bin/env python

from sys    import argv, exit
from os     import environ, getuid, close
from socket import socket, fromfd, AF_UNIX, SOCK_STREAM
from re     import sub
from signal import signal, SIG_DFL, SIGINT, SIGTSTP, SIGCONT
from mpdlib import mpd_set_my_id, mpd_send_one_msg, mpd_recv_one_msg, \
                   mpd_get_my_username, mpd_raise, mpdError

def mpdlistjobs():
    mpd_set_my_id('mpdlistjobs_')
    if len(argv) > 1  and  ( argv[1] == '-h'  or  argv[1] == '--help' ) :
        print 'usage: mpdlistjobs [-a | --all]'
        exit(-1)
    username = mpd_get_my_username()
    if environ.has_key('UNIX_SOCKET'):
        conFD = int(environ['UNIX_SOCKET'])
        conSocket = fromfd(conFD,AF_UNIX,SOCK_STREAM)
        close(conFD)
    else:
        consoleName = '/tmp/mpd2.console_' + username
        conSocket = socket(AF_UNIX,SOCK_STREAM)  # note: UNIX socket
        try:
            conSocket.connect(consoleName)
        except Exception, errmsg:
            mpd_raise('cannot connect to local mpd')
            # mpd_raise('cannot connect to local mpd; errmsg: %s' % (str(errmsg)) )
    if len(argv) > 1  and  (argv[1] == '-a' or argv[1] == '--all'):
        msgToSend = { 'cmd' : 'mpdlistjobs', 'username' : '_all_' }
    else:
        msgToSend = { 'cmd' : 'mpdlistjobs', 'username' : username }
    mpd_send_one_msg(conSocket,msgToSend)
    printed_hdr = 0
    while 1:
        msg = mpd_recv_one_msg(conSocket)
        if (not msg.has_key('cmd')):
            raise RuntimeError, 'mpdlistjobs: INVALID msg=:%s:' % (msg)
        if (msg['cmd'] == 'mpdlistjobs_info'):
            if not printed_hdr:
                hdr = 'jobid'  +  ' ' * (len(msg['jobid'])-1)  +  \
		      'host'  +  ' ' * (len(msg['host']))  +  \
		      'rank    user        pgm'
                print hdr + '\n' + '-' * len(hdr)
                printed_hdr = 1
            print '%s    %s    %s       %s     %s' % \
                  (msg['jobid'],msg['host'],msg['rank'],msg['username'],msg['pgm'])
        else:
            break  # mpdlistjobs_trailer


def sigint_handler(signum,frame):
    exit(-1)

if __name__ == '__main__':
    signal(SIGINT,sigint_handler)
    try:
        mpdlistjobs()
    except mpdError, errmsg:
	print 'mpdlistjobs failed: %s' % (errmsg)
