#!/usr/bin/env  python

from os     import environ, system
from getopt import getopt
from sys    import argv, exit
from popen2 import popen2
from socket import gethostname
from mpdlib import mpd_set_my_id, mpd_get_my_username, mpdError

def mpdboot():
    rshCmd    = 'ssh'
    user      = mpd_get_my_username()
    mpdCmd    = 'mpd.py'
    hostsFile = 'mpd.hosts'
    totalNum  = 1
    debug     = 0
    try:
	(opts, args) = getopt(argv[1:], 'f:r:u:m:n:dh',
			      ['file=', 'rsh=', 'user=', 'mpd=', 'totalnum=', 'debug', 'help'])
    except:
	usage()
    else:
	for opt in opts:
	    if   opt[0] == '-r' or opt[0] == '--rsh':
		rshCmd = opt[1]
	    elif opt[0] == '-u' or opt[0] == '--user':
		user   = opt[1]
	    elif opt[0] == '-m' or opt[0] == '--mpd':
		mpdCmd = opt[1]
	    elif opt[0] == '-f' or opt[0] == '--file':
		hostsFile = opt[1]
	    elif opt[0] == '-n' or opt[0] == '--totalnum':
		totalNum = int(opt[1])
            elif opt[0] == '-d' or opt[0] == '--debug':
                debug = 1
	    elif opt[0] == '-h' or opt[0] == '--help':
		usage()
    if args:
	print 'unrecognized arguments:', ' '.join(args)
	usage()

    try:
	f = open(hostsFile,'r')
    except:
	print 'unable to open hostsfile %s' % hostsFile
	usage()

    myHost = gethostname()
    if debug:
        print 'cmd=:%s -e: (executed on %s)' % (mpdCmd, myHost)
    (mpdstdout, mpdstderr) = popen2('%s -e' % (mpdCmd))
    numStarted = 1
    myPort = mpdstdout.readline().strip()
    hosts  = f.readlines()

    if rshCmd == 'ssh':
	xOpt = '-x'
    else:
	xOpt = ''

    for host in hosts:
	if numStarted == totalNum:
	    break
	host = host.strip()
	if host[0] != '#':                    # ignore comment lines
	    cmd = '%s %s %s -n %s -h %s -p %s &' % \
                  (rshCmd, xOpt, host, mpdCmd, myHost, myPort)
            if debug:
                print 'cmd=:%s:' % (cmd)
	    system(cmd)
	    numStarted += 1

    if numStarted < totalNum:
	print ("%s only contained enough hosts to start a total of %d mpd's," + \
	      " which were started") % (hostsFile, numStarted)

def usage():
    print ''
    print 'mpdboot [-h] [-f <hostsfile>] [-r <rshcmd>] [-u <user>] [-m <mpdcmd>] [-n n_to_start]'
    print 'Long forms of options:'
    print '  --help --file=<hostsfile> --rsh=<rshcmd> --user=<user> --mpd=<mpdcmd> --totalnum=<n_to_start>'
    print """
mpdboot starts one mpd locally and (n_to_start - 1) others as computed from
the -n (--totalnum) option; at least the one local mpd will be started by default;
the machines to use are specified by the --file option (default is mpd.hosts).
You may find it useful to specify the full pathname of mpd on remote hosts (-r) if
they are not in your path.
"""
    exit(-1)
    
if __name__ == '__main__':
    try:
        mpdboot()
    except SystemExit, errmsg:
        pass
    except mpdError, errmsg:
        print 'mpdboot failed: %s' % (errmsg)
