/* -*- Mode: C; c-basic-offset:4 ; -*- */
/*
 *
 *  (C) 2001 by Argonne National Laboratory.
 *      See COPYRIGHT in top-level directory.
 */
#include <stdio.h>
#include "mpi.h"
#include "mpitest.h"

int main( int argc, char **argv)
{
    int    errs = 0;
    void *v;
    int  flag;
    int  vval;
    int  rank, size;
    int base[1024];
    int n, disp;
    MPI_Win win;

    MTest_Init( &argc, &argv );
    MPI_Comm_size( MPI_COMM_WORLD, &size );
    MPI_Comm_rank( MPI_COMM_WORLD, &rank );

    /* Create a window; then extract the values */
    n    = 1024;
    disp = 4;
    MPI_Win_create( base, n, disp, MPI_INFO_NULL, MPI_COMM_WORLD, &win );

    MPI_Win_get_attr( win, MPI_WIN_BASE, &v, &flag );
    if (!flag) {
	errs++;
	fprintf( stderr, "Could not get WIN_BASE\n" );
    }
    else {
	if ((int*)v != base) {
	    errs++;
	    fprintf( stderr, "Got incorrect value for WIN_BASE (%x, should be %x)", 
		     (int)v, (int)base );
	}
    }

    MPI_Win_get_attr( win, MPI_WIN_SIZE, &v, &flag );
    if (!flag) {
	errs++;
	fprintf( stderr, "Could not get WIN_SIZE\n" );
    }
    else {
	vval = *(int*)v;
	if (vval != n) {
	    errs++;
	    fprintf( stderr, "Got wrong value for WIN_SIZE (%d, should be %d)\n", 
		     vval, n );
	}
    }

    MPI_Win_get_attr( win, MPI_WIN_DISP_UNIT, &v, &flag );
    if (!flag) {
	errs++;
	fprintf( stderr, "Could not get WIN_DISP_UNIT\n" );
    }
    else {
	vval = *(int*)v;
	if (vval != disp) {
	    errs++;
	    fprintf( stderr, "Got wrong value for WIN_DISP_UNIT (%d, should be %d)\n",
		     vval, disp );
	}
    }

    MTest_Finalize( errs );
    MPI_Finalize( );
    
    return 0;
}
