/* -*- Mode: C; c-basic-offset:4 ; -*- */
/*  $Id: gthread.c,v 1.5 2003/05/04 21:32:40 gropp Exp $
 *
 *  (C) 2001 by Argonne National Laboratory.
 *      See COPYRIGHT in top-level directory.
 */

#include "mpiimpl.h"

/* To simplify this file: rather than embed each possible thread library in 
   this single file, it should include a separate file for each thread type,
   such as pthread.c, winthread.c, etc., where these files implement the
   necessary thread functions.  This still needs to be done.

   If an include file is needed by other routines (e.g., it is needed by 
   mpiimpl.h), it should be copied to the src/include directory by the 
   top-level configure.
*/
/* General thread support */
#if defined(MPICH_SINGLED_THREADED)
/* We included this for MPICH_SINGLE_THREADED to match the use in 
   mpich2/src/include/mpiimplthread.h */
void MPID_Thread_key_create( MPID_Thread_key_t *key ) 
{
}
MPID_Thread_id_t MPID_Thread_get_id(void)
{
    return 0;
}
#elif defined(HAVE_PTHREAD_CREATE)

void MPID_Thread_key_create( MPID_Thread_key_t * key )
{
    pthread_key_create(key, 0);
}

MPID_Thread_id_t MPID_Thread_get_id(void)
{
    return pthread_self();
}

#elif defined(HAVE_THR_CREATE)

void MPID_Thread_key_create(MPID_Thread_key_t * key)
{
    thr_keycreate(&key, 0);
}

MPID_Thread_key_t MPID_Thread_get_id(void)
{
    return thr_self();
}

#endif
