/* -*- Mode: C; c-basic-offset:4 ; -*- */

/*
 *  (C) 2001 by Argonne National Laboratory.
 *      See COPYRIGHT in top-level directory.
 */

#include <mpiimpl.h>
#include <mpid_dataloop.h>
#include <stdlib.h>
#include <assert.h>

/* #define MPID_TYPE_ALLOC_DEBUG */

int MPID_Type_create_resized(MPI_Datatype oldtype,
			     MPI_Aint lb,
			     MPI_Aint extent,
			     MPI_Datatype *newtype_p)
{
    int mpi_errno;
    MPID_Datatype *new_dtp;
    struct MPID_Dataloop *dlp;

    new_dtp = (MPID_Datatype *) MPIU_Handle_obj_alloc(&MPID_Datatype_mem);
    if (!new_dtp) {
	mpi_errno = MPIR_Err_create_code(MPI_SUCCESS, MPIR_ERR_RECOVERABLE, "MPID_Type_create_resized", __LINE__, MPI_ERR_OTHER, "**nomem", 0);
	return mpi_errno;
    }

    /* handle is filled in by MPIU_Handle_obj_alloc() */
    MPIU_Object_set_ref(new_dtp, 1);
    new_dtp->is_permanent = 0;
    new_dtp->is_committed = 0;
    new_dtp->attributes   = 0;
    new_dtp->cache_id     = 0;
    new_dtp->name[0]      = 0;
    new_dtp->contents     = 0;

    /* if oldtype is a basic, we build a contiguous dataloop of count = 1 */
    if (HANDLE_GET_KIND(oldtype) == HANDLE_KIND_BUILTIN) {
	int oldsize = MPID_Datatype_get_basic_size(oldtype);

	new_dtp->size           = oldsize;
	new_dtp->has_sticky_ub  = 1;
	new_dtp->has_sticky_lb  = 1;
	new_dtp->loopinfo_depth = 1;
	new_dtp->true_lb        = 0;
	new_dtp->lb             = lb;
	new_dtp->true_ub        = oldsize;
	new_dtp->ub             = lb + extent;
	new_dtp->extent         = extent;
	new_dtp->alignsize      = oldsize; /* ??? */
	new_dtp->n_elements     = 1;
	new_dtp->element_size   = oldsize;
	new_dtp->is_contig      = (extent == oldsize) ? 1 : 0;
        new_dtp->eltype         = oldtype;

	/* allocate dataloop */
	new_dtp->loopsize       = sizeof(struct MPID_Dataloop);
	dlp                     = (struct MPID_Dataloop *)MPIU_Malloc(sizeof(struct MPID_Dataloop));
	if (dlp == NULL) assert(0);
	new_dtp->loopinfo       = dlp;

	/* fill in dataloop */
	dlp->kind                       = DLOOP_KIND_CONTIG | DLOOP_FINAL_MASK;
	dlp->handle                     = new_dtp->handle;
	dlp->loop_params.c_t.count      = 1;
	dlp->el_size                    = oldsize;
	dlp->el_extent                  = extent;
    }
    else /* user-defined base type */ {
	MPID_Datatype *old_dtp;
	char *curpos;

	MPID_Datatype_get_ptr(oldtype, old_dtp);

	new_dtp->size           = old_dtp->size;
	new_dtp->has_sticky_ub  = 1;
	new_dtp->has_sticky_lb  = 1;
	new_dtp->loopinfo_depth = 1;
	new_dtp->true_lb        = old_dtp->true_lb;
	new_dtp->lb             = lb;
	new_dtp->true_ub        = old_dtp->true_ub;
	new_dtp->ub             = lb + extent;
	new_dtp->extent         = extent;
	new_dtp->alignsize      = old_dtp->alignsize;
	new_dtp->n_elements     = old_dtp->n_elements;
	new_dtp->element_size   = old_dtp->element_size;

	/* COULD BE MORE AGGRESSIVE ON IS_CONTIG */
	new_dtp->is_contig      =
	    (extent == old_dtp->size) ? old_dtp->is_contig : 0;
        new_dtp->eltype         = old_dtp->eltype;

	/* allocate dataloop */
	new_dtp->loopsize       = old_dtp->loopsize;
	dlp                     = (struct MPID_Dataloop *)MPIU_Malloc(new_dtp->loopsize);
	if (dlp == NULL) assert(0);
	new_dtp->loopinfo       = dlp;

	/* make a copy of the dataloop from the old type (no changes) */
	curpos = (char *) dlp;
	MPID_Dataloop_copy(curpos, old_dtp->loopinfo, old_dtp->loopsize);
    }

    *newtype_p = new_dtp->handle;

    return MPI_SUCCESS;
}






