/* -*- Mode: C; c-basic-offset:4 ; -*- */
/*
 *  (C) 2001 by Argonne National Laboratory.
 *      See COPYRIGHT in top-level directory.
 */

#include "rdma_impl.h"
#ifdef HAVE_STDIO_H
#include <stdio.h>
#endif

/*#undef USE_IOV_LEN_2_SHORTCUT*/
#define USE_IOV_LEN_2_SHORTCUT

#undef FUNCNAME
#define FUNCNAME MPIDI_CH3I_RDMA_put_datav
#undef FCNAME
#define FCNAME MPIDI_QUOTE(FUNCNAME)
int MPIDI_CH3I_RDMA_put_datav(MPIDI_VC *vc, MPID_IOV *iov, int iovlen, int *num_bytes_ptr)
{
    int i;
    unsigned int total = 0;
    unsigned int num_avail, num_avail_right;
    unsigned char *cur_pos;
    unsigned int head, tail, new_tail;
    MPIDI_CH3I_SHM_Queue_t *shmq;
    MPIDI_STATE_DECL(MPID_STATE_MPIDI_CH3I_PUT_DATAV);
    MPIDI_STATE_DECL(MPID_STATE_MEMCPY);

    MPIDI_FUNC_ENTER(MPID_STATE_MPIDI_CH3I_PUT_DATAV);

    MPIDI_DBG_PRINTF((60, FCNAME, "entering"));

    shmq = vc->shm.write_shmq;

    head = shmq->head_index;
    tail = shmq->tail_index;

    if (head > tail)
    {
	num_avail_right = num_avail = head - tail - 1;
    }
    else
    {
	num_avail = head + MPIDI_CH3I_QUEUE_DATASIZE - tail - 1;
	num_avail_right = MPIDI_CH3I_QUEUE_DATASIZE - tail;
	if (num_avail_right > num_avail)
	    num_avail_right = num_avail;
    }

    /* Don't allow puts when less than a packet size is available to prevent
       partial packets from being written? */
    /*if (num_avail < sizeof(MPIDI_CH3_Pkt_t))*/
    if (num_avail == 0)
    {
	*num_bytes_ptr = 0;
	MPIDI_DBG_PRINTF((60, FCNAME, "exiting"));
	MPIDI_FUNC_EXIT(MPID_STATE_MPIDI_CH3I_PUT_DATAV);
	return MPI_SUCCESS;
    }

    cur_pos = &shmq->data[tail];

    /*printf("[%d] putv - avail = %d, avail_right = %d, head = %d, tail = %d\n", MPIR_Process.comm_world->rank, num_avail, num_avail_right, head, tail); fflush(stdout);*/
    MPIU_DBG_PRINTF(("writing to write_shmq %p\n", shmq));
#ifdef USE_IOV_LEN_2_SHORTCUT
    if (iovlen == 2 && (iov[0].MPID_IOV_LEN + iov[1].MPID_IOV_LEN) < num_avail_right)
    {
	MPIDI_DBG_PRINTF((60, FCNAME, "writing %d bytes to write_shmq %08p", iov[0].MPID_IOV_LEN + iov[1].MPID_IOV_LEN, shmq));
	MPIDI_FUNC_ENTER(MPID_STATE_MEMCPY);
	memcpy(cur_pos, iov[0].MPID_IOV_BUF, iov[0].MPID_IOV_LEN);
	MPIDI_FUNC_EXIT(MPID_STATE_MEMCPY);
	MPIDI_FUNC_ENTER(MPID_STATE_MEMCPY);
	memcpy(cur_pos + iov[0].MPID_IOV_LEN, iov[1].MPID_IOV_BUF, iov[1].MPID_IOV_LEN);
	MPIDI_FUNC_EXIT(MPID_STATE_MEMCPY);
	total = iov[0].MPID_IOV_LEN + iov[1].MPID_IOV_LEN;
	MPID_WRITE_BARRIER();
	shmq->tail_index = tail + total;
	*num_bytes_ptr = total;
	MPIDI_DBG_PRINTF((60, FCNAME, "exiting"));
	MPIDI_FUNC_EXIT(MPID_STATE_MPIDI_CH3I_PUT_DATAV);
	return MPI_SUCCESS;
    }
#endif

    for (i=0; i<iovlen && num_avail; i++)
    {
	if (iov[i].MPID_IOV_LEN <= num_avail)
	{
	    total += iov[i].MPID_IOV_LEN;
	    num_avail -= iov[i].MPID_IOV_LEN;
	    MPIDI_DBG_PRINTF((60, FCNAME, "writing %d bytes to write_shmq %08p", iov[i].MPID_IOV_LEN, shmq));
	    if (num_avail_right && iov[i].MPID_IOV_LEN > num_avail_right)
	    {
		MPIDI_FUNC_ENTER(MPID_STATE_MEMCPY);
		memcpy(cur_pos, iov[i].MPID_IOV_BUF, num_avail_right);
		memcpy(shmq->data, iov[i].MPID_IOV_BUF + num_avail_right, iov[i].MPID_IOV_LEN - num_avail_right);
		MPIDI_FUNC_EXIT(MPID_STATE_MEMCPY);
		cur_pos = &shmq->data[iov[i].MPID_IOV_LEN - num_avail_right];
		num_avail_right = 0;
	    }
	    else
	    {
		MPIDI_FUNC_ENTER(MPID_STATE_MEMCPY);
		memcpy(cur_pos, iov[i].MPID_IOV_BUF, iov[i].MPID_IOV_LEN);
		MPIDI_FUNC_EXIT(MPID_STATE_MEMCPY);
		cur_pos += iov[i].MPID_IOV_LEN;
		if (num_avail_right)
		{
		    num_avail_right -= iov[i].MPID_IOV_LEN;
		    if (num_avail_right == 0)
			cur_pos = shmq->data;
		}
	    }
	}
	else
	{
	    total += num_avail;
	    MPIDI_DBG_PRINTF((60, FCNAME, "writing %d bytes to write_shmq %08p", num_avail, shmq));
	    if (num_avail_right && num_avail > num_avail_right)
	    {
		MPIDI_FUNC_ENTER(MPID_STATE_MEMCPY);
		memcpy(cur_pos, iov[i].MPID_IOV_BUF, num_avail_right);
		memcpy(shmq->data, iov[i].MPID_IOV_BUF + num_avail_right, num_avail - num_avail_right);
		MPIDI_FUNC_EXIT(MPID_STATE_MEMCPY);
		cur_pos = &shmq->data[num_avail - num_avail_right];
		/*num_avail_right = 0;*/
	    }
	    else
	    {
		MPIDI_FUNC_ENTER(MPID_STATE_MEMCPY);
		memcpy(cur_pos, iov[i].MPID_IOV_BUF, num_avail);
		MPIDI_FUNC_EXIT(MPID_STATE_MEMCPY);
		cur_pos += num_avail;
		/*
		if (num_avail_right)
		    num_avail_right -= num_avail;
		*/
	    }
	    num_avail = 0;
	    break;
	}
    }

    new_tail = (unsigned int)((char*)cur_pos - (char*)shmq->data);
    MPID_WRITE_BARRIER();
    if (new_tail == MPIDI_CH3I_QUEUE_DATASIZE)
	shmq->tail_index = 0;
    else
	shmq->tail_index = new_tail;
    *num_bytes_ptr = total;
    /*printf("[%d]shm tail = %6d, total written = %6d\n", MPIR_Process.comm_world->rank, shmq->tail_index, total); fflush(stdout);*/
    MPIDI_DBG_PRINTF((60, FCNAME, "exiting"));
    MPIDI_FUNC_EXIT(MPID_STATE_MPIDI_CH3I_PUT_DATAV);
    return MPI_SUCCESS;
}

#undef FUNCNAME
#define FUNCNAME MPIDI_CH3I_RDMA_read_datav
#undef FCNAME
#define FCNAME MPIDI_QUOTE(FUNCNAME)
int MPIDI_CH3I_RDMA_read_datav(MPIDI_VC *recv_vc_ptr, MPID_IOV *iov, int iovlen, int *num_bytes_ptr)
{
    int error;
    MPIDI_CH3I_SHM_Queue_t *shmq;
    register int iov_index = 0, total = 0, new_head;
    unsigned int num_avail, num_avail_right;
    unsigned char *cur_pos;
    unsigned int head, tail;
    MPIDI_STATE_DECL(MPID_STATE_MPIDI_CH3I_RDMA_READ_DATAV);
    MPIDI_STATE_DECL(MPID_STATE_MEMCPY);

    MPIDI_FUNC_ENTER(MPID_STATE_MPIDI_CH3I_RDMA_READ_DATAV);

    shmq = recv_vc_ptr->shm.read_shmq;
#ifdef MPICH_DEV_BUILD
    if (shmq == NULL)
    {
	error = MPIR_Err_create_code(MPI_SUCCESS, MPIR_ERR_FATAL, FCNAME, __LINE__, MPI_ERR_OTHER, "**arg", 0);
	MPIDI_FUNC_EXIT(MPID_STATE_MPIDI_CH3I_RDMA_READ_DATAV);
	return error;
    }
#endif
    head = shmq->head_index;
    tail = shmq->tail_index;

    if (head == tail)
    {
	*num_bytes_ptr = 0;
	MPIDI_FUNC_EXIT(MPID_STATE_MPIDI_CH3I_RDMA_READ_DATAV);
	return MPI_SUCCESS;
    }

    MPIU_DBG_PRINTF(("MPIDI_CH3I_SHM_read_progress: reading from queue %p\n", shmq));

    if (head < tail)
    {
	num_avail_right = num_avail = tail - head;
    }
    else
    {
	num_avail = tail + MPIDI_CH3I_QUEUE_DATASIZE - head;
	num_avail_right = MPIDI_CH3I_QUEUE_DATASIZE - head;
    }

    /*printf("[%d] read - avail = %d, avail_right = %d, head = %d, tail = %d\n", MPIR_Process.comm_world->rank, num_avail, num_avail_right, head, tail); fflush(stdout);*/
    cur_pos = &shmq->data[head];
    while (num_avail && iovlen > 0)
    {
	if ((int)iov[iov_index].MPID_IOV_LEN <= num_avail)
	{
	    /* copy the received data */
	    MPIDI_DBG_PRINTF((60, FCNAME, "reading full buffer %d bytes from read_shmq %08p", iov[iov_index].MPID_IOV_LEN, shmq));
	    if (num_avail_right && iov[iov_index].MPID_IOV_LEN > num_avail_right)
	    {
		MPIDI_FUNC_ENTER(MPID_STATE_MEMCPY);
		memcpy(iov[iov_index].MPID_IOV_BUF, cur_pos, num_avail_right);
		memcpy(iov[iov_index].MPID_IOV_BUF + num_avail_right, shmq->data,
		    iov[iov_index].MPID_IOV_LEN - num_avail_right);
		MPIDI_FUNC_EXIT(MPID_STATE_MEMCPY);
		cur_pos = shmq->data + iov[iov_index].MPID_IOV_LEN - num_avail_right;
		num_avail_right = 0;
	    }
	    else
	    {
		MPIDI_FUNC_ENTER(MPID_STATE_MEMCPY);
		memcpy(iov[iov_index].MPID_IOV_BUF, cur_pos, iov[iov_index].MPID_IOV_LEN);
		MPIDI_FUNC_EXIT(MPID_STATE_MEMCPY);
		cur_pos += iov[iov_index].MPID_IOV_LEN;
		if (num_avail_right)
		    num_avail_right -= iov[iov_index].MPID_IOV_LEN;
	    }
	    num_avail -= iov[iov_index].MPID_IOV_LEN;
	    total += iov[iov_index].MPID_IOV_LEN;
	    iov_index++;
	    iovlen--;
	    /*printf("num_avail=%d, total=%d, iov_index=%d, iovlen=%d\n", num_avail, total, iov_index, iovlen);fflush(stdout);*/
	}
	else
	{
	    /* copy the received data */
	    MPIDI_DBG_PRINTF((60, FCNAME, "reading partial buffer %d bytes from read_shmq %08p", num_avail, shmq));
	    if (num_avail_right && num_avail > num_avail_right)
	    {
		MPIDI_FUNC_ENTER(MPID_STATE_MEMCPY);
		memcpy(iov[iov_index].MPID_IOV_BUF, cur_pos, num_avail_right);
		memcpy(iov[iov_index].MPID_IOV_BUF + num_avail_right, shmq->data, num_avail - num_avail_right);
		MPIDI_FUNC_EXIT(MPID_STATE_MEMCPY);
		cur_pos = shmq->data + num_avail - num_avail_right;
		/*num_avail_right = 0;*/
	    }
	    else
	    {
		MPIDI_FUNC_ENTER(MPID_STATE_MEMCPY);
		memcpy(iov[iov_index].MPID_IOV_BUF, cur_pos, num_avail);
		MPIDI_FUNC_EXIT(MPID_STATE_MEMCPY);
		cur_pos += num_avail;
		/*
		if (num_avail_right)
		    num_avail_right -= num_avail;
		*/
	    }
	    total += num_avail;
	    /*num_avail = 0;*/
	    break;
	}
    }

    new_head = (unsigned int)((char*)cur_pos - (char*)shmq->data);
    if (new_head == MPIDI_CH3I_QUEUE_DATASIZE)
	shmq->head_index = 0;
    else
	shmq->head_index = new_head;
    *num_bytes_ptr = total;
    /*printf("[%d]shm head = %6d, total read    = %6d\n", MPIR_Process.comm_world->rank, shmq->head_index, total); fflush(stdout);*/
    MPIDI_FUNC_EXIT(MPID_STATE_MPIDI_CH3I_RDMA_READ_DATAV);
    return MPI_SUCCESS;
}
