/* -*- Mode: C; c-basic-offset:4 ; -*- */
/*
 *  (C) 2001 by Argonne National Laboratory.
 *      See COPYRIGHT in top-level directory.
 */
#ifndef MPIDI_CH3_RDMA_PRE_H
#define MPIDI_CH3_RDMA_PRE_H

#if defined (HAVE_SHM_OPEN) && defined (HAVE_MMAP)
#define USE_POSIX_SHM
#elif defined (HAVE_SHMGET) && defined (HAVE_SHMAT) && defined (HAVE_SHMCTL) && defined (HAVE_SHMDT)
#define USE_SYSV_SHM
#elif defined (HAVE_WINDOWS_H)
#define USE_WINDOWS_SHM
#else
#error No shared memory subsystem defined
#endif

#define MPIDI_MAX_SHM_NAME_LENGTH 100

#define MPIDI_CH3I_QUEUE_DATASIZE (256*1024 - 2*sizeof(int))

typedef struct MPIDI_CH3I_SHM_Queue_t
{
    volatile unsigned int head_index;
    volatile unsigned int tail_index;
    /* insert stuff here to align the data? */
    /*char pad[56];*/ /* cache align the data */
    char data[MPIDI_CH3I_QUEUE_DATASIZE];
} MPIDI_CH3I_SHM_Queue_t;

typedef struct MPIDI_CH3I_RDMA_VC
{
    struct MPIDI_CH3I_SHM_Queue_t * shm, * read_shmq, * write_shmq;
    int shm_state;
#ifdef HAVE_SHARED_PROCESS_READ
#ifdef HAVE_WINDOWS_H
    HANDLE hSharedProcessHandle;
#else
    int nSharedProcessID;
    int nSharedProcessFileDescriptor;
#endif
#endif
} MPIDI_CH3I_RDMA_VC;

#define MPIDI_CH3I_VC_RDMA_DECL MPIDI_CH3I_RDMA_VC shm;

#endif /* MPIDI_CH3_RDMA_PRE_H */
