/* -*- Mode: C; c-basic-offset:4 ; -*- */
/*
 *  (C) 2001 by Argonne National Laboratory.
 *      See COPYRIGHT in top-level directory.
 */

#include "rdma_impl.h"

/* global rmda structure for the local process */
MPIDI_CH3I_RDMA_Process_t MPIDI_CH3I_RDMA_Process;

#undef FUNCNAME
#define FUNCNAME MPIDI_CH3I_RDMA_init_process_group
#undef FCNAME
#define FCNAME MPIDI_QUOTE(FUNCNAME)
int MPIDI_CH3I_RDMA_init_process_group(int * has_parent)
{
    MPIDI_CH3I_Process_group_t * pg;

    start_pes(0);

    pg = MPIU_Malloc(sizeof(MPIDI_CH3I_Process_group_t));
    if (pg == NULL)
    {
	return MPIR_Err_create_code(MPI_SUCCESS, MPIR_ERR_FATAL, FCNAME, __LINE__, MPI_ERR_OTHER, "**nomem", "**nomem %s", "process group");
    }
    pg->size = _num_pes();
    pg->rank = _my_pe();
    pg->kvs_name = NULL;
    pg->ref_count = 1;
    pg->nRDMAWaitSpinCount = MPIDI_CH3I_SPIN_COUNT_DEFAULT;
    pg->nRDMAWaitYieldCount = MPIDI_CH3I_YIELD_COUNT_DEFAULT;

    *has_parent = FALSE;

    return MPI_SUCCESS;
}

#undef FUNCNAME
#define FUNCNAME MPIDI_CH3I_RMDA_init
#undef FCNAME
#define FCNAME MPIDI_QUOTE(FUNCNAME)
int MPIDI_CH3I_RMDA_init(int *rank_ptr, int *size_ptr)
{
    int error;
    int pg_rank, pg_size;
    MPIDI_VC *vc_table;
    int i, j, k;
    int shm_block;

    MPIDI_CH3I_RDMA_Process.rank = pg_rank = MPIDI_CH3I_Process.pg->rank;
    pg_size = MPIDI_CH3I_Process.pg->size;
    vc_table = MPIDI_CH3I_Process.pg->vc_table;

    shm_block = sizeof(MPIDI_CH3I_SHMEM_Queue_t) * pg_size;

    MPIDI_CH3I_RDMA_Process.addr = shmalloc(shm_block);
    if (MPIDI_CH3I_RDMA_Process.addr == NULL)
    {
	return MPIR_Err_create_code(MPI_SUCCESS, MPIR_ERR_FATAL, FCNAME, __LINE__, MPI_ERR_OTHER, "**nomem", "**nomem %s", "shmalloc block");
    }

    for (i=0; i<pg_size; i++)
    {
	if (i == pg_rank)
	{
	    vc_table[i].shmem.shmem = (MPIDI_CH3I_SHMEM_Queue_t*)MPIDI_CH3I_RDMA_Process.addr;
	    for (j=0; j<pg_size; j++)
	    {
		vc_table[i].shmem.shmem[j].recv_tokens = MPIDI_CH3I_NUM_PACKETS;
		vc_table[i].shmem.shmem[j].recv_pos = 0;
		vc_table[i].shmem.shmem[j].send_tokens = MPIDI_CH3I_NUM_PACKETS;
		vc_table[i].shmem.shmem[j].send_pos = 0;
		for (k=0; k<MPIDI_CH3I_NUM_PACKETS; k++)
		{
		    vc_table[i].shmem.shmem[j].packet[k].offset = 0;
		    vc_table[i].shmem.shmem[j].packet[k].avail = MPIDI_CH3I_PKT_EMPTY;
		}
	    }
	}
	else
	{
	    vc_table[i].shmem.shmem = NULL;
	    vc_table[i].shmem.write_shmq = &vc_table[pg_rank].shmem.shmem[i];
	    vc_table[i].shmem.read_shmq = &vc_table[pg_rank].shmem.shmem[i];
	    vc_table[i].rdma.req->ch3.iov[0].MPID_IOV_BUF = (void *)&vc_table[i].rdma.req->rdma.pkt;
	    vc_table[i].rdma.req->ch3.iov[0].MPID_IOV_LEN = sizeof(MPIDI_CH3_Pkt_t);
	    vc_table[i].rdma.req->ch3.iov_count = 1;
	    vc_table[i].rdma.req->rdma.iov_offset = 0;
	    vc_table[i].rdma.req->ch3.ca = MPIDI_CH3I_CA_HANDLE_PKT;
	    vc_table[i].rdma.recv_active = vc_table[i].rdma.req;
	    MPIDI_CH3I_post_read( &vc_table[i] , &vc_table[i].rdma.req->rdma.pkt, sizeof(vc_table[i].rdma.req->rdma.pkt));
	}
    }

    shmem_barrier_all(); /* synchronize queue initialization */

    return MPI_SUCCESS;
}

#undef FUNCNAME
#define FUNCNAME MPIDI_CH3I_RMDA_finalize
#undef FCNAME
#define FCNAME MPIDI_QUOTE(FUNCNAME)
int MPIDI_CH3I_RMDA_finalize()
{
    if (MPIDI_CH3I_RDMA_Process.addr)
	shfree(MPIDI_CH3I_RDMA_Process.addr);
    MPIDI_CH3I_RDMA_Process.addr = NULL;
    return MPI_SUCCESS;
}
