/* -*- Mode: C; c-basic-offset:4 ; -*- */
/*
 *  (C) 2001 by Argonne National Laboratory.
 *      See COPYRIGHT in top-level directory.
 */
#ifndef MPIDI_CH3_RDMA_PRE_H
#define MPIDI_CH3_RDMA_PRE_H

/* Use this header to append implementation specific fields
   to mpich2 structures.
   The most common use is to add fields to the vc structure
   that are specific to the rdma implementation */

#define MPIDI_CH3I_NUM_PACKETS          16
#define MPIDI_CH3I_PACKET_SIZE         (16*1024)

/* This structure uses the avail field to signal that the data is available for reading.
   The code fills the data and then sets the avail field.
   This assumes that declaring avail to be volatile causes the compiler to insert a
   write barrier when the avail location is written to.
   */
typedef struct MPIDI_CH3I_SHMEM_Packet_t
{
    int avail;
    int pad;
    int num_bytes;
    int offset;
    char data[MPIDI_CH3I_PACKET_SIZE];
} MPIDI_CH3I_SHMEM_Packet_t;

typedef struct MPIDI_CH3I_SHMEM_Queue_t
{
    /*
    int head_index;
    int tail_index;
    */
    int recv_tokens;
    int recv_pos;
    int send_tokens;
    int send_pos;
    MPIDI_CH3I_SHMEM_Packet_t packet[MPIDI_CH3I_NUM_PACKETS];
} MPIDI_CH3I_SHMEM_Queue_t;


typedef struct MPIDI_CH3I_RDMA_VC
{
    struct MPIDI_CH3I_SHMEM_Queue_t * shmem, * read_shmq, * write_shmq;
    int shmem_state;
} MPIDI_CH3I_RDMA_VC;

#define MPIDI_CH3I_VC_RDMA_DECL MPIDI_CH3I_RDMA_VC shmem;

#endif /* MPIDI_CH3_RDMA_PRE_H */
