/* -*- Mode: C; c-basic-offset:4 ; -*- */
/*
 *  (C) 2001 by Argonne National Laboratory.
 *      See COPYRIGHT in top-level directory.
 */

#include "mpidi_ch3_impl.h"

#define USE_AGGRESSIVE_READ

#ifdef USE_AGGRESSIVE_READ

static inline int post_pkt_recv(MPIDI_VC *vc)
{
    int error;
    MPIDI_STATE_DECL(MPID_STATE_POST_PKT_RECV);
    MPIDI_FUNC_ENTER(MPID_STATE_POST_PKT_RECV);
    vc->rdma.req->ch3.iov[0].MPID_IOV_BUF = (void *)&vc->rdma.req->rdma.pkt;
    vc->rdma.req->ch3.iov[0].MPID_IOV_LEN = sizeof(MPIDI_CH3_Pkt_t);
    vc->rdma.req->ch3.iov_count = 1;
    vc->rdma.req->rdma.iov_offset = 0;
    vc->rdma.req->ch3.ca = MPIDI_CH3I_CA_HANDLE_PKT;
    vc->rdma.recv_active = vc->rdma.req;
    error = MPIDI_CH3I_post_read( vc , &vc->rdma.req->rdma.pkt, sizeof(vc->rdma.req->rdma.pkt));
    MPIDI_FUNC_EXIT(MPID_STATE_POST_PKT_RECV);
    return error;
}

/*
 * MPIDI_CH3_iRead()
 */
#undef FUNCNAME
#define FUNCNAME MPIDI_CH3_iRead
#undef FCNAME
#define FCNAME MPIDI_QUOTE(FUNCNAME)
int MPIDI_CH3_iRead(MPIDI_VC * vc, MPID_Request * rreq)
{
    int error;
    MPIDI_msg_sz_t num_bytes;
    MPIDI_STATE_DECL(MPID_STATE_MEMCPY);
    MPIDI_STATE_DECL(MPID_STATE_MPIDI_CH3_IREAD);

    MPIDI_FUNC_ENTER(MPID_STATE_MPIDI_CH3_IREAD);
    MPIDI_DBG_PRINTF((60, FCNAME, "ch3_iread\n"));

    rreq->rdma.iov_offset = 0;

    error = MPIDI_CH3I_RDMA_read_datav(vc, rreq->ch3.iov + rreq->rdma.iov_offset, rreq->ch3.iov_count - rreq->rdma.iov_offset, &num_bytes);
    if (error != MPI_SUCCESS)
    {
	error = MPIR_Err_create_code(error, MPIR_ERR_FATAL, FCNAME, __LINE__, MPI_ERR_OTHER, "**ch3ireadaggressive", 0);
	MPIDI_FUNC_EXIT(MPID_STATE_MPIDI_CH3_IREAD);
	return error;
    }

    if (num_bytes && MPIDI_CH3I_Request_adjust_iov(rreq, num_bytes))
    {
	vc->rdma.recv_active = NULL;

	if (rreq->ch3.ca == MPIDI_CH3_CA_COMPLETE)
	{
	    /* mark data transfer as complete and decrement CC */
	    rreq->ch3.iov_count = 0;
	    MPIDI_CH3U_Request_complete(rreq);
	}
	else
	{
	    /* FIXME: excessive recursion... */
	    MPIDI_CH3U_Handle_recv_req(vc, rreq);
	}
    }
    else
    {
	vc->rdma.recv_active = rreq;
	assert(rreq->ch3.iov_count - rreq->rdma.iov_offset > 0);
	error = MPIDI_CH3I_post_readv(vc, rreq->ch3.iov + rreq->rdma.iov_offset, rreq->ch3.iov_count - rreq->rdma.iov_offset);
	if (error != MPI_SUCCESS)
	{
	    error = MPIR_Err_create_code(error, MPIR_ERR_FATAL, FCNAME, __LINE__, MPI_ERR_OTHER, "**ch3ireadaggressive", 0);
	    MPIDI_FUNC_EXIT(MPID_STATE_MPIDI_CH3_IREAD);
	    return error;
	}
    }
    MPIDI_FUNC_EXIT(MPID_STATE_MPIDI_CH3_IREAD);
    return MPI_SUCCESS;
}

#else /* USE_AGGRESSIVE_READ */

/*
 * MPIDI_CH3_iRead()
 */
#undef FUNCNAME
#define FUNCNAME MPIDI_CH3_iRead
#undef FCNAME
#define FCNAME MPIDI_QUOTE(FUNCNAME)
void MPIDI_CH3_iRead(MPIDI_VC * vc, MPID_Request * rreq)
{
    MPIDI_STATE_DECL(MPID_STATE_MPIDI_CH3_IREAD);

    MPIDI_FUNC_ENTER(MPID_STATE_MPIDI_CH3_IREAD);
    MPIDI_DBG_PRINTF((60, FCNAME, "ch3_iread\n"));

    rreq->rdma.iov_offset = 0;
    vc->rdma.recv_active = rreq;
    MPIDI_CH3I_post_readv(vc, rreq->ch3.iov + rreq->rdma.iov_offset, rreq->ch3.iov_count - rreq->rdma.iov_offset);

    MPIDI_FUNC_EXIT(MPID_STATE_MPIDI_CH3_IREAD);
}

#endif /* USE_AGGRESSIVE_READ */
