/* -*- Mode: C; c-basic-offset:4 ; -*- */
/* 
 *   $Id: ad_pvfs2_common.c,v 1.7 2003/09/05 20:43:58 robl Exp $
 *
 *   Copyright (C) 2003 University of Chicago. 
 *   See COPYRIGHT notice in top-level directory.
 */

#include "ad_pvfs2.h"
#include "ad_pvfs2_common.h"
#include <unistd.h>
#include <sys/types.h>

/* maybe give romio access to the globalconfig struct */
/* keyval hack to both tell us if we've already initialized pvfs2 and also
 * close it down when mpi exits */
int ADIOI_PVFS2_Initialized = MPI_KEYVAL_INVALID;

PVFS_fs_id * ADIOI_PVFS2_fs_id_list;
pvfs_mntlist ADIOI_PVFS2_mntlist;

void ADIOI_PVFS2_End(int *error_code)
{
    int ret;
    ret = PVFS_sys_finalize();
    if (ret < 0 ) {
	*error_code = MPI_UNDEFINED;
    } else {
	*error_code = MPI_SUCCESS;
    }
}

int ADIOI_PVFS2_End_call(MPI_Comm comm, int keyval, 
	void *attribute_val, void *extra_state)
{
    int error_code;
    ADIOI_PVFS2_End(&error_code);
    return error_code;
}

void ADIOI_PVFS2_Init(int *error_code )
{
	PVFS_sysresp_init resp_init;
	int ret;

	/* do nothing if we've already fired up the pvfs2 interface */
	if (ADIOI_PVFS2_Initialized != MPI_KEYVAL_INVALID) {
		*error_code = MPI_SUCCESS;
		return;
	}

	ret = PVFS_util_parse_pvfstab(&ADIOI_PVFS2_mntlist);
	if (ret < 0) {
	    /* XXX: better error handling */
	    fprintf(stderr, "error parsing pvfstab\n");
	    *error_code = MPI_UNDEFINED;
	    return;
	}
	ret = PVFS_sys_initialize(ADIOI_PVFS2_mntlist, ADIOI_PVFS2_DEBUG_MASK, 
		&resp_init);
	if (ret < 0 ) {
	    /* XXX: better error handling */
	    fprintf(stderr, "error initializing pvfs\n");
	    *error_code = MPI_UNDEFINED;
	    return;
	}
	ADIOI_PVFS2_fs_id_list = resp_init.fsid_list;
	MPI_Keyval_create(MPI_NULL_COPY_FN, ADIOI_PVFS2_End_call,
		&ADIOI_PVFS2_Initialized, (void *)0); 
	/* just like romio does, we make a dummy attribute so we 
	 * get cleaned up */
	MPI_Attr_put(MPI_COMM_WORLD, ADIOI_PVFS2_Initialized, (void *)0);
}

void ADIOI_PVFS2_makeattribs(PVFS_sys_attr * attribs)
{
    memset(attribs, 0, sizeof(PVFS_sys_attr));

    attribs->owner = geteuid();
    attribs->group = getegid();
    attribs->perms = 1877;
    attribs->mask =  PVFS_ATTR_SYS_ALL_SETABLE;
}


void ADIOI_PVFS2_makecredentials(PVFS_credentials * credentials)
{
    memset(credentials, 0, sizeof(PVFS_credentials));

    credentials->uid = geteuid();
    credentials->gid = getegid();
}

/* pvfs_error_convert: given a pvfs error code, make it into the appropriate
 * mpi error code */ 
int ADIOI_PVFS2_pvfs_error_convert(int pvfs_error, int *mpi_error)
{
    *mpi_error = MPI_UNDEFINED;
    return 0;
}
/* 
 * vim: ts=8 sts=4 sw=4 noexpandtab 
 */
