/* -*- Mode: C++; c-basic-offset:4 ; -*- */
/*  
 *  (C) 2001 by Argonne National Laboratory.
 *      See COPYRIGHT in top-level directory.
 *
 * This file is automatically generated by buildiface -nosep
 * DO NOT EDIT
 */
/* style: c++ header */

#include "mpi.h"
#include "mpicxx.h"
#include <stdarg.h>
namespace MPI {
Datatype CHAR(MPI_CHAR);
Datatype UNSIGNED_CHAR(MPI_UNSIGNED_CHAR);
Datatype BYTE(MPI_BYTE);
Datatype SHORT(MPI_SHORT);
Datatype UNSIGNED_SHORT(MPI_UNSIGNED_SHORT);
Datatype INT(MPI_INT);
Datatype UNSIGNED(MPI_UNSIGNED);
Datatype LONG(MPI_LONG);
Datatype UNSIGNED_LONG(MPI_UNSIGNED_LONG);
Datatype FLOAT(MPI_FLOAT);
Datatype DOUBLE(MPI_DOUBLE);
Datatype LONG_DOUBLE(MPI_LONG_DOUBLE);
Datatype LONG_LONG_INT(MPI_LONG_LONG_INT);
Datatype LONG_LONG(MPI_LONG_LONG);
Datatype PACKED(MPI_PACKED);
Datatype LB(MPI_LB);
Datatype UB(MPI_UB);
Datatype FLOAT_INT(MPI_FLOAT_INT);
Datatype DOUBLE_INT(MPI_DOUBLE_INT);
Datatype LONG_INT(MPI_LONG_INT);
Datatype SHORT_INT(MPI_SHORT_INT);
Datatype LONG_DOUBLE_INT(MPI_LONG_DOUBLE_INT);
Datatype TWOINT(MPI_2INT);
Datatype DATATYPE_NULL;

#ifdef HAVE_FORTRAN_BINDING
Datatype INTEGER(MPI_INTEGER);
Datatype REAL(MPI_REAL);
Datatype DOUBLE_PRECISION(MPI_DOUBLE_PRECISION);
Datatype F_COMPLEX(MPI_COMPLEX);
Datatype F_DOUBLE_COMPLEX(MPI_DOUBLE_COMPLEX);
Datatype LOGICAL(MPI_LOGICAL);
Datatype CHARACTER(MPI_CHARACTER);
Datatype TWOREAL(MPI_2REAL);
Datatype TWODOUBLE_PRECISION(MPI_2DOUBLE_PRECISION);
Datatype TWOINTEGER(MPI_2INTEGER);
#endif
const Op MAX(MPI_MAX);
const Op MIN(MPI_MIN);
const Op SUM(MPI_SUM);
const Op PROD(MPI_PROD);
const Op LAND(MPI_LAND);
const Op BAND(MPI_BAND);
const Op LOR(MPI_LOR);
const Op BOR(MPI_BOR);
const Op LXOR(MPI_LXOR);
const Op BXOR(MPI_BXOR);
const Op MINLOC(MPI_MINLOC);
const Op MAXLOC(MPI_MAXLOC);
const Op REPLACE(MPI_REPLACE);
const Op OP_NULL;
Intracomm COMM_WORLD(MPI_COMM_WORLD);
Intracomm COMM_SELF(MPI_COMM_SELF);
const Comm COMM_NULL;
const Group GROUP_EMPTY(MPI_GROUP_EMPTY);
const Group GROUP_NULL;
const Request REQUEST_NULL;
const Errhandler ERRHANDLER_NULL;
const Errhandler ERRORS_RETURN(MPI_ERRORS_RETURN);
const Errhandler ERRORS_ARE_FATAL(MPI_ERRORS_ARE_FATAL);
const Errhandler ERRORS_THROW_EXCEPTIONS(MPI_ERRORS_RETURN);
const int BSEND_OVERHEAD = MPI_BSEND_OVERHEAD;
const int KEYVAL_INVALID = MPI_KEYVAL_INVALID;
const int CART = MPI_CART;
const int GRAPH = MPI_GRAPH;
const int IDENT = MPI_IDENT;
const int SIMILAR = MPI_SIMILAR;
const int CONGRUENT = MPI_CONGRUENT;
const int UNEQUAL = MPI_UNEQUAL;
const int PROC_NULL = MPI_PROC_NULL;
const int ANY_TAG = MPI_ANY_TAG;
const int ANY_SOURCE = MPI_ANY_SOURCE;
const int ROOT = MPI_ROOT;
const int TAG_UB = MPI_TAG_UB;
const int IO = MPI_IO;
const int HOST = MPI_HOST;
const int WTIME_IS_GLOBAL = MPI_WTIME_IS_GLOBAL;
const int UNIVERSE_SIZE = MPI_UNIVERSE_SIZE;
const int LASTUSEDCODE = MPI_LASTUSEDCODE;
const int APPNUM = MPI_APPNUM;
const int MAX_PROCESSOR_NAME = MPI_MAX_PROCESSOR_NAME;
const int MAX_ERROR_STRING = MPI_MAX_ERROR_STRING;
const int MAX_NAME_STRING = MPI_MAX_NAME_STRING;
const int MAX_PORT_NAME = MPI_MAX_PORT_NAME;
const int MAX_OBJECT_NAME = MPI_MAX_OBJECT_NAME;
const int MAX_INFO_VAL = MPI_MAX_INFO_VAL;
const int MAX_INFO_KEY = MPI_MAX_INFO_KEY;
const int UNDEFINED = MPI_UNDEFINED;
const int SUCCESS = MPI_SUCCESS;
const int ERR_BUFFER = MPI_ERR_BUFFER;
const int ERR_COUNT = MPI_ERR_COUNT;
const int ERR_TYPE = MPI_ERR_TYPE;
const int ERR_TAG = MPI_ERR_TAG;
const int ERR_COMM = MPI_ERR_COMM;
const int ERR_RANK = MPI_ERR_RANK;
const int ERR_REQUEST = MPI_ERR_REQUEST;
const int ERR_ROOT = MPI_ERR_ROOT;
const int ERR_GROUP = MPI_ERR_GROUP;
const int ERR_OP = MPI_ERR_OP;
const int ERR_TOPOLOGY = MPI_ERR_TOPOLOGY;
const int ERR_DIMS = MPI_ERR_DIMS;
const int ERR_ARG = MPI_ERR_ARG;
const int ERR_UNKNOWN = MPI_ERR_UNKNOWN;
const int ERR_TRUNCATE = MPI_ERR_TRUNCATE;
const int ERR_OTHER = MPI_ERR_OTHER;
const int ERR_INTERN = MPI_ERR_INTERN;
const int ERR_PENDING = MPI_ERR_PENDING;
const int ERR_IN_STATUS = MPI_ERR_IN_STATUS;
const int ERR_LASTCODE = MPI_ERR_LASTCODE;
const int ERR_FILE = MPI_ERR_FILE;
const int ERR_ACCESS = MPI_ERR_ACCESS;
const int ERR_AMODE = MPI_ERR_AMODE;
const int ERR_BAD_FILE = MPI_ERR_BAD_FILE;
const int ERR_FILE_EXISTS = MPI_ERR_FILE_EXISTS;
const int ERR_FILE_IN_USE = MPI_ERR_FILE_IN_USE;
const int ERR_NO_SPACE = MPI_ERR_NO_SPACE;
const int ERR_NO_SUCH_FILE = MPI_ERR_NO_SUCH_FILE;
const int ERR_IO = MPI_ERR_IO;
const int ERR_READ_ONLY = MPI_ERR_READ_ONLY;
const int ERR_CONVERSION = MPI_ERR_CONVERSION;
const int ERR_DUP_DATAREP = MPI_ERR_DUP_DATAREP;
const int ERR_UNSUPPORTED_DATAREP = MPI_ERR_UNSUPPORTED_DATAREP;
const int ERR_INFO = MPI_ERR_INFO;
const int ERR_INFO_KEY = MPI_ERR_INFO_KEY;
const int ERR_INFO_VALUE = MPI_ERR_INFO_VALUE;
const int ERR_INFO_NOKEY = MPI_ERR_INFO_NOKEY;
const int ERR_NAME = MPI_ERR_NAME;
const int ERR_NO_MEM = MPI_ERR_NO_MEM;
const int ERR_NOT_SAME = MPI_ERR_NOT_SAME;
const int ERR_PORT = MPI_ERR_PORT;
const int ERR_QUOTA = MPI_ERR_QUOTA;
const int ERR_SERVICE = MPI_ERR_SERVICE;
const int ERR_SPAWN = MPI_ERR_SPAWN;
const int ERR_UNSUPPORTED_OPERATION = MPI_ERR_UNSUPPORTED_OPERATION;
const int ERR_WIN = MPI_ERR_WIN;
const int ERR_BASE = MPI_ERR_BASE;
const int ERR_LOCKTYPE = MPI_ERR_LOCKTYPE;
const int ERR_KEYVAL = MPI_ERR_KEYVAL;
const int ERR_RMA_CONFLICT = MPI_ERR_RMA_CONFLICT;
const int ERR_RMA_SYNC = MPI_ERR_RMA_SYNC;
const int ERR_SIZE = MPI_ERR_SIZE;
const int ERR_DISP = MPI_ERR_DISP;
const int ERR_ASSERT = MPI_ERR_ASSERT;
const void *BOTTOM = MPI_BOTTOM;
void Init( void ){
    MPI_Init( 0, 0 );
}
void Init( int &argc, char **&argv )
{
    MPI_Init( &argc, &argv );
}
void Finalize( void ){
    MPI_Finalize( );
}
bool Is_initialized(void)
    { 
	int flag;
	MPI_Initialized( &flag );
	return (flag == 1);
    }
void Compute_dims( int nnodes, int ndims, int dims[] )
    {
	MPIX_CALL( MPI_Dims_create( nnodes, ndims, dims ) );
    }
void Attach_buffer( void *buffer, int size )
    {
	MPIX_CALL( MPI_Buffer_attach( buffer, size ) );
    }
int Detach_buffer( void *&buffer )
    {
	int size;
	MPIX_CALL( MPI_Buffer_detach( &buffer, &size ) );
	return size;
    }
void Get_processor_name( char *name, int &resultlen ) 
    {
    MPIX_CALL( MPI_Get_processor_name( name, &resultlen ) );
    }
void Pcontrol( int v, ... )
    {
	va_list ap;
        va_start(ap,v);
	MPIX_CALL( MPI_Pcontrol( v, ap ) );
    }
int Get_error_class( int errcode ) 
    {
    int errclass;
    MPIX_CALL( MPI_Error_class( errcode, &errclass ) );
    return errclass;
    }
Aint Get_address( void *ptr )
    {
    MPI_Aint a;
    MPI_Address( ptr, &a );
    return (Aint)a;
    }

extern "C" void MPIR_Op_set_cxx( MPI_Op, void (*)(void) );
extern "C" 
void MPIR_Call_op_fn( void *invec, void *outvec, int len, MPI_Datatype dtype,
		     User_function *uop )
{
    MPI::Datatype cxxdtype = dtype;
    (*uop)( invec, outvec, len, cxxdtype );
}
void Op::Init( User_function *f, bool commute )
    {
	MPIX_CALL( MPI_Op_create( (MPI_User_function *)f, 
				 (int) commute, &the_real_op ) ); 
	MPIR_Op_set_cxx( the_real_op, (void (*)(void)) MPIR_Call_op_fn );
    }

extern "C" int MPIR_Call_delfn( MPI_Comm comm, int keyval,
				   void *value, void *extra_state, 
				   MPI::Comm::Delete_attr_function *f )
{
    MPI::Comm cxxcomm = comm;
    int err;
    err = (*f)( cxxcomm, keyval, value, extra_state );
    return err;  
}
extern "C" int MPIR_Call_copyfn( MPI_Comm comm, int keyval,
				   void *extra_state, void *value,
				    void *new_value, int *cflag,
				   MPI::Comm::Copy_attr_function *f )
{
    MPI::Comm cxxcomm = comm;
    int err;
    bool flag;
    err=(*f)( cxxcomm, keyval, extra_state, value, new_value, flag );
    *cflag = flag;
      return err;
}
extern "C" void MPIR_Keyval_set_cxx( int, void (*)(void), void (*)(void) );
int Comm::Create_keyval( Copy_attr_function *cf, Delete_attr_function *df, 
			void *extra_state ) {
    int keyval;

    if (cf == MPI::Comm::NULL_COPY_FN) cf = 0;
    if (df == MPI::Comm::NULL_DELETE_FN) df = 0;
    MPIX_CALL( MPI_Comm_create_keyval( (MPI_Comm_copy_attr_function *)cf, 
				       (MPI_Comm_delete_attr_function *)df,
				      &keyval, extra_state ) );
    MPIR_Keyval_set_cxx( keyval, (void (*)(void)) MPIR_Call_delfn, 
			         (void (*)(void)) MPIR_Call_copyfn );
    return keyval;
}

    void Datatype::Pack( const void *inbuf, int incount, void *outbuf, 
			int outsize, int &position, const Comm &comm ) {
	MPIX_CALL( MPI_Pack( (void *)inbuf, incount, the_real_datatype, outbuf, 
			    outsize, &position, comm.the_real_comm ) );
    }
    void Datatype::Unpack( const void *inbuf, int insize, void *outbuf,
			  int outcount, int &position, const Comm &comm ) {
	MPIX_CALL( MPI_Unpack( (void *)inbuf, insize, &position, outbuf, outcount, 
			      the_real_datatype, comm.the_real_comm ) );
    }

double Wtime(void) { return MPI_Wtime(); }
double Wtick(void) { return MPI_Wtick(); }
} // namespace MPI
