dnl
dnl Definitions for creating shared libraries
dnl
dnl The purpose of these definitions is to provide common support for 
dnl shared libraries, with *or without* the use of the GNU Libtool package.
dnl For many of our important platforms, the Libtool approach is overkill,
dnl and can be particularly painful for developers.
dnl
dnl/*D
dnl PAC_ARG_SHAREDLIBS - Add --enable-sharedlibs=kind to configure.
dnl 
dnl Synopsis:
dnl PAC_ARG_SHAREDLIBS
dnl
dnl Output effects:
dnl Adds '--enable-sharedlibs=kind' to the command line.  If this is enabled,
dnl then based on the value of 'kind', programs are selected for the 
dnl names 'CC_SHL' and 'CC_LINK_SHL' that configure will substitute for in
dnl 'Makefile.in's.  These symbols are generated by 'simplemake' when
dnl shared library support is selected.
dnl
dnl Supported values of 'kind' include \:
dnl+    gcc - Use gcc to create both shared objects and libraries
dnl-    none - The same as '--disable-sharedlibs'
dnl
dnl Others will be added as experience dictates.  Likely names are
dnl + libtool - For general GNU libtool
dnl . linux-pgcc - For Portland group under Linux
dnl - solaris-cc - For Solaris C compiler
dnl
dnl Notes:
dnl Shared libraries are only partially implemented.  Additional symbols
dnl will probably be defined, including symbols to specify how shared library
dnl search paths are specified and how shared library names are set.
dnl D*/
AC_DEFUN(PAC_ARG_SHAREDLIBS,[
AC_ARG_ENABLE(sharedlibs,
[--enable-sharedlibs=kind - Enable shared libraries.  kind may be
    gcc     - Standard gcc and GNU ld options for creating shared libraries
    libtool - GNU libtool 
    none    - same as --disable-sharedlibs
Only gcc is currently supported],
,enable_sharedlibs=none)
dnl
CC_SHL=true
C_LINK_SHL=true
case "$enable_sharedlibs" in 
    no|none)
    ;;
    gcc)
    AC_MSG_RESULT([Creating shared libraries using GNU])
    # Not quite right yet.  See mpich/util/makesharedlib
    # Use syntax that works in both Make and the shell
    #C_LINK_SHL='${CC} -shared -Wl,-r'
    C_LINK_SHL='${CC} -shared'
    # For example, include the libname as ${LIBNAME_SHL}
    #C_LINK_SHL='${CC} -shared -Wl,-h,<finallibname>'
    CC_SHL='${CC} -shared -fpic'
    ;;
    libtool)
    AC_MSG_RESULT([Creating shared libraries using libtool (not yet supported)])
    AC_CHECK_PROGS(LIBTOOL,libtool,false)
    if test "$LIBTOOL" = "false" ; then
	AC_MSG_WARN([Could not find libtool])
    else
        # Likely to be
        # either CC or CC_SHL is libtool $cc
        CC_SHL='libtool ${CC}'
        # CC_LINK_SHL includes the final installation path
        # For many systems, the link may need to include *all* libraries
        # (since many systems don't allow any unsatisfied dependencies)
        C_LINK_SHL='libtool ${CC} -rpath ${libdir}'
    fi
    ;;
dnl
dnl Other, such as solaris-cc
    *)
    AC_MSG_WARN([Unknown value $enable_sharedlibs for enable-sharedlibs])
    enable_sharedlibs=no
    ;;  
esac
AC_SUBST(CC_SHL)
AC_SUBST(C_LINK_SHL)
])

dnl /*D
dnl PAC_xx_SHAREDLIBS - Get compiler and linker for shared libraries
dnl These routines may be used to determine the compiler and the
dnl linker to be used in creating shared libraries
dnl Rather than set predefined variable names, they set an argument 
dnl (if provided)
dnl
dnl Synopsis
dnl PAC_CC_SHAREDLIBS(type,CCvar,CLINKvar)
dnl D*/
AC_DEFUN(PAC_CC_SHAREDLIBS,
[
pac_kinds=$1
ifelse($1,,[
    pac_prog=""
    AC_CHECK_PROG(pac_prog,gcc,yes,no)
    if test "$pac_prog" = yes ; then pac_kinds=gcc ; fi
    pac_prog=""
    AC_CHECK_PROG(pac_prog,libtool,yes,no)
    if test "$pac_prog" = yes ; then pac_kinds="$pac_kinds libtool" ; fi
])
for pac_arg in $pac_kinds ; do
    case $pac_arg in 
    gcc)
    # For example, include the libname as ${LIBNAME_SHL}
    #C_LINK_SHL='${CC} -shared -Wl,-h,<finallibname>'
    pac_cc_sharedlibs='gcc -shared -fpic'
    pac_clink_sharedlibs='gcc -shared'
    ;;
    libtool)
    AC_CHECK_PROGS(LIBTOOL,libtool,false)
    if test "$LIBTOOL" = "false" ; then
	AC_MSG_WARN([Could not find libtool])
    else
        # Likely to be
        # either CC or CC_SHL is libtool $cc
        pac_cc_sharedlibs'libtool ${CC}'
        pac_clink_sharedlibs='libtool ${CC} -rpath ${libdir}'
    fi
    ;;
    *)
    ;;
    esac
    if test -n "$pac_cc_sharedlibs" ; then break ; fi
done
if test -z "$pac_cc_sharedlibs" ; then pac_cc_sharedlibs=true ; fi
if test -z "$pac_clink_sharedlibs" ; then pac_clink_sharedlibs=true ; fi
ifelse($2,,CC_SHL=$pac_cc_sharedlibs,$2=$pac_cc_sharedlibs)
ifelse($3,,C_LINK_SHL=$pac_clink_sharedlibs,$3=$pac_clink_sharedlibs)
])
