/*
 * Decompiled with CFR 0.152.
 */
package base.drawable;

import java.awt.Color;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class ColorAlpha
extends Color {
    public static final int BYTESIZE = 5;
    public static final int OPAQUE = 255;
    public static final int NEAR_OPAQUE = 191;
    public static final int HALF_OPAQUE = 127;
    public static final int NEAR_TRANSPARENT = 63;
    public static final int TRANSPARENT = 0;
    private boolean isModifiable;

    public ColorAlpha() {
        super(255, 192, 203, 255);
        this.isModifiable = true;
    }

    public ColorAlpha(int n, int n2, int n3) {
        super(n, n2, n3, 255);
        this.isModifiable = true;
    }

    public ColorAlpha(Color color, int n) {
        super(color.getRed(), color.getGreen(), color.getBlue(), n);
        this.isModifiable = true;
    }

    public ColorAlpha(int n, int n2, int n3, int n4, boolean bl) {
        super(n, n2, n3, n4);
        this.isModifiable = bl;
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(super.getRGB());
        dataOutput.writeBoolean(this.isModifiable);
    }

    public ColorAlpha(DataInput dataInput) throws IOException {
        super(dataInput.readInt(), true);
        this.isModifiable = dataInput.readBoolean();
    }

    public void readObject(DataInput dataInput) throws IOException {
        System.err.println("ColorAlpha.readObject() should NOT called");
    }

    public String toString() {
        return "(" + this.getRed() + "," + this.getGreen() + "," + this.getBlue() + "," + this.getAlpha() + "," + this.isModifiable + ")";
    }

    public static final void main(String[] stringArray) {
        String string = stringArray[0].trim();
        boolean bl = string.equals("write");
        ColorAlpha colorAlpha = null;
        if (bl) {
            colorAlpha = new ColorAlpha(10, -1, 30, 100, false);
            try {
                FileOutputStream fileOutputStream = new FileOutputStream("tmp_color.dat");
                DataOutputStream dataOutputStream = new DataOutputStream(fileOutputStream);
                colorAlpha.writeObject(dataOutputStream);
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                System.exit(1);
            }
            System.out.println("ColorAlpha " + colorAlpha + " has been written to " + "tmp_color.dat");
        } else {
            try {
                FileInputStream fileInputStream = new FileInputStream("tmp_color.dat");
                DataInputStream dataInputStream = new DataInputStream(fileInputStream);
                colorAlpha = new ColorAlpha(dataInputStream);
                fileInputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                System.exit(1);
            }
            System.out.println("ColorAlpha " + colorAlpha + " has been read from " + "tmp_color.dat");
        }
    }
}

