/*
 * Decompiled with CFR 0.152.
 */
package base.drawable;

import base.drawable.Category;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Comparator;
import java.util.Map;

public class CategoryWeight {
    public static final int BYTESIZE = 12;
    public static final Comparator INDEX_ORDER = new IndexOrder();
    public static final Comparator INCL_RATIO_ORDER = new InclRatioOrder();
    public static final Comparator EXCL_RATIO_ORDER = new ExclRatioOrder();
    public static final int PRINT_ALL_RATIOS = 0;
    public static final int PRINT_INCL_RATIO = 1;
    public static final int PRINT_EXCL_RATIO = 2;
    private static final String TITLE_ALL_RATIOS = "*** All Duration Ratios:";
    private static final String TITLE_INCL_RATIO = "*** Inclusive Duration Ratio:";
    private static final String TITLE_EXCL_RATIO = "*** Exclusive Duration Ratio:";
    private static final int INVALID_INDEX = Integer.MIN_VALUE;
    private int type_idx;
    private Category type;
    private float incl_ratio;
    private float excl_ratio;
    private int width;
    private int height;

    public CategoryWeight() {
        this.type = null;
        this.type_idx = Integer.MIN_VALUE;
        this.incl_ratio = 0.0f;
        this.excl_ratio = 0.0f;
        this.width = 0;
        this.height = 0;
    }

    public CategoryWeight(Category category, float f, float f2) {
        this.type = category;
        this.type_idx = this.type.getIndex();
        this.incl_ratio = f;
        this.excl_ratio = f2;
    }

    public CategoryWeight(CategoryWeight categoryWeight) {
        this.type = categoryWeight.type;
        this.type_idx = categoryWeight.type_idx;
        this.incl_ratio = categoryWeight.incl_ratio;
        this.excl_ratio = categoryWeight.excl_ratio;
    }

    public void setPixelWidth(int n) {
        this.width = n;
    }

    public int getPixelWidth() {
        return this.width;
    }

    public void setPixelHeight(int n) {
        this.height = n;
    }

    public int getPixelHeight() {
        return this.height;
    }

    public Category getCategory() {
        return this.type;
    }

    public float getRatio(boolean bl) {
        if (bl) {
            return this.incl_ratio;
        }
        return this.excl_ratio;
    }

    public void rescaleAllRatios(float f) {
        this.incl_ratio *= f;
        this.excl_ratio *= f;
    }

    public void addAllRatios(CategoryWeight categoryWeight, float f) {
        this.incl_ratio += categoryWeight.incl_ratio * f;
        this.excl_ratio += categoryWeight.excl_ratio * f;
    }

    public void addExclusiveRatio(float f) {
        this.excl_ratio += f;
    }

    public void addInclusiveRatio(float f) {
        this.incl_ratio += f;
    }

    public boolean resolveCategory(Map map) {
        if (this.type == null && this.type_idx != Integer.MIN_VALUE) {
            this.type = (Category)map.get(new Integer(this.type_idx));
            if (this.type != null) {
                return true;
            }
        }
        return false;
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.type_idx);
        dataOutput.writeFloat(this.incl_ratio);
        dataOutput.writeFloat(this.excl_ratio);
    }

    public CategoryWeight(DataInput dataInput) throws IOException {
        this.readObject(dataInput);
    }

    public void readObject(DataInput dataInput) throws IOException {
        this.type_idx = dataInput.readInt();
        this.incl_ratio = dataInput.readFloat();
        this.excl_ratio = dataInput.readFloat();
    }

    public static String getPrintTitle(int n) {
        if (n == 1) {
            return TITLE_INCL_RATIO;
        }
        if (n == 2) {
            return TITLE_EXCL_RATIO;
        }
        return TITLE_ALL_RATIOS;
    }

    public String toInfoBoxString(int n) {
        StringBuffer stringBuffer = new StringBuffer("legend=");
        if (this.type != null) {
            stringBuffer.append(this.type.getName());
        } else {
            stringBuffer.append("null:" + this.type_idx);
        }
        if (n == 1) {
            stringBuffer.append(", ratio=" + this.incl_ratio);
        } else if (n == 2) {
            stringBuffer.append(", ratio=" + this.excl_ratio);
        } else {
            stringBuffer.append(", incl_ratio=" + this.incl_ratio + ", excl_ratio=" + this.excl_ratio);
        }
        return stringBuffer.toString();
    }

    public String toString() {
        if (this.type != null) {
            return "(type=" + this.type_idx + ":" + this.type.getName() + ",wgt=" + this.incl_ratio + "," + this.excl_ratio + ")";
        }
        return "(type=" + this.type_idx + ",wgt=" + this.incl_ratio + "," + this.excl_ratio + ")";
    }

    private static class ExclRatioOrder
    implements Comparator {
        private ExclRatioOrder() {
        }

        public int compare(Object object, Object object2) {
            CategoryWeight categoryWeight = (CategoryWeight)object;
            CategoryWeight categoryWeight2 = (CategoryWeight)object2;
            float f = categoryWeight.excl_ratio - categoryWeight2.excl_ratio;
            return f < 0.0f ? -1 : (f == 0.0f ? 0 : 1);
        }
    }

    private static class InclRatioOrder
    implements Comparator {
        private InclRatioOrder() {
        }

        public int compare(Object object, Object object2) {
            CategoryWeight categoryWeight = (CategoryWeight)object;
            CategoryWeight categoryWeight2 = (CategoryWeight)object2;
            float f = categoryWeight.incl_ratio - categoryWeight2.incl_ratio;
            return f < 0.0f ? -1 : (f == 0.0f ? 0 : 1);
        }
    }

    private static class IndexOrder
    implements Comparator {
        private IndexOrder() {
        }

        public int compare(Object object, Object object2) {
            CategoryWeight categoryWeight = (CategoryWeight)object;
            CategoryWeight categoryWeight2 = (CategoryWeight)object2;
            return categoryWeight.type_idx - categoryWeight2.type_idx;
        }
    }
}

