/*
 * Decompiled with CFR 0.152.
 */
package viewer.zoomable;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import viewer.common.Dialogs;
import viewer.common.LabeledTextField;
import viewer.zoomable.Debug;
import viewer.zoomable.ModelTime;
import viewer.zoomable.TimeEvent;
import viewer.zoomable.TimeListener;
import viewer.zoomable.ViewportTime;

public class ModelTimePanel
extends JPanel
implements TimeListener {
    private ModelTime model = null;
    private LabeledTextField fld_iZoom_level;
    private LabeledTextField fld_tGlobal_min;
    private LabeledTextField fld_tGlobal_max;
    private LabeledTextField fld_tView_init;
    private LabeledTextField fld_tView_final;
    private LabeledTextField fld_tZoom_focus;
    private LabeledTextField fld_time_per_pixel;
    private List vport_list;

    public ModelTimePanel(ModelTime modelTime) {
        this.model = modelTime;
        this.setLayout(new BoxLayout(this, 0));
        this.vport_list = new ArrayList();
        this.fld_iZoom_level = new LabeledTextField("Zoom Level ", "#,##0");
        this.fld_iZoom_level.setEditable(false);
        this.fld_iZoom_level.setHorizontalAlignment(0);
        this.add(this.fld_iZoom_level);
        this.fld_tGlobal_min = new LabeledTextField("Global Min Time", "#,##0.00########");
        this.fld_tGlobal_min.setEditable(false);
        this.add(this.fld_tGlobal_min);
        this.fld_tView_init = new LabeledTextField("View  Init Time", "#,##0.00########");
        this.fld_tView_init.setEditable(true);
        this.add(this.fld_tView_init);
        this.fld_tZoom_focus = new LabeledTextField("Zoom Focus Time", "#,##0.00########");
        this.fld_tZoom_focus.setEditable(true);
        this.add(this.fld_tZoom_focus);
        this.fld_tView_final = new LabeledTextField("View Final Time", "#,##0.00########");
        this.fld_tView_final.setEditable(true);
        this.add(this.fld_tView_final);
        this.fld_tGlobal_max = new LabeledTextField("Global Max Time", "#,##0.00########");
        this.fld_tGlobal_max.setEditable(false);
        this.add(this.fld_tGlobal_max);
        this.fld_time_per_pixel = new LabeledTextField("Time Per Pixel", "#,##0.00########");
        this.fld_time_per_pixel.setEditable(true);
        this.add(this.fld_time_per_pixel);
        super.setBorder(BorderFactory.createEtchedBorder());
        TimeFocusActionListener timeFocusActionListener = new TimeFocusActionListener(modelTime, this.vport_list, this.fld_tZoom_focus);
        this.fld_tZoom_focus.addActionListener(timeFocusActionListener);
        TimeBoundsActionListener timeBoundsActionListener = new TimeBoundsActionListener(modelTime, this.vport_list, this.fld_tView_init, this.fld_tView_final);
        this.fld_tView_init.addActionListener(timeBoundsActionListener);
        this.fld_tView_final.addActionListener(timeBoundsActionListener);
        TimePixelActionListener timePixelActionListener = new TimePixelActionListener(modelTime, this.vport_list, this.fld_time_per_pixel);
        this.fld_time_per_pixel.addActionListener(timePixelActionListener);
    }

    public void addViewportTime(ViewportTime viewportTime) {
        if (viewportTime != null) {
            this.vport_list.add(viewportTime);
        }
    }

    public void zoomLevelChanged() {
        this.fld_iZoom_level.setInteger(this.model.getZoomLevel());
    }

    public void timeChanged(TimeEvent timeEvent) {
        if (Debug.isActive()) {
            Debug.println("ModelTimePanel: timeChanged()'s START: ");
        }
        this.fld_tGlobal_min.setDouble(this.model.getTimeGlobalMinimum());
        this.fld_tView_init.setDouble(this.model.getTimeViewPosition());
        this.fld_tZoom_focus.setDouble(this.model.getTimeZoomFocus());
        this.fld_tView_final.setDouble(this.model.getTimeViewPosition() + this.model.getTimeViewExtent());
        this.fld_tGlobal_max.setDouble(this.model.getTimeGlobalMaximum());
        this.fld_time_per_pixel.setDouble(1.0 / this.model.getViewPixelsPerUnitTime());
        if (Debug.isActive()) {
            Debug.println("ModelTimePanel: timeChanged()'s END: ");
        }
    }

    private class TimePixelActionListener
    implements ActionListener {
        private ModelTime time_model = null;
        private List vport_list = null;
        private LabeledTextField fld_time_pixel = null;

        public TimePixelActionListener(ModelTime modelTime, List list, LabeledTextField labeledTextField) {
            this.time_model = modelTime;
            this.vport_list = list;
            this.fld_time_pixel = labeledTextField;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.fld_time_pixel.getDouble() <= 0.0) {
                Window window = SwingUtilities.windowForComponent(ModelTimePanel.this);
                Dialogs.error(window, "Time Per Pixel is less than or equal to 0.0!\nRestore the old value.");
                this.fld_time_pixel.setDouble(1.0 / this.time_model.getViewPixelsPerUnitTime());
                return;
            }
            double d = this.time_model.computeTimeViewExtent(this.fld_time_pixel.getDouble());
            double d2 = this.time_model.getTimeZoomFocus();
            double d3 = d2 - d / 2.0;
            this.time_model.zoomRapidly(d3, d);
            for (int i = this.vport_list.size() - 1; i >= 0; --i) {
                ViewportTime viewportTime = (ViewportTime)this.vport_list.get(i);
                viewportTime.repaint();
                viewportTime.resetToolBarZoomButtons();
            }
        }
    }

    private class TimeBoundsActionListener
    implements ActionListener {
        private ModelTime time_model = null;
        private List vport_list = null;
        private LabeledTextField fld_tView_init = null;
        private LabeledTextField fld_tView_final = null;

        public TimeBoundsActionListener(ModelTime modelTime, List list, LabeledTextField labeledTextField, LabeledTextField labeledTextField2) {
            this.time_model = modelTime;
            this.vport_list = list;
            this.fld_tView_init = labeledTextField;
            this.fld_tView_final = labeledTextField2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            double d;
            Window window;
            boolean bl = true;
            double d2 = this.fld_tView_init.getDouble();
            if (d2 < this.time_model.getTimeGlobalMinimum() || d2 > this.time_model.getTimeGlobalMaximum()) {
                window = SwingUtilities.windowForComponent(ModelTimePanel.this);
                Dialogs.error(window, "View Init Time is out of the range of the\nGlobal Min/Max Times! Restore the old value.");
                this.fld_tView_init.setDouble(this.time_model.getTimeViewPosition());
                bl = false;
            }
            if ((d = this.fld_tView_final.getDouble()) < this.time_model.getTimeGlobalMinimum() || d > this.time_model.getTimeGlobalMaximum()) {
                window = SwingUtilities.windowForComponent(ModelTimePanel.this);
                Dialogs.error(window, "View Final Time is out of the range of the\nGlobal Min/Max Times! Restore the old value.");
                this.fld_tView_final.setDouble(this.time_model.getTimeViewPosition() + this.time_model.getTimeViewExtent());
                bl = false;
            }
            if (d2 >= d) {
                window = SwingUtilities.windowForComponent(ModelTimePanel.this);
                Dialogs.error(window, "View Init Time is later or equal to\nView Final Time!  Restore the old value.");
                this.fld_tView_init.setDouble(this.time_model.getTimeViewPosition());
                this.fld_tView_final.setDouble(this.time_model.getTimeViewPosition() + this.time_model.getTimeViewExtent());
                bl = false;
            }
            if (!bl) {
                return;
            }
            double d3 = d - d2;
            this.time_model.zoomRapidly(d2, d3);
            double d4 = (d2 + d) / 2.0;
            this.time_model.setTimeZoomFocus(d4);
            for (int i = this.vport_list.size() - 1; i >= 0; --i) {
                ViewportTime viewportTime = (ViewportTime)this.vport_list.get(i);
                viewportTime.repaint();
                viewportTime.resetToolBarZoomButtons();
            }
        }
    }

    private class TimeFocusActionListener
    implements ActionListener {
        private ModelTime time_model = null;
        private List vport_list = null;
        private LabeledTextField fld_tZoom_focus = null;

        public TimeFocusActionListener(ModelTime modelTime, List list, LabeledTextField labeledTextField) {
            this.time_model = modelTime;
            this.vport_list = list;
            this.fld_tZoom_focus = labeledTextField;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            double d = this.fld_tZoom_focus.getDouble();
            if (d < this.time_model.getTimeGlobalMinimum() || d > this.time_model.getTimeGlobalMaximum()) {
                Window window = SwingUtilities.windowForComponent(ModelTimePanel.this);
                Dialogs.error(window, "Zoom Focus Time is out of the range of the\nGlobal Min/Max Times! Restore the old value.");
                this.fld_tZoom_focus.setDouble(this.time_model.getTimeZoomFocus());
                return;
            }
            this.time_model.setTimeZoomFocus(d);
            for (int i = this.vport_list.size() - 1; i >= 0; --i) {
                ViewportTime viewportTime = (ViewportTime)this.vport_list.get(i);
                viewportTime.repaint();
            }
        }
    }
}

