/*
 * Decompiled with CFR 0.152.
 */
package viewer.timelines;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import logformat.slog2.input.InputLog;
import viewer.common.Dialogs;
import viewer.common.Parameters;
import viewer.common.TopWindow;
import viewer.timelines.TimelinePanel;

public class TimelineFrame
extends JFrame {
    private static String in_filename;
    private static int in_view_ID;
    private TimelinePanel top_panel;
    private static String help_msg;

    public TimelineFrame(InputLog inputLog, int n) {
        super("TimeLine : " + inputLog.getPathnameSuffix() + "  <" + inputLog.getLineIDMapName(n) + ">");
        super.setDefaultCloseOperation(0);
        TopWindow.Timeline.disposeAll();
        TopWindow.Timeline.setWindow(this);
        this.top_panel = new TimelinePanel(this, inputLog, n);
        this.setContentPane(this.top_panel);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                TopWindow.Timeline.disposeAll();
            }
        });
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        TopWindow.Control.setShowTimelineButtonEnabled(!bl);
    }

    public void init() {
        this.top_panel.init();
    }

    public static void checkVersion() {
        String string = System.getProperty("java.version");
        System.out.println("Java is version " + string + ".");
        if (string.compareTo("1.2.0") < 0) {
            System.err.println("WARNING: Java is version " + string + ". \n" + "\t It is too old to run this viewer.");
        }
    }

    public static void main(String[] stringArray) {
        TimelineFrame.checkVersion();
        TimelineFrame.parseCmdLineArgs(stringArray);
        System.out.print("Reading the SLOG-2 file ...... ");
        InputLog inputLog = new InputLog(in_filename);
        if (inputLog != null) {
            String string = inputLog.getCompatibleHeader();
            if (string != null && !Dialogs.confirm(TopWindow.First.getWindow(), string + "- Version SLOG 2.0.0's node employs\n  decreasing endtime ordering.\n- Version SLOG 2.0.1's node employs\n  increasing starttime ordering.\n- Version SLOG 2.0.2 added preview data\n  in legend order to shadow states.\n- Version SLOG 2.0.3 changed preview data\n  from legend to inclusive ratio order.\n- Version SLOG 2.0.4 removed unused\n  category objects.\n- Version SLOG 2.0.5 expanded preview data\n  to include inclusive & exclusive ratios.\n  \n- 2.0.1 viewer draws 2.0.0 logfile's\n  state nesting stack incorrectly!\n- 2.0.2 viewer cannot read 2.0.1 logfile.\n- 2.0.3 viewer draws 2.0.2 logfile's\n  preview weight incorrectly.\n- 2.0.4 viewer supports JOIN method and\n  can display 2.0.3 logfile correctly.\n- 2.0.5 viewer cannot read 2.0.4 logfile.\n" + "Do you still want to continue reading " + "the logfile ?")) {
                inputLog = null;
                System.exit(0);
            }
            inputLog.initialize();
        }
        System.out.println("Done.");
        Parameters.initSetupFile();
        Parameters.readFromSetupFile(null);
        Parameters.initStaticClasses();
        System.out.println("Starting the SLOG-2 Display Program ..... ");
        TimelineFrame timelineFrame = new TimelineFrame(inputLog, in_view_ID);
        timelineFrame.pack();
        timelineFrame.setVisible(true);
        timelineFrame.init();
    }

    private static void parseCmdLineArgs(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        try {
            while (n < stringArray.length) {
                if (stringArray[n].startsWith("-")) {
                    if (stringArray[n].equals("-h") || stringArray[n].equals("-help") || stringArray[n].equals("--help")) {
                        System.out.println(help_msg);
                        System.out.flush();
                        System.exit(0);
                        continue;
                    }
                    if (stringArray[n].equals("-v")) {
                        String string = stringArray[++n];
                        in_view_ID = Integer.parseInt(string);
                        stringBuffer.append("\n view_ID = " + string);
                        ++n;
                        continue;
                    }
                    System.err.println("Unrecognized option, " + stringArray[n] + ", at " + TimelineFrame.indexOrderStr(n + 1) + " command line argument");
                    System.out.flush();
                    System.exit(1);
                    continue;
                }
                in_filename = stringArray[n];
                ++n;
            }
        }
        catch (NumberFormatException numberFormatException) {
            if (stringBuffer.length() > 0) {
                System.err.println(stringBuffer.toString());
            }
            String string = TimelineFrame.indexOrderStr(n);
            System.err.println("Error occurs after option " + stringArray[n - 1] + ", " + TimelineFrame.indexOrderStr(n) + " command line argument.  It needs a number.");
            numberFormatException.printStackTrace();
        }
        if (in_filename == null) {
            System.err.println("The Program needs a SLOG-2 filename as a command line argument.");
            System.err.println(help_msg);
            System.exit(1);
        }
    }

    private static String indexOrderStr(int n) {
        switch (n) {
            case 1: {
                return Integer.toString(n) + "st";
            }
            case 2: {
                return Integer.toString(n) + "nd";
            }
            case 3: {
                return Integer.toString(n) + "rd";
            }
        }
        return Integer.toString(n) + "th";
    }

    static {
        in_view_ID = 0;
        help_msg = "Usage: java viewer.timelines.TimelineFrame [options] slog2_filename.\nOptions: \n\t [-h|-help|--help]                 \t Display this message.\n\t [-v view_ID ]                     \t Default value is 0.\n";
    }
}

