/*
 * Decompiled with CFR 0.152.
 */
package viewer.histogram;

import base.topology.SummaryState;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import viewer.common.Const;
import viewer.common.Parameters;

public class SummaryStateComboBox
extends JComboBox {
    private JButton canvas_redraw_btn;

    public SummaryStateComboBox() {
        super.setFont(Const.FONT);
        super.setEditable(false);
        super.addItem("FitMostLegends");
        super.addItem("OverlapInclusionRatio");
        super.addItem("OverlapExclusionRatio");
        super.addItem("CumulativeExclusionRatio");
        super.setToolTipText("Display options for the Summary state.");
        this.canvas_redraw_btn = null;
    }

    public void init(JButton jButton) {
        this.canvas_redraw_btn = jButton;
        super.addActionListener(new SummaryModeActionListener());
        if (Parameters.PREVIEW_STATE_DISPLAY.equals("CumulativeInclusionRatio")) {
            super.setSelectedItem("OverlapInclusionRatio");
        } else if (Parameters.PREVIEW_STATE_DISPLAY.equals("BaseAlignedCumulativeExclusionRatio")) {
            super.setSelectedItem("CumulativeExclusionRatio");
        } else {
            super.setSelectedItem(Parameters.PREVIEW_STATE_DISPLAY);
        }
    }

    private class SummaryModeActionListener
    implements ActionListener {
        private SummaryModeActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = (String)SummaryStateComboBox.this.getSelectedItem();
            SummaryState.setDisplayType(string);
            SummaryStateComboBox.this.canvas_redraw_btn.doClick();
        }
    }
}

