/*
 * Decompiled with CFR 0.152.
 */
package logformat.slog2.input;

import base.drawable.Drawable;
import base.drawable.TimeBoundingBox;
import java.util.Iterator;
import logformat.slog2.TreeDir;
import logformat.slog2.TreeDirValue;
import logformat.slog2.input.InputLog;

public class PrintSerially {
    private static boolean isForeItr = true;
    private static int itrTopoLevel = 0;
    private static String in_filename;
    private static double time_init_ftr;
    private static double time_final_ftr;
    private static String help_msg;

    public static final void main(String[] stringArray) {
        PrintSerially.parseCmdLineArgs(stringArray);
        InputLog inputLog = new InputLog(in_filename);
        String string = inputLog.getCompatibleHeader();
        if (string != null) {
            System.err.print(string);
            InputLog.stdoutConfirmation();
        }
        inputLog.initialize();
        System.out.println(inputLog);
        TreeDir treeDir = inputLog.getTreeDir();
        TreeDirValue treeDirValue = (TreeDirValue)treeDir.get(treeDir.firstKey());
        TimeBoundingBox timeBoundingBox = new TimeBoundingBox(treeDirValue.getTimeBoundingBox());
        PrintSerially.scaleTimeBounds(timeBoundingBox);
        double d = isForeItr ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
        int n = 0;
        Iterator iterator = inputLog.iteratorOfRealDrawables(timeBoundingBox, isForeItr, itrTopoLevel);
        while (iterator.hasNext()) {
            Drawable drawable = (Drawable)iterator.next();
            if (isForeItr) {
                if (d > drawable.getEarliestTime()) {
                    System.out.print("  *****  ");
                }
            } else if (d < drawable.getEarliestTime()) {
                System.out.print("  *****  ");
            }
            System.out.println(++n + ": " + drawable);
            d = drawable.getEarliestTime();
        }
        inputLog.close();
    }

    private static void scaleTimeBounds(TimeBoundingBox timeBoundingBox) {
        double d = timeBoundingBox.getEarliestTime();
        double d2 = timeBoundingBox.getLatestTime();
        double d3 = d2 - d;
        timeBoundingBox.setEarliestTime(d + time_init_ftr * d3);
        timeBoundingBox.setLatestTime(d + time_final_ftr * d3);
    }

    private static void parseCmdLineArgs(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        try {
            while (n < stringArray.length) {
                if (stringArray[n].startsWith("-")) {
                    String string;
                    if (stringArray[n].equals("-h") || stringArray[n].equals("-help") || stringArray[n].equals("--help")) {
                        System.out.println(help_msg);
                        System.out.flush();
                        System.exit(0);
                        continue;
                    }
                    if (stringArray[n].equals("-f") || stringArray[n].equals("-forward")) {
                        isForeItr = true;
                        ++n;
                        continue;
                    }
                    if (stringArray[n].equals("-b") || stringArray[n].equals("-backward")) {
                        isForeItr = false;
                        ++n;
                        continue;
                    }
                    if (stringArray[n].equals("-s") || stringArray[n].equals("-state")) {
                        itrTopoLevel = 2;
                        ++n;
                        continue;
                    }
                    if (stringArray[n].equals("-a") || stringArray[n].equals("-arrow")) {
                        itrTopoLevel = 1;
                        ++n;
                        continue;
                    }
                    if (stringArray[n].equals("-ts")) {
                        string = stringArray[++n];
                        time_init_ftr = Double.parseDouble(string);
                        stringBuffer.append("\n time_start_factor = " + string);
                        ++n;
                        continue;
                    }
                    if (stringArray[n].equals("-tf")) {
                        string = stringArray[++n];
                        time_final_ftr = Double.parseDouble(string);
                        stringBuffer.append("\n time_final_factor = " + string);
                        ++n;
                        continue;
                    }
                    System.err.println("Unrecognized option, " + stringArray[n] + ", at " + PrintSerially.indexOrderStr(n + 1) + " command line argument");
                    System.out.flush();
                    System.exit(1);
                    continue;
                }
                in_filename = stringArray[n];
                ++n;
            }
        }
        catch (NumberFormatException numberFormatException) {
            if (stringBuffer.length() > 0) {
                System.err.println(stringBuffer.toString());
            }
            String string = PrintSerially.indexOrderStr(n);
            System.err.println("Error occurs after option " + stringArray[n - 1] + ", " + PrintSerially.indexOrderStr(n) + " command line argument.  It needs a number.");
            numberFormatException.printStackTrace();
        }
        if (in_filename == null) {
            System.err.println("The Program needs a SLOG-2 filename as a command line argument.");
            System.err.println(help_msg);
            System.exit(1);
        }
        if (time_init_ftr > time_final_ftr || time_init_ftr < 0.0 || time_final_ftr > 1.0) {
            System.err.println("Invalid time_init_factor and time_final_factor!");
            System.err.println("time_init_factor = " + time_init_ftr);
            System.err.println("time_final_factor = " + time_final_ftr);
            System.exit(1);
        }
    }

    private static String indexOrderStr(int n) {
        switch (n) {
            case 1: {
                return Integer.toString(n) + "st";
            }
            case 2: {
                return Integer.toString(n) + "nd";
            }
            case 3: {
                return Integer.toString(n) + "rd";
            }
        }
        return Integer.toString(n) + "th";
    }

    static {
        time_init_ftr = 0.0;
        time_final_ftr = 1.0;
        help_msg = "Usage: java slog2.input.PrintSerially [options] slog2_filename.\nOptions: \n\t [-h|-help|--help]             \t Display this message.\n\t [-s|-state] (default all)     \t Print states only.\n\t [-a|-arrow]                   \t Print arrows only.\n\t [-f|-forward] (default)       \t Print in increasing starttime order.\n\t [-b|-backward]                \t Print in decreasing starttime order.\n\t [-ts time_start_factor]       \t Default value is 0.0 (min).\n\t [-tf time_final_factor]       \t Default value is 1.0 (max).\n";
    }
}

