/*
 * Decompiled with CFR 0.152.
 */
package logformat.slog2.input;

import base.drawable.Drawable;
import base.drawable.TimeBoundingBox;
import base.io.MixedDataIO;
import base.io.MixedDataInputStream;
import base.io.MixedRandomAccessFile;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import logformat.slog2.CategoryMap;
import logformat.slog2.FileBlockPtr;
import logformat.slog2.Header;
import logformat.slog2.IteratorOfForeDrawablesOfAll;
import logformat.slog2.LineIDMap;
import logformat.slog2.LineIDMapList;
import logformat.slog2.TreeDir;
import logformat.slog2.TreeDirValue;
import logformat.slog2.TreeNodeID;
import logformat.slog2.input.IteratorOfGroupObjects;
import logformat.slog2.input.TreeNode;
import logformat.slog2.input.TreeTrunk;

public class InputLog {
    public static final int ITERATE_ALL = 0;
    public static final int ITERATE_ARROWS = 1;
    public static final int ITERATE_STATES = 2;
    private MixedRandomAccessFile rand_file;
    private ByteArrayInputStream bary_ins;
    private MixedDataInputStream data_ins;
    private Header filehdr;
    private TreeDir treedir;
    private CategoryMap objdefs;
    private LineIDMapList lineIDmaps;
    private byte[] buffer;
    private String full_pathname;

    public InputLog(String string) {
        this.full_pathname = string;
        this.rand_file = null;
        try {
            this.rand_file = new MixedRandomAccessFile(this.full_pathname, "r");
        }
        catch (IOException iOException) {
            System.err.println("InputLog: Non-recoverable IOException! Exiting ...");
            iOException.printStackTrace();
            System.exit(1);
        }
        this.buffer = null;
        this.bary_ins = null;
        this.data_ins = null;
    }

    public String getPathnameSuffix() {
        String string = System.getProperty("file.separator");
        int n = this.full_pathname.lastIndexOf(string);
        if (n > 0) {
            return this.full_pathname.substring(n + 1);
        }
        return this.full_pathname;
    }

    public String getLineIDMapName(int n) {
        if (this.lineIDmaps != null) {
            if (n >= 0 && n < this.lineIDmaps.size()) {
                LineIDMap lineIDMap = (LineIDMap)this.lineIDmaps.get(n);
                return lineIDMap.getTitle();
            }
            return null;
        }
        return null;
    }

    public String getCompatibleHeader() {
        try {
            this.rand_file.seek(0L);
            this.filehdr = new Header(this.rand_file);
        }
        catch (IOException iOException) {
            System.err.println("InputLog: Non-recoverable IOException! Exiting ...");
            iOException.printStackTrace();
            System.exit(1);
        }
        return this.filehdr.getCompatibleVersionMessage();
    }

    public static void stdoutConfirmation() {
        byte[] byArray = new byte[10];
        System.out.print("Do you still want the program to continue ? y/yes to continue : ");
        try {
            System.in.read(byArray);
        }
        catch (IOException iOException) {
            System.err.println("InputLog: Non-recoverable IOException! Exiting ...");
            iOException.printStackTrace();
            System.exit(1);
        }
        String string = new String(byArray).trim();
        if (string.equals("y") || string.equals("yes")) {
            System.out.println("Program continues....");
        } else {
            System.out.println("Program is terminating!...");
            System.exit(1);
        }
    }

    public void initialize() {
        this.buffer = new byte[this.filehdr.getMaxBufferByteSize()];
        this.readTreeDir();
        this.readCategoryMap();
        this.readLineIDMapList();
    }

    public FileBlockPtr getFileBlockPtrToTreeRoot() {
        return this.filehdr.blockptr2treeroot;
    }

    public short getNumChildrenPerNode() {
        return this.filehdr.getNumChildrenPerNode();
    }

    public short getMaxTreeDepth() {
        return this.filehdr.getMaxTreeDepth();
    }

    private String readFilePart(FileBlockPtr fileBlockPtr, String string, MixedDataIO mixedDataIO) {
        if (fileBlockPtr.isNULL()) {
            String string2 = "The file block pointer to the " + string + " " + "is NOT initialized!, can't read it.";
            return string2;
        }
        if (fileBlockPtr.getBlockSize() > this.filehdr.getMaxBufferByteSize()) {
            String string3 = "Oops! Unexpected Error: The block size of the " + string + " is " + "too big to read into buffer for processing.";
            return string3;
        }
        long l = fileBlockPtr.getFilePointer();
        int n = fileBlockPtr.getBlockSize();
        try {
            this.rand_file.seek(l);
            this.rand_file.readFully(this.buffer, 0, n);
            this.bary_ins = new ByteArrayInputStream(this.buffer, 0, n);
            this.data_ins = new MixedDataInputStream(this.bary_ins);
            mixedDataIO.readObject(this.data_ins);
            this.data_ins.close();
        }
        catch (IOException iOException) {
            System.err.println("InputLog: Non-recoverable IOException! Exiting ...");
            iOException.printStackTrace();
            System.exit(1);
        }
        return null;
    }

    private void readLineIDMapList() {
        this.lineIDmaps = new LineIDMapList();
        String string = this.readFilePart(this.filehdr.blockptr2lineIDmaps, "LineIDMapList", this.lineIDmaps);
        if (string != null) {
            System.err.println(string);
            System.exit(1);
        }
    }

    public LineIDMapList getLineIDMapList() {
        return this.lineIDmaps;
    }

    private void readTreeDir() {
        this.treedir = new TreeDir();
        String string = this.readFilePart(this.filehdr.blockptr2treedir, "Tree Directory", this.treedir);
        if (string != null) {
            System.err.println(string);
            System.exit(1);
        }
    }

    public TreeDir getTreeDir() {
        return this.treedir;
    }

    private void readCategoryMap() {
        this.objdefs = new CategoryMap();
        String string = this.readFilePart(this.filehdr.blockptr2categories, "CategoryMap", this.objdefs);
        if (string != null) {
            System.err.println(string);
            System.exit(1);
        }
    }

    public CategoryMap getCategoryMap() {
        return this.objdefs;
    }

    public TreeNode readTreeNode(FileBlockPtr fileBlockPtr) {
        TreeNode treeNode;
        if (fileBlockPtr.isNULL()) {
            System.err.println("The file block pointer to the TreeNode is NOT initialized!, can't read it.");
            return null;
        }
        if (fileBlockPtr.getBlockSize() > this.filehdr.getMaxBufferByteSize()) {
            System.err.println("Oops! Unexpected Error: The block size of the TreeNode is too big to read into buffer for processing.");
            return null;
        }
        long l = fileBlockPtr.getFilePointer();
        int n = fileBlockPtr.getBlockSize();
        try {
            this.rand_file.seek(l);
            this.rand_file.readFully(this.buffer, 0, n);
            this.bary_ins = new ByteArrayInputStream(this.buffer, 0, n);
            this.data_ins = new MixedDataInputStream(this.bary_ins);
            treeNode = new TreeNode(this.data_ins, this.objdefs);
            this.data_ins.close();
        }
        catch (IOException iOException) {
            System.err.println("InputLog: Non-recoverable IOException! Program continues ...");
            iOException.printStackTrace();
            treeNode = null;
        }
        return treeNode;
    }

    public void close() {
        try {
            this.rand_file.close();
        }
        catch (IOException iOException) {
            System.err.println("InputLog: Non-recoverable IOException! Exiting ...");
            iOException.printStackTrace();
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.filehdr.toString() + "\n");
        stringBuffer.append(this.treedir.toString() + "\n");
        stringBuffer.append(this.objdefs.toString() + "\n");
        stringBuffer.append(this.lineIDmaps.toString() + "\n");
        return stringBuffer.toString();
    }

    public Iterator iteratorOfRealDrawables(TimeBoundingBox timeBoundingBox, boolean bl, int n) {
        if (bl) {
            return new ForeItrOfAllRealDobjs(timeBoundingBox, n);
        }
        return new BackItrOfAllRealDobjs(timeBoundingBox, n);
    }

    private class BackItrOfAllRealDobjs
    extends IteratorOfGroupObjects {
        private static final boolean IS_COMPOSITE = true;
        private static final boolean IS_BACK_ITR = false;
        private static final short LOWEST_DEPTH = 0;
        private int iterateTopoLevel;
        private TimeBoundingBox current_timebox;
        private TreeTrunk treetrunk;
        private List timebox_list;
        private int timebox_count;
        private int timebox_idx;
        private Drawable next_drawable;

        public BackItrOfAllRealDobjs(TimeBoundingBox timeBoundingBox, int n) {
            super(timeBoundingBox);
            TimeBoundingBox timeBoundingBox2;
            this.iterateTopoLevel = n;
            this.treetrunk = new TreeTrunk(InputLog.this);
            this.treetrunk.initFromTreeTop();
            TreeNode treeNode = this.treetrunk.getTreeRoot();
            TimeBoundingBox timeBoundingBox3 = new TimeBoundingBox(treeNode);
            this.timebox_list = new ArrayList();
            boolean bl = true;
            Iterator iterator = InputLog.this.treedir.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                TreeNodeID treeNodeID = (TreeNodeID)entry.getKey();
                TreeDirValue treeDirValue = (TreeDirValue)entry.getValue();
                if (!treeNodeID.isLeaf()) continue;
                timeBoundingBox2 = new TimeBoundingBox(treeDirValue.getTimeBoundingBox());
                if (bl) {
                    bl = false;
                    timeBoundingBox2.setEarliestTime(timeBoundingBox3.getEarliestTime());
                }
                if (!iterator.hasNext()) {
                    timeBoundingBox2.setLatestTime(timeBoundingBox3.getLatestTime());
                }
                this.timebox_list.add(timeBoundingBox2);
            }
            this.timebox_count = this.timebox_list.size();
            this.timebox_idx = this.timebox_count - 1;
            timeBoundingBox2 = (TimeBoundingBox)this.timebox_list.get(this.timebox_idx);
            this.treetrunk.growInTreeWindow(treeNode, (short)0, timeBoundingBox2);
            super.setObjGrpItr(this.nextObjGrpItr(timeBoundingBox));
            this.next_drawable = this.getNextInQueue();
        }

        protected Iterator nextObjGrpItr(TimeBoundingBox timeBoundingBox) {
            while (this.timebox_idx >= 0) {
                TimeBoundingBox timeBoundingBox2 = (TimeBoundingBox)this.timebox_list.get(this.timebox_idx);
                --this.timebox_idx;
                this.current_timebox = timeBoundingBox2.getIntersection(timeBoundingBox);
                if (this.current_timebox == null) continue;
                this.treetrunk.scrollTimeWindowTo(this.current_timebox);
                Iterator iterator = null;
                if (this.iterateTopoLevel == 0 || this.iterateTopoLevel == 2) {
                    iterator = this.treetrunk.iteratorOfRealDrawables(this.current_timebox, true, false, true);
                }
                Iterator iterator2 = null;
                if (this.iterateTopoLevel == 0 || this.iterateTopoLevel == 1) {
                    iterator2 = this.treetrunk.iteratorOfRealDrawables(this.current_timebox, true, false, false);
                }
                Iterator iterator3 = null;
                if (iterator != null && iterator2 != null) {
                    iterator3 = new IteratorOfForeDrawablesOfAll(iterator, iterator2);
                } else {
                    if (iterator != null) {
                        iterator3 = iterator;
                    }
                    if (iterator2 != null) {
                        iterator3 = iterator2;
                    }
                }
                return iterator3;
            }
            return null;
        }

        private Drawable getNextInQueue() {
            while (super.hasNext()) {
                Drawable drawable = (Drawable)super.next();
                if (!this.current_timebox.containsWithinLeft(drawable.getEarliestTime())) continue;
                return drawable;
            }
            return null;
        }

        public boolean hasNext() {
            return this.next_drawable != null;
        }

        public Object next() {
            Drawable drawable = this.next_drawable;
            this.next_drawable = this.getNextInQueue();
            return drawable;
        }
    }

    private class ForeItrOfAllRealDobjs
    extends IteratorOfGroupObjects {
        private static final boolean IS_COMPOSITE = true;
        private static final boolean IS_FORE_ITR = true;
        private static final short LOWEST_DEPTH = 0;
        private int iterateTopoLevel;
        private TimeBoundingBox current_timebox;
        private TreeTrunk treetrunk;
        private List timebox_list;
        private int timebox_count;
        private int timebox_idx;
        private Drawable next_drawable;

        public ForeItrOfAllRealDobjs(TimeBoundingBox timeBoundingBox, int n) {
            super(timeBoundingBox);
            TimeBoundingBox timeBoundingBox2;
            this.iterateTopoLevel = n;
            this.treetrunk = new TreeTrunk(InputLog.this);
            this.treetrunk.initFromTreeTop();
            TreeNode treeNode = this.treetrunk.getTreeRoot();
            TimeBoundingBox timeBoundingBox3 = new TimeBoundingBox(treeNode);
            this.timebox_list = new ArrayList();
            boolean bl = true;
            Iterator iterator = InputLog.this.treedir.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                TreeNodeID treeNodeID = (TreeNodeID)entry.getKey();
                TreeDirValue treeDirValue = (TreeDirValue)entry.getValue();
                if (!treeNodeID.isLeaf()) continue;
                timeBoundingBox2 = new TimeBoundingBox(treeDirValue.getTimeBoundingBox());
                if (bl) {
                    bl = false;
                    timeBoundingBox2.setEarliestTime(timeBoundingBox3.getEarliestTime());
                }
                if (!iterator.hasNext()) {
                    timeBoundingBox2.setLatestTime(timeBoundingBox3.getLatestTime());
                }
                this.timebox_list.add(timeBoundingBox2);
            }
            this.timebox_count = this.timebox_list.size();
            this.timebox_idx = 0;
            timeBoundingBox2 = (TimeBoundingBox)this.timebox_list.get(this.timebox_idx);
            this.treetrunk.growInTreeWindow(treeNode, (short)0, timeBoundingBox2);
            super.setObjGrpItr(this.nextObjGrpItr(timeBoundingBox));
            this.next_drawable = this.getNextInQueue();
        }

        protected Iterator nextObjGrpItr(TimeBoundingBox timeBoundingBox) {
            while (this.timebox_idx < this.timebox_count) {
                TimeBoundingBox timeBoundingBox2 = (TimeBoundingBox)this.timebox_list.get(this.timebox_idx);
                ++this.timebox_idx;
                this.current_timebox = timeBoundingBox2.getIntersection(timeBoundingBox);
                if (this.current_timebox == null) continue;
                this.treetrunk.scrollTimeWindowTo(this.current_timebox);
                Iterator iterator = null;
                if (this.iterateTopoLevel == 0 || this.iterateTopoLevel == 2) {
                    iterator = this.treetrunk.iteratorOfRealDrawables(this.current_timebox, true, true, true);
                }
                Iterator iterator2 = null;
                if (this.iterateTopoLevel == 0 || this.iterateTopoLevel == 1) {
                    iterator2 = this.treetrunk.iteratorOfRealDrawables(this.current_timebox, true, true, false);
                }
                Iterator iterator3 = null;
                if (iterator != null && iterator2 != null) {
                    iterator3 = new IteratorOfForeDrawablesOfAll(iterator, iterator2);
                } else {
                    if (iterator != null) {
                        iterator3 = iterator;
                    }
                    if (iterator2 != null) {
                        iterator3 = iterator2;
                    }
                }
                return iterator3;
            }
            return null;
        }

        private Drawable getNextInQueue() {
            while (super.hasNext()) {
                Drawable drawable = (Drawable)super.next();
                if (!this.current_timebox.containsWithinLeft(drawable.getEarliestTime())) continue;
                return drawable;
            }
            return null;
        }

        public boolean hasNext() {
            return this.next_drawable != null;
        }

        public Object next() {
            Drawable drawable = this.next_drawable;
            this.next_drawable = this.getNextInQueue();
            return drawable;
        }
    }
}

