/*
 * Decompiled with CFR 0.152.
 */
package base.drawable;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class InfoType {
    public static final int BYTESIZE = 1;
    public static final InfoType STR = new InfoType('s');
    public static final InfoType INT2 = new InfoType('h');
    public static final InfoType INT4 = new InfoType('d');
    public static final InfoType INT8 = new InfoType('l');
    public static final InfoType BYTE4 = new InfoType('x');
    public static final InfoType BYTE8 = new InfoType('X');
    public static final InfoType FLT4 = new InfoType('e');
    public static final InfoType FLT8 = new InfoType('E');
    private byte type;

    public InfoType() {
        this.type = (byte)32;
    }

    public InfoType(char c) {
        this.type = (byte)c;
    }

    public boolean equals(InfoType infoType) {
        return this.type == infoType.type;
    }

    public boolean isValid() {
        return this.equals(STR) || this.equals(INT2) || this.equals(INT4) || this.equals(INT8) || this.equals(BYTE4) || this.equals(BYTE8);
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        dataOutput.writeByte(this.type);
    }

    public InfoType(DataInput dataInput) throws IOException {
        this.readObject(dataInput);
    }

    public void readObject(DataInput dataInput) throws IOException {
        this.type = dataInput.readByte();
    }

    public String toString() {
        return "%" + String.valueOf((char)this.type);
    }

    public static final void main(String[] stringArray) {
        System.out.println("STR = " + STR);
        System.out.println("INT2 = " + INT2);
        System.out.println("INT4 = " + INT4);
        System.out.println("INT8 = " + INT8);
        System.out.println("BYTE4 = " + BYTE4);
        System.out.println("BYTE8 = " + BYTE8);
        System.out.println("FLT4 = " + FLT4);
        System.out.println("FLT8 = " + FLT8);
        InfoType infoType = new InfoType('a');
        System.out.println(infoType.isValid());
        InfoType infoType2 = new InfoType('d');
        System.out.println(infoType2.isValid());
        System.out.println(infoType.equals(INT2));
        System.out.println(infoType2.equals(INT4));
    }
}

