/*
 * Decompiled with CFR 0.152.
 */
package viewer.common;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Toolkit;

public class Routines {
    private static final String UnitIndentStr = "   ";
    private static final double MATH_LOG_10 = Math.log(10.0);

    public static void listAllComponents(Component component, int n) {
        if (component == null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(UnitIndentStr);
        }
        stringBuffer.append(component.toString());
        System.out.println(stringBuffer.toString());
        if (component instanceof Container) {
            Component[] componentArray = ((Container)component).getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                Routines.listAllComponents(componentArray[i], n + 1);
            }
        }
    }

    public static void setComponentAndChildrenCursors(Component component, Cursor cursor) {
        if (component == null) {
            return;
        }
        component.setCursor(cursor);
        if (component instanceof Container) {
            Component[] componentArray = ((Container)component).getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                Routines.setComponentAndChildrenCursors(componentArray[i], cursor);
            }
        }
    }

    public static Dimension getScreenSize() {
        return Toolkit.getDefaultToolkit().getScreenSize();
    }

    public static Dimension correctSize(Dimension dimension, Insets insets) {
        if (insets != null) {
            dimension.width += insets.left + insets.right;
            if (dimension.width > Short.MAX_VALUE) {
                dimension.width = Short.MAX_VALUE;
            }
            dimension.height += insets.top + insets.bottom;
            if (dimension.height > Short.MAX_VALUE) {
                dimension.height = Short.MAX_VALUE;
            }
        }
        return dimension;
    }

    public static int getAdjNumOfTextColumns(Component component, int n) {
        FontMetrics fontMetrics = component.getFontMetrics(component.getFont());
        int n2 = (int)Math.ceil((double)n * (double)fontMetrics.charWidth('1') / (double)fontMetrics.charWidth('m'));
        return n2;
    }

    public static double getTimeRulerIncrement(double d) {
        double d2 = d;
        double d3 = Math.ceil(Math.log(d2) / MATH_LOG_10);
        double d4 = Math.pow(10.0, d3);
        double d5 = d2 / d4;
        double d6 = d5 < 0.1125 ? 0.1 : (d5 < 0.1625 ? 0.125 : (d5 < 0.225 ? 0.2 : (d5 < 0.325 ? 0.25 : (d5 < 0.45 ? 0.4 : (d5 < 0.75 ? 0.5 : 1.0)))));
        return d6 * d4;
    }

    public static double getTimeRulerFirstMark(double d, double d2) {
        double d3 = Math.floor(d / d2);
        return d3 * d2;
    }
}

