/*
 * Decompiled with CFR 0.152.
 */
package viewer.common;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import viewer.common.Routines;

public class LabeledTextField
extends JPanel {
    private static final int TEXT_HEIGHT = 20;
    protected static Font FONT = null;
    private JLabel tag;
    private ExpandedTextField fld;
    protected DecimalFormat fmt;
    private FieldDocumentListener self_listener;

    public LabeledTextField(String string, String string2) {
        this(false, string, string2);
    }

    public LabeledTextField(boolean bl, String string, String string2) {
        super.setLayout(new BoxLayout(this, 1));
        this.tag = new JLabel(string);
        if (bl) {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 0));
            jPanel.add(Box.createHorizontalStrut(5));
            jPanel.add(this.tag);
            jPanel.add(Box.createHorizontalGlue());
            jPanel.setAlignmentX(0.0f);
            super.add(jPanel);
        } else {
            this.tag.setAlignmentX(0.0f);
            super.add(this.tag);
        }
        this.fld = new ExpandedTextField();
        this.tag.setLabelFor(this.fld);
        this.fld.setAlignmentX(0.0f);
        super.add(this.fld);
        if (string2 != null) {
            this.fmt = (DecimalFormat)NumberFormat.getInstance();
            this.fmt.applyPattern(string2);
            int n = Routines.getAdjNumOfTextColumns(this.fld, string2.length());
            this.fld.setColumns(n);
        } else {
            this.fmt = null;
        }
        this.self_listener = null;
        this.fld.setBorder(BorderFactory.createEtchedBorder());
        if (FONT != null) {
            this.tag.setFont(FONT);
            this.fld.setFont(FONT);
        }
    }

    public static void setDefaultFont(Font font) {
        FONT = font;
    }

    public void setLabelFont(Font font) {
        this.tag.setFont(font);
    }

    public void setFieldFont(Font font) {
        this.fld.setFont(font);
    }

    public void setHorizontalAlignment(int n) {
        this.fld.setHorizontalAlignment(n);
    }

    public void setText(String string) {
        this.fld.setText(string);
    }

    public String getText() {
        if (this.self_listener != null) {
            return this.self_listener.getLastUpdatedText();
        }
        return this.fld.getText();
    }

    public void setBoolean(boolean bl) {
        this.fld.setText(String.valueOf(bl));
    }

    public boolean getBoolean() {
        String string = null;
        string = this.self_listener != null ? this.self_listener.getLastUpdatedText() : this.fld.getText();
        return string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes");
    }

    public void setShort(short s) {
        this.fld.setText(this.fmt.format(s));
    }

    public short getShort() {
        if (this.self_listener != null) {
            return Short.parseShort(this.self_listener.getLastUpdatedText());
        }
        return Short.parseShort(this.fld.getText());
    }

    public void setInteger(int n) {
        this.fld.setText(this.fmt.format(n));
    }

    public int getInteger() {
        try {
            if (this.self_listener != null) {
                return Integer.parseInt(this.self_listener.getLastUpdatedText());
            }
            return Integer.parseInt(this.fld.getText());
        }
        catch (NumberFormatException numberFormatException) {
            return Integer.MIN_VALUE;
        }
    }

    public void setFloat(float f) {
        this.fld.setText(this.fmt.format(f));
    }

    public float getFloat() {
        if (this.self_listener != null) {
            return Float.parseFloat(this.self_listener.getLastUpdatedText());
        }
        return Float.parseFloat(this.fld.getText());
    }

    public void setDouble(double d) {
        this.fld.setText(this.fmt.format(d));
    }

    public double getDouble() {
        try {
            if (this.self_listener != null) {
                return Double.parseDouble(this.self_listener.getLastUpdatedText());
            }
            return Double.parseDouble(this.fld.getText());
        }
        catch (NumberFormatException numberFormatException) {
            return Double.MIN_VALUE;
        }
    }

    public void setEditable(boolean bl) {
        this.fld.setEditable(bl);
    }

    public void setEnabled(boolean bl) {
        this.fld.setEnabled(bl);
    }

    public void addActionListener(ActionListener actionListener) {
        this.fld.addActionListener(actionListener);
    }

    public void addSelfDocumentListener() {
        this.self_listener = new FieldDocumentListener();
        this.fld.getDocument().addDocumentListener(this.self_listener);
    }

    public Dimension getMaximumSize() {
        return new Dimension(Short.MAX_VALUE, this.fld.getPreferredSize().height + 20);
    }

    public void fireActionPerformed() {
        this.fld.fireActionPerformed();
    }

    private class FieldDocumentListener
    implements DocumentListener {
        private Document last_updated_document = null;

        public void changedUpdate(DocumentEvent documentEvent) {
            this.last_updated_document = documentEvent.getDocument();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.last_updated_document = documentEvent.getDocument();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.last_updated_document = documentEvent.getDocument();
        }

        public String getLastUpdatedText() {
            if (this.last_updated_document != null) {
                try {
                    return this.last_updated_document.getText(0, this.last_updated_document.getLength());
                }
                catch (BadLocationException badLocationException) {
                    return null;
                }
            }
            return null;
        }
    }

    private class ExpandedTextField
    extends JTextField {
        private ExpandedTextField() {
        }

        public void fireActionPerformed() {
            super.fireActionPerformed();
        }
    }
}

