/*
 * Decompiled with CFR 0.152.
 */
package logformat.slog2;

import base.drawable.Drawable;
import base.drawable.Primitive;
import base.drawable.TimeBoundingBox;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import logformat.slog2.FileBlockPtr;
import logformat.slog2.LineIDMap;
import logformat.slog2.TreeNodeID;

public abstract class BufForObjects
extends TimeBoundingBox
implements Comparable {
    protected static final int BYTESIZE = 34;
    private TreeNodeID ID = new TreeNodeID(0, 0);
    private FileBlockPtr blockptr = new FileBlockPtr();

    protected BufForObjects() {
    }

    public void setTreeNodeID(TreeNodeID treeNodeID) {
        this.ID.depth = treeNodeID.depth;
        this.ID.xpos = treeNodeID.xpos;
    }

    public TreeNodeID getTreeNodeID() {
        return this.ID;
    }

    public boolean isLeaf() {
        return this.ID.isLeaf();
    }

    public boolean isPossibleRoot() {
        return this.ID.isPossibleRoot();
    }

    public int compareTo(BufForObjects bufForObjects) {
        return this.ID.compareTo(bufForObjects.ID);
    }

    public int compareTo(Object object) {
        return this.compareTo((BufForObjects)object);
    }

    public void setFileBlockPtr(long l, int n) {
        this.blockptr.setFileBlockPtr(l, n);
    }

    public FileBlockPtr getFileBlockPtr() {
        return this.blockptr;
    }

    public long getFilePointer() {
        return this.blockptr.getFilePointer();
    }

    public int getBlockSize() {
        return this.blockptr.getBlockSize();
    }

    public abstract int getByteSize();

    public abstract void add(Primitive var1);

    public abstract void empty();

    public abstract int getNumOfDrawables();

    public abstract int getNumOfPrimitives();

    public abstract Iterator nestableBackIterator(TimeBoundingBox var1, boolean var2);

    public abstract Iterator nestlessBackIterator(TimeBoundingBox var1);

    public abstract Iterator nestableForeIterator(TimeBoundingBox var1, boolean var2);

    public abstract Iterator nestlessForeIterator(TimeBoundingBox var1);

    public abstract LineIDMap getIdentityLineIDMap();

    protected static LineIDMap toIdentityLineIDMap(Collection collection) {
        LineIDMap lineIDMap = new LineIDMap(1);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Drawable drawable = (Drawable)iterator.next();
            Integer[] integerArray = drawable.getArrayOfLineIDs();
            for (int i = 0; i < integerArray.length; ++i) {
                lineIDMap.put(integerArray[i], new Integer[]{integerArray[i]});
            }
        }
        return lineIDMap;
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        super.writeObject(dataOutput);
        this.ID.writeObject(dataOutput);
        this.blockptr.writeObject(dataOutput);
    }

    public void readObject(DataInput dataInput) throws IOException {
        super.readObject(dataInput);
        this.ID.readObject(dataInput);
        this.blockptr.readObject(dataInput);
    }

    public String toString() {
        return this.ID.toString() + " " + super.toString() + " " + this.blockptr.toString();
    }
}

