/*
 * Decompiled with CFR 0.152.
 */
package base.drawable;

import base.drawable.Category;
import base.drawable.InfoType;
import base.drawable.InfoValue;
import base.drawable.TimeBoundingBox;
import base.io.MixedDataInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;

public class InfoBox
extends TimeBoundingBox {
    private static final int INIT_BYTESIZE = 6;
    private static final int INVALID_INDEX = Integer.MIN_VALUE;
    private int type_idx;
    private Category type;
    private boolean hasBufBeenDecoded;
    private byte[] infobuffer;
    private InfoValue[] infovals;

    public InfoBox() {
        this.initCategoryToNull();
    }

    public InfoBox(int n) {
        this.initCategoryToNull();
        this.type_idx = n;
    }

    public InfoBox(Category category) {
        this.setCategory(category);
    }

    public InfoBox(InfoBox infoBox) {
        super(infoBox);
        this.setCategory(infoBox.type);
    }

    public InfoBox(Category category, InfoBox infoBox) {
        super(infoBox);
        this.setCategory(category);
    }

    private void initCategoryToNull() {
        this.type = null;
        this.type_idx = Integer.MIN_VALUE;
        this.infobuffer = null;
        this.infovals = null;
        this.hasBufBeenDecoded = false;
    }

    private void setCategory(Category category) {
        if (category != null) {
            this.type = category;
            this.type_idx = this.type.getIndex();
            this.infobuffer = null;
            this.infovals = null;
            this.hasBufBeenDecoded = false;
        } else {
            this.initCategoryToNull();
        }
    }

    public boolean resolveCategory(Map map) {
        if (this.type == null) {
            if (this.type_idx != Integer.MIN_VALUE) {
                this.type = (Category)map.get(new Integer(this.type_idx));
                if (this.type != null) {
                    this.type.setUsed(true);
                    return true;
                }
            }
        } else {
            this.type.setUsed(true);
            return true;
        }
        return false;
    }

    public Category getCategory() {
        return this.type;
    }

    public int getCategoryIndex() {
        return this.type_idx;
    }

    public void setInfoBuffer(byte[] byArray) {
        this.infobuffer = byArray;
    }

    private void setInfoValueTypes() {
        if (this.type != null) {
            InfoType[] infoTypeArray = this.type.getInfoTypes();
            if (infoTypeArray != null && infoTypeArray.length > 0) {
                int n = infoTypeArray.length;
                this.infovals = new InfoValue[n];
                for (int i = 0; i < n; ++i) {
                    this.infovals[i] = new InfoValue(infoTypeArray[i]);
                }
            } else {
                this.infovals = null;
            }
        }
    }

    private void setInfoValues() {
        if (this.infobuffer == null) {
            return;
        }
        this.setInfoValueTypes();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.infobuffer);
        MixedDataInputStream mixedDataInputStream = new MixedDataInputStream(byteArrayInputStream);
        try {
            for (int i = 0; i < this.infovals.length; ++i) {
                this.infovals[i].readValue(mixedDataInputStream);
            }
            mixedDataInputStream.close();
            byteArrayInputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(1);
        }
    }

    private void decodeInfoBuffer() {
        if (!this.hasBufBeenDecoded) {
            this.hasBufBeenDecoded = true;
            this.setInfoValues();
        }
    }

    public int getByteSize() {
        int n = 6;
        if (this.infobuffer != null) {
            n += this.infobuffer.length;
        }
        return n;
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.type_idx);
        if (this.infobuffer != null && this.infobuffer.length > 0) {
            dataOutput.writeShort(this.infobuffer.length);
            dataOutput.write(this.infobuffer);
        } else {
            dataOutput.writeShort(0);
        }
    }

    public InfoBox(DataInput dataInput) throws IOException {
        this.readObject(dataInput);
    }

    public void readObject(DataInput dataInput) throws IOException {
        this.type_idx = dataInput.readInt();
        short s = dataInput.readShort();
        if (s > 0) {
            this.infobuffer = new byte[s];
            dataInput.readFully(this.infobuffer);
        } else {
            this.infobuffer = null;
        }
    }

    public String toInfoBoxString() {
        StringBuffer stringBuffer;
        block5: {
            block4: {
                stringBuffer = new StringBuffer();
                this.decodeInfoBuffer();
                if (this.type == null) break block4;
                String[] stringArray = this.type.getInfoKeys();
                if ((stringArray == null || stringArray.length <= 0) && (this.infovals == null || this.infovals.length <= 0)) break block5;
                int n = stringArray != null ? stringArray.length : 0;
                int n2 = this.infovals != null ? this.infovals.length : 0;
                int n3 = Math.max(n, n2);
                for (int i = 0; i < n3; ++i) {
                    if (i < n) {
                        stringBuffer.append(stringArray[i]);
                    }
                    if (i >= n2) continue;
                    stringBuffer.append(this.infovals[i]);
                }
                break block5;
            }
            if (this.infovals != null) {
                for (int i = 0; i < this.infovals.length; ++i) {
                    stringBuffer.append(this.infovals[i] + " ");
                }
            }
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("infobox[ " + super.toString() + " ");
        if (this.type != null) {
            stringBuffer.append("Category=" + this.type + ": ");
        } else {
            stringBuffer.append("Category=" + this.type_idx + ": ");
        }
        this.decodeInfoBuffer();
        if (this.type != null) {
            String[] stringArray = this.type.getInfoKeys();
            if (stringArray != null && stringArray.length > 0 || this.infovals != null && this.infovals.length > 0) {
                int n = stringArray != null ? stringArray.length : 0;
                int n2 = this.infovals != null ? this.infovals.length : 0;
                int n3 = Math.max(n, n2);
                for (int i = 0; i < n3; ++i) {
                    if (i < n) {
                        stringBuffer.append(stringArray[i]);
                    }
                    if (i >= n2) continue;
                    stringBuffer.append(this.infovals[i]);
                }
            }
        } else if (this.infovals != null) {
            for (int i = 0; i < this.infovals.length; ++i) {
                stringBuffer.append(this.infovals[i] + " ");
            }
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

