function verifyDiskSpace(dirPath, spaceRequired)
{
  var spaceAvailable;
  spaceAvailable = fileGetDiskSpaceAvailable(dirPath);
  spaceAvailable = parseInt(spaceAvailable / 1024);
  if(spaceAvailable < spaceRequired)
  {
    logComment("Insufficient disk space: " + dirPath);
    logComment("  required : " + spaceRequired + " K");
    logComment("  available: " + spaceAvailable + " K");
    return(false);
  }

  return(true);
}

var srDest;
var err;
var fProgram;
var prettyName = "Polski (PL) Ustawienia regionalne";
var chromeNode = "PL";
var regName    = "locales/mozilla/" + chromeNode;
var chromeName = chromeNode + ".jar";
var localeName = "locale/" + chromeNode + "/";

srDest = 865;
err    = initInstall(prettyName, regName, "1.2.x");
logComment("initInstall: " + err);

fProgram = getFolder("Program");
logComment("fProgram: " + fProgram);

if(verifyDiskSpace(fProgram, srDest))
{
  setPackageFolder(fProgram);
  err = addDirectory("",
                     "1.2.x",
                     "bin",
                     fProgram,
                     "",
                     true);
  logComment("addDirectory() returned: " + err);

  var cf = getFolder("Chrome");
  registerChrome(LOCALE | DELAYED_CHROME, getFolder(cf, chromeName), localeName + "global-region/");
  registerChrome(LOCALE | DELAYED_CHROME, getFolder(cf, chromeName), localeName + "communicator-region/");
  registerChrome(LOCALE | DELAYED_CHROME, getFolder(cf, chromeName), localeName + "editor-region/");
  registerChrome(LOCALE | DELAYED_CHROME, getFolder(cf, chromeName), localeName + "messenger-region/");
  registerChrome(LOCALE | DELAYED_CHROME, getFolder(cf, chromeName), localeName + "navigator-region/");

  if (err == SUCCESS)
  {
      err = performInstall();
      logComment("performInstall() returned: " + err);
      alert("Instalacja zosta\u0142a zako\u0144czona pomy\u015Blnie. Po ponownym uruchomieniu przegl\u0105darki, b\u0119dzie mo\u017Cna wybra\u0107 j\u0119zyk poprzez panel Edytuj > Preferencje (Edit > Preferences) oraz menu Widok (View).");
  }
  else
  {
      cancelInstall(err);
      logComment("cancelInstall due to error: " + err);
      alert("Instalacja zosta\u0142a anulowana. Wyst\u0105pi\u0142 b\u0142\u0105d " + err);
  }
}
else
  cancelInstall(INSUFFICIENT_DISK_SPACE);
