/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Proctor.
 *
 * The Initial Developer of the Original Code is
 * Gabriel Baines <gabrielbaines@yahoo.com>
 * Portions created by the Initial Developer are Copyright (C) 2___
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 * Gabriel Baines <gabrielbaines@yahoo.com>
 *
 * ***** END LICENSE BLOCK ***** */

/** We use this guy to report abnormal behavior for debugging purposes */
var gConsoleService = Components
      .classes["@mozilla.org/consoleservice;1"]
      .getService(Components.interfaces.nsIConsoleService);

/** Frequently used preferences service */
var gPrefBranch  = Components
      .classes["@mozilla.org/preferences-service;1"]
      .getService(Components.interfaces.nsIPrefBranch);

/**
 * Here we keep all the human readable strings that need
 * to be accessed by JS code. The actual initialization
 * takes place in onLoadHandler. Late initialization
 * is required to make sure that the stringbundle has been
 * loaded before we try to find it.
 */
var gBundle = null;

/**
 * Proctor observes changes of network.proxy.type preference.
 * On notification received it updates the main indicator.
 */
const gkProctor =
{
  kTopic: "nsPref:changed",
  kPrefName: "network.proxy.type",
  kTooltipPrefix: "proctor.proxy.type_",
  kMenuId: "proctorPopup",
  kGroupName: "proctorMenuGroup",


  /** The observer callaback */
  observe: function(subject, topic, prefName)
  {
    // A couple of paranoid checks
    if (this.kTopic != topic)
    {
      gConsoleService.logStringMessage("Proctor: unexpected topic observed: " + topic);
      return;
    }

    if (this.kPrefName != prefName)
    {
      gConsoleService.logStringMessage("Proctor: unexpected notification on change of " + prefName);
      return;
    }

    this.updateUI();
  },

  /** Syncs all the UI elements with the current state of preferences. */
  updateUI: function()
  {
    var proxyType = gPrefBranch.getIntPref(this.kPrefName);
    this.updateProxyIndicator(proxyType);
    this.updateProxyMenu(proxyType);
  },

  /** Syncs the indicator with the current state of preferences. */
  updateProxyIndicator: function(proxyType)
  {
    var statusIndicator = document.getElementById("proctor-button");

    // If there is no indicator, we cannot do anything
    if (null == statusIndicator)
      return;

    statusIndicator.setAttribute("type", proxyType);

    var tooltipKey = this.kTooltipPrefix + proxyType;
    try
    {
      var tooltipText = gBundle.getString(tooltipKey);
      statusIndicator.setAttribute("tooltiptext", tooltipText);
    }
    catch(x)
    {
      // Well, we just won't use any tooltip
      gConsoleService.logStringMessage("Proctor: Missing localized text for " + tooltipKey);
    }
  },

  /** Syncs the menu with the current state of preferences. */
  updateProxyMenu: function(proxyType)
  {
    var popup = document.getElementById(this.kMenuId);
    var item = popup.firstChild;
    while (null != item)
    {
      if (item.getAttribute("name") == this.kGroupName)
      {
        if (item.getAttribute("value") == proxyType)
          item.setAttribute("checked", "true");
        else
          item.removeAttribute("checked");
      }
      item = item.nextSibling;
    }
  }
}

/**
 *  Cycle proxy settings. Used as a callback for clickable UI elements
 */
function switchProxy()
{
  var proxyType = gPrefBranch.getIntPref(gkProctor.kPrefName);
  proxyType = ++proxyType % 3;
  gPrefBranch.setIntPref(gkProctor.kPrefName, proxyType);
}

/**
 *  Set specified proxy type. Uased as a callback for clickable UI elements
 */
function switchProxyTo(newType)
{
  gPrefBranch.setIntPref(gkProctor.kPrefName, newType);
}

function showProxyPrefsDialog()
{
  goPreferences('advancedItem','chrome://communicator/content/pref/pref-proxies.xul')
}

/**
 *  Initialization routine.
 *
 *  Forces the initial synchronization of the indicator a
 *  and registers Proctor as preferences observer.
 */
function onLoadHandler(event)
{
  gBundle = document.getElementById("proctorBundle");

  gkProctor.updateUI();

  var prefBranchInt = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefBranchInternal);
  prefBranchInt.addObserver(gkProctor.kPrefName, gkProctor, false);

  window.removeEventListener("load",onLoadHandler,true);
}

window.addEventListener("load",onLoadHandler,true);

