/* ***** BEGIN LICENSE BLOCK *****
   - Version: MPL 1.1/GPL 2.0/LGPL 2.1
   -
   - The contents of this file are subject to the Mozilla Public License Version
   - 1.1 (the "License"); you may not use this file except in compliance with
   - the License. You may obtain a copy of the License at
   - http://www.mozilla.org/MPL/
   -
   - Software distributed under the License is distributed on an "AS IS" basis,
   - WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
   - for the specific language governing rights and limitations under the
   - License.
   -
   - The Original Code is MozTweak.
   -
   - The Initial Developer of the Original Code is Marek Wawoczny.
   - Portions created by the Initial Developer are Copyright (C) 2002
   - the Initial Developer. All Rights Reserved.
   -
   - Contributor(s):
   - Marek Wawoczny (GmbH@MozillaPL.org)
   -
   - Alternatively, the contents of this file may be used under the terms of
   - either the GNU General Public License Version 2 or later (the "GPL"), or
   - the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
   - in which case the provisions of the GPL or the LGPL are applicable instead
   - of those above. If you wish to allow use of your version of this file only
   - under the terms of either the GPL or the LGPL, and not to allow others to
   - use your version of this file under the terms of the MPL, indicate your
   - decision by deleting the provisions above and replace them with the notice
   - and other provisions required by the LGPL or the GPL. If you do not delete
   - the provisions above, a recipient may use your version of this file under
   - the terms of any one of the MPL, the GPL or the LGPL.
   -
   - ***** END LICENSE BLOCK ***** */

var headerFields = ["authorwrote", "ondate", "separator", "colon", "locale", "type", "originalmessage"];

function initHeaders() {
  var headerField = document.getElementById("moztweak.mail.header");
  
  if (headerField)
  {
    gMozTweakHeadersRDF.addDataSource(headerField);

    headerField.selectedItem = document.getElementById(getPref("moztweak.mail.header", "char", "rdf:TekDzi2gTTvm"));

    setReplyHeader();

    var gData = parent.hPrefWindow.wsm.dataManager.pageData["chrome://moztweak/content/pref-mail-header.xul"];

    if (!("gMozTweakHeadersRDF" in gData)) {
      gData.gMozTweakHeadersRDF = gMozTweakHeadersRDF;
    }

    parent.hPrefWindow.registerOKCallbackFunc(flushHeadersDataSource);
    parent.hPrefWindow.registerCancelCallbackFunc(refreshHeadersDataSource);
  }

  removeEventListener("load", initHeaders, true);
}

function flushHeadersDataSource() {
  var gData = parent.hPrefWindow.wsm.dataManager.pageData["chrome://moztweak/content/pref-mail-header.xul"];

  if (gData.gMozTweakHeadersRDF) {
    gData.gMozTweakHeadersRDF.flushDataSource();
  }
}

function refreshHeadersDataSource() {
  var gData = parent.hPrefWindow.wsm.dataManager.pageData["chrome://moztweak/content/pref-mail-header.xul"];

  if (gData.gMozTweakHeadersRDF) {
    gData.gMozTweakHeadersRDF.refreshDataSource();
  }
}

function buildReplyHeader() {
  var DateTime = new Date();
  var DateTimeFormat = MozTweakScriptableDateFormat.FormatDateTime(
                                 document.getElementById("mailnews.reply_header_locale").value,
                                 MozTweakScriptableDateFormat.dateFormatShort,
                                 MozTweakScriptableDateFormat.timeFormatNoSeconds,
                                 DateTime.getFullYear(), DateTime.getMonth()+1,
                                 DateTime.getDate(), DateTime.getHours(),
                                 DateTime.getMinutes(), DateTime.getSeconds());

  var replyHeader = document.getElementById("mailnews.reply_header");

  switch (document.getElementById("mailnews.reply_header_type").value) {
    case "0":
      replyHeader.value = null;
      break;
    case "1":
      replyHeader.value = document.getElementById("mailnews.reply_header_authorwrote").value.replace(/%s/, getString("exampleUserName.property")) + document.getElementById("mailnews.reply_header_colon").value;
      break;
    case "2":
      replyHeader.value = document.getElementById("mailnews.reply_header_ondate").value.replace(/%s/, DateTimeFormat) + document.getElementById("mailnews.reply_header_separator").value + document.getElementById("mailnews.reply_header_authorwrote").value.replace(/%s/, getString("exampleUserName.property")) + document.getElementById("mailnews.reply_header_colon").value;
      break;
    case "3":
      replyHeader.value = document.getElementById("mailnews.reply_header_authorwrote").value.replace(/%s/, getString("exampleUserName.property")) + document.getElementById("mailnews.reply_header_separator").value + document.getElementById("mailnews.reply_header_ondate").value.replace(/%s/, DateTimeFormat) + document.getElementById("mailnews.reply_header_colon").value;
      break;
  }
}

function changeReplyHeader(aHeaderID, aNewValue) {
  var headerField = document.getElementById("moztweak.mail.header");

  gMozTweakHeadersRDF.changeItemValue(headerField.value, aHeaderID.split("mailnews.reply_header_")[1], aNewValue);

  buildReplyHeader();
}

function disableFields(aState) {
  for (var i = 0; i < headerFields.length; ++i) {
    if (headerFields[i] != "type") {
      document.getElementById("mailnews.reply_header_" + headerFields[i]).disabled = aState;
    }
  }

  document.getElementById("deleteHeaderSet").disabled = aState;
}

function setReplyHeader() {
  var headerField = document.getElementById("moztweak.mail.header");

  for (var i = 0; i < headerFields.length; ++i) {
    var field = document.getElementById("mailnews.reply_header_" + headerFields[i]);

    field.value = gMozTweakHeadersRDF.getItemValue(headerField.value, headerFields[i]);
  }

  if (headerField.value == "rdf:TekDzi2gTTvm" || headerField.value == "rdf:LVPH9308VzVs") {
    disableFields(true);
  }
  else {
    disableFields(false);
  }

  buildReplyHeader();
}

function addHeaderSet() {
  var headerSetName = window.prompt(getString("newHeaderNameDialogBox.property"));

  if (!headerSetName) {
    return;
  }

  var elementArray = new Object();

  elementArray["name"] = headerSetName;
  elementArray["authorwrote"] = getString("defaultAuthorWrote.property");
  elementArray["separator"] = getString("defaultSeparator.property");
  elementArray["colon"] = getString("defaultColon.property");
  elementArray["locale"] = getString("defaultLocale.property");
  elementArray["type"] = getString("defaultType.property");
  elementArray["originalmessage"] = getString("defaultOriginalMessage.property");
  elementArray["ondate"] = getString("defaultOnDate.property");

  var headerField = document.getElementById("moztweak.mail.header");
  headerField.selectedItem = document.getElementById(gMozTweakHeadersRDF.addNode("moztweak:header", elementArray));

  setReplyHeader();
}

function deleteHeaderSet() {
  if (!window.confirm(getString("deleteHeaderDialogBox.property"))) {
    return;
  }

  var headerField = document.getElementById("moztweak.mail.header");

  gMozTweakHeadersRDF.removeNode("moztweak:header", headerField.value);

  headerField.selectedItem = document.getElementById("rdf:TekDzi2gTTvm");

  setReplyHeader();
}

function testAlertNotification() {
  showAlert("chrome://messenger/skin/icons/new-mail-alert.png", getString("AlertNotificationTitle.property"), getString("AlertNotificationMessage.property"), true, null, null);
}

function applyAlertSettings() {
  setPref("alerts.slideIncrement", "int", document.getElementById("alerts.slideIncrement").value);
  setPref("alerts.slideIncrementTime", "int", document.getElementById("alerts.slideIncrementTime").value);
  setPref("alerts.totalOpenTime", "int", document.getElementById("alerts.totalOpenTime").value);
}

function resetAlertSettings() {
  setPref("alerts.slideIncrement", "int", 1);
  setPref("alerts.slideIncrementTime", "int", 10);
  setPref("alerts.totalOpenTime", "int", 4000);

  document.getElementById("alerts.slideIncrement").value = 1;
  document.getElementById("alerts.slideIncrementTime").value = 10;
  document.getElementById("alerts.totalOpenTime").value = 4000;
}
