/* ***** BEGIN LICENSE BLOCK *****
   - Version: MPL 1.1/GPL 2.0/LGPL 2.1
   -
   - The contents of this file are subject to the Mozilla Public License Version
   - 1.1 (the "License"); you may not use this file except in compliance with
   - the License. You may obtain a copy of the License at
   - http://www.mozilla.org/MPL/
   -
   - Software distributed under the License is distributed on an "AS IS" basis,
   - WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
   - for the specific language governing rights and limitations under the
   - License.
   -
   - The Original Code is MozTweak.
   -
   - The Initial Developer of the Original Code is Marek Wawoczny.
   - Portions created by the Initial Developer are Copyright (C) 2002
   - the Initial Developer. All Rights Reserved.
   -
   - Contributor(s):
   - Marek Wawoczny (GmbH@MozillaPL.org)
   -
   - Alternatively, the contents of this file may be used under the terms of
   - either the GNU General Public License Version 2 or later (the "GPL"), or
   - the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
   - in which case the provisions of the GPL or the LGPL are applicable instead
   - of those above. If you wish to allow use of your version of this file only
   - under the terms of either the GPL or the LGPL, and not to allow others to
   - use your version of this file under the terms of the MPL, indicate your
   - decision by deleting the provisions above and replace them with the notice
   - and other provisions required by the LGPL or the GPL. If you do not delete
   - the provisions above, a recipient may use your version of this file under
   - the terms of any one of the MPL, the GPL or the LGPL.
   -
   - ***** END LICENSE BLOCK ***** */

var MozTweakObserverService = Components.classes["@mozilla.org/observer-service;1"].getService(Components.interfaces.nsIObserverService);
var MozTweakPrefService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService);
var MozTweakScriptableDateFormat = Components.classes["@mozilla.org/intl/scriptabledateformat;1"].getService(Components.interfaces.nsIScriptableDateFormat);
var MozTweakWindowMediator = Components.classes["@mozilla.org/appshell/window-mediator;1"].getService(Components.interfaces.nsIWindowMediator);

var MozTweakPref = MozTweakPrefService.getBranch(null);

function setPref(prefString, prefType, prefValue) {
  if (prefValue != null || (prefType == "char" && prefValue != "")) {
    switch (prefType) {
      case "int":
        MozTweakPref.setIntPref(prefString, prefValue);
        break;
      case "bool":
        MozTweakPref.setBoolPref(prefString, prefValue);
        break;
      case "char":
        MozTweakPref.setCharPref(prefString, prefValue);
        break;
    }
  }
  else {
    try {
      MozTweakPref.clearUserPref(prefString);
    }
    catch (err) {
    }
  }
}

function getPref(prefString, prefType, prefDefaultValue) {
  try {
    switch (prefType) {
      case "int":
        return MozTweakPref.getIntPref(prefString);
        break;
      case "bool":
        return MozTweakPref.getBoolPref(prefString);
        break;
      case "char":
        return MozTweakPref.getCharPref(prefString);
        break;
    }
    return prefDefaultValue;
  }
  catch (err) {
    setPref(prefString, prefType, prefDefaultValue);
    return prefDefaultValue;
  }
}

function getBranch(prefString) {
  return MozTweakPref.getBranch(prefString).getChildList("", {});
}

function getString(aString) {
  var moztweakStringBundle = document.getElementById("moztweakStringBundle");
  
  if (moztweakStringBundle) {
    return moztweakStringBundle.getString(aString);
  }
  else {
    return null;
  }
}

function showAlert(alertImage, alertTitleLabel, alertTextLabel, alertTextClickable, alertCookie, alertListener) {
  try {
  	var MozTweakAlertsService = Components.classes["@mozilla.org/alerts-service;1"].createInstance(Components.interfaces.nsIAlertsService);
    MozTweakAlertsService.showAlertNotification(alertImage, alertTitleLabel, alertTextLabel, alertTextClickable, alertCookie, alertListener);
  }
  catch (err) {
    alert(getString("moztweak.onlywindows.property") + err);
  }
}

function disableDebugQAMenu(aEvent) {
  var debugMenu = document.getElementById("debugMenu");
  var qaMenu = document.getElementById("qaMenu");

  if (debugMenu) {
    debugMenu.setAttribute("hidden", !getPref("moztweak.debug.menu", "bool", false));
  }

  if (qaMenu) {
    qaMenu.setAttribute("hidden", !getPref("moztweak.qa.menu", "bool", false));
  }

  window.removeEventListener("load", disableDebugQAMenu, true);
}

function setElementsState(aElements, aElementsState, aState) {
  if (aState != null) {
    for (var i = 0; i < aElements.length; ++i) {
      if (aElements[i] != "type") {
        document.getElementById(aElements[i]).disabled = aState;
      }
    }
  }
  else if (aElementsState != null) {
    for (var item in aElementsState) {
      document.getElementById(item).disabled = aElementsState[item];
    }
  }
}

function getElementsState(aElements) {
  var elementsState = new Object();

  for (var i = 0; i < aElements.length; ++i) {
    if (aElements[i] != "type") {
      elementsState[aElements[i]] = document.getElementById(aElements[i]).disabled;
    }
  }

  return elementsState;
}

function getMessageComposeEditor() {
  var messageContentFrame = document.getElementById("content-frame");

  return messageContentFrame.getEditor(messageContentFrame.contentWindow);
}

function getMessageComposeEditorType() {
  var messageContentFrame = document.getElementById("content-frame");

  return messageContentFrame.editortype;
}