/* ***** BEGIN LICENSE BLOCK *****
   - Version: MPL 1.1/GPL 2.0/LGPL 2.1
   -
   - The contents of this file are subject to the Mozilla Public License Version
   - 1.1 (the "License"); you may not use this file except in compliance with
   - the License. You may obtain a copy of the License at
   - http://www.mozilla.org/MPL/
   -
   - Software distributed under the License is distributed on an "AS IS" basis,
   - WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
   - for the specific language governing rights and limitations under the
   - License.
   -
   - The Original Code is MozTweak.
   -
   - The Initial Developer of the Original Code is Marek Wawoczny.
   - Portions created by the Initial Developer are Copyright (C) 2002
   - the Initial Developer. All Rights Reserved.
   -
   - Contributor(s):
   - Marek Wawoczny (Marek.Wawoczny@GmbH.rubikon.pl)
   -
   - Alternatively, the contents of this file may be used under the terms of
   - either the GNU General Public License Version 2 or later (the "GPL"), or
   - the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
   - in which case the provisions of the GPL or the LGPL are applicable instead
   - of those above. If you wish to allow use of your version of this file only
   - under the terms of either the GPL or the LGPL, and not to allow others to
   - use your version of this file under the terms of the MPL, indicate your
   - decision by deleting the provisions above and replace them with the notice
   - and other provisions required by the LGPL or the GPL. If you do not delete
   - the provisions above, a recipient may use your version of this file under
   - the terms of any one of the MPL, the GPL or the LGPL.
   -
   - ***** END LICENSE BLOCK ***** */

var gEdit = null;
var gSignaturesGroup = null;
var gSignaturesSignature = null;

function initSignaturesEditor() {
  var signaturesGroup = document.getElementById("signaturesGroup");
  var signaturesSignature = document.getElementById("signaturesSignature");

  if ("arguments" in window) {
    gMozTweakSignaturesRDF = window.arguments[0];
    gSignaturesGroup = window.arguments[1];
    gSignaturesSignature = window.arguments[2];
  }

  if (signaturesGroup && signaturesGroup) {
    gMozTweakSignaturesRDF.addDataSource(signaturesGroup);
    gMozTweakSignaturesRDF.addDataSource(signaturesSignature);

    if (gSignaturesGroup && gSignaturesGroup.selectedItem) {
      signaturesGroup.selectedItem = document.getElementById(gSignaturesGroup.value);
    }

    setSignaturesMenuList();

    if (gSignaturesSignature && gSignaturesSignature.selectedItem) {
      signaturesSignature.selectedItem = document.getElementById(gSignaturesSignature.value);
    }

    editSignaturesSignature();
  }

  MozTweakObserverService.notifyObservers(null, "MozTweak:EditSignaturesWindow:Open", null);

  window.removeEventListener("load", initSignaturesEditor, true);
}

function editSignaturesSignature() {
  var signaturesGroup = document.getElementById("signaturesGroup");
  var signaturesSignature = document.getElementById("signaturesSignature");

  if (!signaturesSignature.selectedItem) {
    setElementsState([ "deleteSignaturesSignature", "signatureInsertMacro", "buttonInsertMacro", "signatureName", "signatureText" ], null, true);
  }
  else {
    var signatureName = document.getElementById("signatureName");
    var signatureText = document.getElementById("signatureText");

    signatureName.value = gMozTweakSignaturesRDF.getItemValue(signaturesSignature.value, "name");
    signatureText.value = gMozTweakSignaturesRDF.getItemValue(signaturesSignature.value, "text").replace(/\\n/g, "\n");

    setElementsState([ "deleteSignaturesSignature", "signatureInsertMacro", "buttonInsertMacro", "signatureName", "signatureText" ], null, false);

    if (signaturesSignature.value == "rdf:vI3uv7AEYtz5") {
      setElementsState([ "deleteSignaturesSignature" ], null, true);
    }
  }
}

function CancelChanges() {
  gMozTweakSignaturesRDF.refreshDataSource();

  MozTweakObserverService.notifyObservers(null, "MozTweak:EditSignaturesWindow:Close", null);

  window.close();
}

function SaveChanges() {
  gMozTweakSignaturesRDF.flushDataSource();

  MozTweakObserverService.notifyObservers(null, "MozTweak:EditSignaturesWindow:Close", null);

  window.close();
}

function changeSignature(aElementID, aValue) {
  var signaturesSignature = document.getElementById("signaturesSignature");

  if (aElementID == "signatureName") {
    var signaturesSignatureID = signaturesSignature.value;
    gMozTweakSignaturesRDF.changeItemValue(signaturesSignatureID, "name", aValue);
    signaturesSignature.selectedIndex = -1;
    signaturesSignature.selectedItem = document.getElementById(signaturesSignatureID);
  }
  else if (aElementID == "signatureText") {
    gMozTweakSignaturesRDF.changeItemValue(signaturesSignature.value, "text", aValue);
  }
}

function addSignaturesSignature() {
  setElementsState([ "signatureInsertMacro", "buttonInsertMacro", "signatureName", "signatureText" ], null, false);

  var signatureName = document.getElementById("signatureName");
  var signatureText = document.getElementById("signatureText");

  signatureName.value = getString("defaultSignatureName.property");
  signatureText.value = getString("defaultSignatureText.property");

  var elementArray = new Object();
  elementArray["name"] = signatureName.value;
  elementArray["text"] = signatureText.value;

  var signaturesSignature = document.getElementById("signaturesSignature");
  var signaturesGroup = document.getElementById("signaturesGroup");
  signaturesSignature.selectedItem = document.getElementById(gMozTweakSignaturesRDF.addNode("moztweak:signature:signature:" + signaturesGroup.value, elementArray));

  setSignaturesMenuList();
  editSignaturesSignature();
}

function deleteSignaturesSignature() {
  var signaturesGroup = document.getElementById("signaturesGroup");
  var signaturesSignature = document.getElementById("signaturesSignature");

  gMozTweakSignaturesRDF.removeNode("moztweak:signature:signature:" + signaturesGroup.value, signaturesSignature.value);

  var signatureName = document.getElementById("signatureName");
  var signatureText = document.getElementById("signatureText");

  signatureName.value = null;
  signatureText.value = null;

  setElementsState([ "deleteSignaturesSignature", "signatureName", "signatureInsertMacro", "buttonInsertMacro", "signatureText" ], null, true);

  setSignaturesMenuList();
  editSignaturesSignature();
}

function InsertMacro() {
  var signatureText = document.getElementById("signatureText");
  var signatureInsertMacro = document.getElementById("signatureInsertMacro");

  signatureText.value = signatureText.value + signatureInsertMacro.value;

  changeSignature("signatureText", signatureText.value.replace(/\n/g, "\\n"));
}

function addSignaturesGroup() {
  var signaturesGroupName = window.prompt(getString("newSignaturesGroupNameDialogBox.property"));

  if (!signaturesGroupName) {
    return;
  }

  var elementArray = new Object();
  elementArray["name"] = signaturesGroupName;

  var signaturesGroupID = gMozTweakSignaturesRDF.addNode("moztweak:signature:group", elementArray);
  gMozTweakSignaturesRDF.addContainer("moztweak:signature:signature:" + signaturesGroupID);

  var signaturesGroup = document.getElementById("signaturesGroup");
  signaturesGroup.selectedItem = document.getElementById(signaturesGroupID);

  var signatureName = document.getElementById("signatureName");
  var signatureText = document.getElementById("signatureText");

  signatureName.value = null;
  signatureText.value = null;

  setSignaturesMenuList();
  editSignaturesSignature();
}

function editSignaturesGroup() {
  var signaturesGroupNewName = window.prompt(getString("signaturesGroupNewNameDialogBox.property"));

  if (!signaturesGroupNewName) {
    return;
  }

  var signaturesGroup = document.getElementById("signaturesGroup");
  var signaturesGroupID = signaturesGroup.value;
  
  gMozTweakSignaturesRDF.changeItemValue(signaturesGroupID, "name", signaturesGroupNewName);

  signaturesGroup.selectedIndex = -1;
  signaturesGroup.selectedItem = document.getElementById(signaturesGroupID);
  
  setSignaturesMenuList();
  editSignaturesSignature();
}

function deleteSignaturesGroup() {
  if (!window.confirm(getString("deleteSignaturesGroupDialogBox.property"))) {
    return;
  }

  var signaturesGroup = document.getElementById("signaturesGroup");

  gMozTweakSignaturesRDF.removeNode("moztweak:signature:group", signaturesGroup.value);
  gMozTweakSignaturesRDF.removeContainer("moztweak:signature:signature:" + signaturesGroup.value);

  setSignaturesMenuList();
  editSignaturesSignature();
}

function setSignaturesMenuList() {
  var signaturesGroup = document.getElementById("signaturesGroup");
  var signaturesSignature = document.getElementById("signaturesSignature");
  
  var signaturesGroupPopup = document.getElementById("signaturesGroupPopup");
  var signaturesSignaturePopup = document.getElementById("signaturesSignaturePopup");

  if (signaturesGroup && signaturesGroupPopup && signaturesGroupPopup.childNodes && signaturesGroupPopup.childNodes.length > 0) {
    try {
      document.getElementById(signaturesGroup.value).id;
    }
    catch (err) {
      signaturesGroup.selectedIndex = 0;
    }

    setElementsState([ "signaturesGroup", "editSignaturesGroup", "deleteSignaturesGroup", "addSignaturesSignature" ], null, false);

    if (signaturesGroup.value == "rdf:cW3shCGDnckg") {
      setElementsState([ "deleteSignaturesGroup" ], null, true);
    }

    signaturesSignature.setAttribute("ref", "moztweak:signature:signature:" + signaturesGroup.value);
  }
  else {
    signaturesGroup.selectedIndex = -1;
    signaturesGroup.label = getString("chooseSignaturesGroup.property");
    setElementsState([ "signaturesGroup", "editSignaturesGroup", "deleteSignaturesGroup", "addSignaturesSignature" ], null, true);

    signaturesSignature.setAttribute("ref", "rdf:null");
  }
  
  if (signaturesSignature && signaturesSignaturePopup && signaturesSignaturePopup.childNodes && signaturesSignaturePopup.childNodes.length > 0) {
    signaturesSignature.selectedIndex = 0;
    setElementsState([ "signaturesSignature", "deleteSignaturesSignature" ], null, false);
  }
  else {
    signaturesSignature.selectedIndex = -1;
    signaturesSignature.label = getString("chooseSignaturesSignature.property");

    var signatureName = document.getElementById("signatureName");
    var signatureText = document.getElementById("signatureText");

    signatureName.value = null;
    signatureText.value = null;

    setElementsState([ "signaturesSignature", "deleteSignaturesSignature", "deleteSignaturesSignature", "signatureInsertMacro", "buttonInsertMacro", "signatureName", "signatureText" ], null, true);
  }
}
