/* ***** BEGIN LICENSE BLOCK *****
   - Version: MPL 1.1/GPL 2.0/LGPL 2.1
   -
   - The contents of this file are subject to the Mozilla Public License Version
   - 1.1 (the "License"); you may not use this file except in compliance with
   - the License. You may obtain a copy of the License at
   - http://www.mozilla.org/MPL/
   -
   - Software distributed under the License is distributed on an "AS IS" basis,
   - WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
   - for the specific language governing rights and limitations under the
   - License.
   -
   - The Original Code is MozTweak.
   -
   - The Initial Developer of the Original Code is Marek Wawoczny.
   - Portions created by the Initial Developer are Copyright (C) 2002
   - the Initial Developer. All Rights Reserved.
   -
   - Contributor(s):
   - Marek Wawoczny (Marek.Wawoczny@GmbH.rubikon.pl)
   -
   - Alternatively, the contents of this file may be used under the terms of
   - either the GNU General Public License Version 2 or later (the "GPL"), or
   - the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
   - in which case the provisions of the GPL or the LGPL are applicable instead
   - of those above. If you wish to allow use of your version of this file only
   - under the terms of either the GPL or the LGPL, and not to allow others to
   - use your version of this file under the terms of the MPL, indicate your
   - decision by deleting the provisions above and replace them with the notice
   - and other provisions required by the LGPL or the GPL. If you do not delete
   - the provisions above, a recipient may use your version of this file under
   - the terms of any one of the MPL, the GPL or the LGPL.
   -
   - ***** END LICENSE BLOCK ***** */

function initMozTweakContextMenuNavigator(aEvent) {
  var contentAreaContextMenu = window.document.getElementById("contentAreaContextMenu");

  if (contentAreaContextMenu)
    contentAreaContextMenu.addEventListener("popupshowing", moztweakContextMenuNavigator, false);

  window.removeEventListener("load", initMozTweakContextMenuNavigator, true);
}

function moztweakContextMenuNavigator(aEvent) {
  if (gContextMenu.isTextSelected && gContextMenu.searchSelected() != "") {
    gContextMenu.showItem("MozTweakMenuDictionary", getPref("moztweak.navigator.menu.dictionary", "bool", true));
    gContextMenu.showItem("MozTweakEncyclopedia", getPref("moztweak.navigator.menu.encyclopedia", "bool", true));
    gContextMenu.showItem("MozTweakOpenPlainLink", getPref("moztweak.navigator.menu.plainlink", "bool", true));
    gContextMenu.showItem("context-sep-open", gContextMenu.onSaveableLink || ( gContextMenu.inDirList && gContextMenu.onLink ) || getPref("moztweak.navigator.menu.plainlink", "bool", true));

    var searchSelectText = gContextMenu.searchSelected();
    if (searchSelectText.length > 15)
        searchSelectText = searchSelectText.substr(0,15) + "...";

    gContextMenu.setItemAttr("MozTweakMenuDictionary", "label", getString("searchDictionaryText.property").replace(/%s/, searchSelectText));
    gContextMenu.setItemAttr("MozTweakEncyclopedia", "label", getString("searchEncyclopediaText.property").replace(/%s/, searchSelectText));
    gContextMenu.setItemAttr("MozTweakOpenPlainLink", "label", getString("openPlainLink.property").replace(/%s/, searchSelectText));
  }
  else {
    gContextMenu.showItem("MozTweakMenuDictionary", false);
    gContextMenu.showItem("MozTweakEncyclopedia", false);
    gContextMenu.showItem("MozTweakOpenPlainLink", false);
  }
}

function CheckFixLink(URL, FixURL) {
  if (FixURL) {
    URL = URL.replace(/^[^a-z]+/i, "");
    URL = URL.replace(/[\.:;\,\'\"\?\!>\}\)\]\|\$%\*]+$/, "");
    URL = URL.replace(/\s+/, "");
      
    if(URL.search(/^\w+:\/\//) == -1) {
      URL = "http://" + URL;
    }
  }

  return URL;
}

function OpenLink(URL, Text, FixURL) {
  URL = URL.replace(/%s/, CheckFixLink(Text, FixURL));

  var browser = getBrowser();
  var tab = browser.addTab(URL, getReferrer(document));

  if (!prefRoot.getBoolPref("browser.tabs.loadInBackground")) {
    browser.selectedTab = tab;
  }
}
