/* ***** BEGIN LICENSE BLOCK *****
   - Version: MPL 1.1/GPL 2.0/LGPL 2.1
   -
   - The contents of this file are subject to the Mozilla Public License Version
   - 1.1 (the "License"); you may not use this file except in compliance with
   - the License. You may obtain a copy of the License at
   - http://www.mozilla.org/MPL/
   -
   - Software distributed under the License is distributed on an "AS IS" basis,
   - WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
   - for the specific language governing rights and limitations under the
   - License.
   -
   - The Original Code is MozTweak.
   -
   - The Initial Developer of the Original Code is Marek Wawoczny.
   - Portions created by the Initial Developer are Copyright (C) 2002
   - the Initial Developer. All Rights Reserved.
   -
   - Contributor(s):
   - Marek Wawoczny (Marek.Wawoczny@GmbH.rubikon.pl)
   -
   - Alternatively, the contents of this file may be used under the terms of
   - either the GNU General Public License Version 2 or later (the "GPL"), or
   - the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
   - in which case the provisions of the GPL or the LGPL are applicable instead
   - of those above. If you wish to allow use of your version of this file only
   - under the terms of either the GPL or the LGPL, and not to allow others to
   - use your version of this file under the terms of the MPL, indicate your
   - decision by deleting the provisions above and replace them with the notice
   - and other provisions required by the LGPL or the GPL. If you do not delete
   - the provisions above, a recipient may use your version of this file under
   - the terms of any one of the MPL, the GPL or the LGPL.
   -
   - ***** END LICENSE BLOCK ***** */

var MozTweakMsgAccountManager = Components.classes["@mozilla.org/messenger/account-manager;1"].getService(Components.interfaces.nsIMsgAccountManager);

var gMozTweakObserver = {
  observe: function(aSubject, aTopic, aData) {
    if (aTopic == "MozTweak:EditSignaturesWindow:Open") {
      this.elementsStateArray = getElementsState([ "signaturesGroup", "signaturesSignature", "insertSignaturesSignature", "randomSignaturesSignature", "defaultSignaturesSignature", "editSignatures" ]);
      setElementsState([ "signaturesGroup", "signaturesSignature", "insertSignaturesSignature", "randomSignaturesSignature", "defaultSignaturesSignature", "editSignatures" ], null, true);
    }
    else if (aTopic == "MozTweak:EditSignaturesWindow:Close") {
      setElementsState([ "signaturesGroup", "signaturesSignature", "insertSignaturesSignature", "randomSignaturesSignature", "defaultSignaturesSignature", "editSignatures" ], this.elementsStateArray, null);
      gMozTweakHeadersRDF.refreshDataSource();
      setSignaturesMenuList();
    }
  }
}

function setSignaturesMenuList() {
  var signaturesGroup = document.getElementById("signaturesGroup");
  var signaturesSignature = document.getElementById("signaturesSignature");
  
  var signaturesGroupPopup = document.getElementById("signaturesGroupPopup");
  var signaturesSignaturePopup = document.getElementById("signaturesSignaturePopup");

  if (signaturesGroup && signaturesGroupPopup && signaturesGroupPopup.childNodes && signaturesGroupPopup.childNodes.length > 0) {
    try {
      document.getElementById(signaturesGroup.value).id;
    }
    catch (err) {
      signaturesGroup.selectedIndex = 0;
    }

    setElementsState([ "signaturesGroup" ], null, false);

    signaturesSignature.setAttribute("ref", "moztweak:signature:signature:" + signaturesGroup.value);
  }
  else {
    signaturesGroup.selectedIndex = -1;
    signaturesGroup.label = getString("chooseSignaturesGroup.property");
    setElementsState([ "signaturesGroup" ], null, true);

    signaturesSignature.setAttribute("ref", "rdf:null");
  }
  
  if (signaturesSignature && signaturesSignaturePopup && signaturesSignaturePopup.childNodes && signaturesSignaturePopup.childNodes.length > 0) {
    signaturesSignature.selectedIndex = 0;
    setElementsState([ "signaturesSignature", "insertSignaturesSignature", "randomSignaturesSignature" ], null, false);
  }
  else {
    signaturesSignature.selectedIndex = -1;
    signaturesSignature.label = getString("chooseSignaturesSignature.property");
    setElementsState([ "signaturesSignature", "insertSignaturesSignature", "randomSignaturesSignature" ], null, true);
  }
}

function initSignatures() {
  var signaturesGroup = document.getElementById("signaturesGroup");
  var signaturesSignature = document.getElementById("signaturesSignature");

  if (signaturesGroup && signaturesSignature) {
    gMozTweakSignaturesRDF.addDataSource(signaturesGroup);
    gMozTweakSignaturesRDF.addDataSource(signaturesSignature);

    setSignaturesMenuList();
  }
  
  MozTweakObserverService.addObserver(gMozTweakObserver, "MozTweak:EditSignaturesWindow:Open", false);
  MozTweakObserverService.addObserver(gMozTweakObserver, "MozTweak:EditSignaturesWindow:Close", false);

  var editSignaturesWindow = MozTweakWindowMediator.getMostRecentWindow("MozTweak:EditSignaturesWindow");

  if (editSignaturesWindow) {
    gMozTweakObserver.observe(null, "MozTweak:EditSignaturesWindow:Open", null);
  }

  // Begin Hack
  var viewSignaturesToolbar = document.createElement("menuitem");
  viewSignaturesToolbar.setAttribute("id", "viewSignaturesToolbar");
  viewSignaturesToolbar.setAttribute("label", getString("signaturesToolbar.property"));
  viewSignaturesToolbar.setAttribute("type", "checkbox");
  viewSignaturesToolbar.setAttribute("oncommand", "goToggleToolbar('signaturesToolbar','viewSignaturesToolbar');");

  var menu_Toolbars = document.getElementById("menu_Toolbars");
  menu_Toolbars.firstChild.appendChild(viewSignaturesToolbar);

  goToggleToolbar('signaturesToolbar','viewSignaturesToolbar');
  goToggleToolbar('signaturesToolbar','viewSignaturesToolbar');
  // End Hack

  window.removeEventListener("load", initSignatures, true);
}

function insertSignaturesSignature(aCase) {
  var signaturesSignature = document.getElementById("signaturesSignature");
  var signaturesSignaturePopup = document.getElementById("signaturesSignaturePopup");

  switch (aCase) {
  case 0:
    setSignature(signaturesSignature.value);
    break;
  case 1:	
    var identityElement = document.getElementById("msgIdentity");

    if (identityElement) {
      gMsgCompose.SetSignature(MozTweakMsgAccountManager.getIdentity(identityElement.value));
    }

    var messageComposeEditor = getMessageComposeEditor();
    if (messageComposeEditor) {
      messageComposeEditor.beginTransaction();
      messageComposeEditor.beginningOfDocument();
      messageComposeEditor.endTransaction();
    }
    break;
  case 2:	
    var randomID = Math.floor(Math.random() * (signaturesSignaturePopup.childNodes.length - 1));
    setSignature(signaturesSignaturePopup.childNodes[randomID].id);
    break;
  default:
   break;
  }
}

function setSignature(aSigantureID) {
  var signatureNode;

  try {
    var messageComposeEditor = getMessageComposeEditor();
    if (messageComposeEditor) {
      var messageComposeEditorHTML = messageComposeEditor.QueryInterface(Components.interfaces.nsIHTMLEditor);

      if (!messageComposeEditor.documentIsEmpty) {

        var messageBody = messageComposeEditor.rootElement;
        if (getMessageComposeEditorType() == "htmlmail") {

          signatureNode = messageBody.lastChild;
           if (signatureNode && signatureNode.nodeName == "PRE") {
            var signatureNodeAttribute = signatureNode.getAttribute("class");
            if (signatureNodeAttribute && signatureNodeAttribute.indexOf("moz-signature") != -1) {
              messageComposeEditor.beginTransaction();
              if (signatureNode.previousSibling && signatureNode.previousSibling.nodeName == "BR") {
                messageComposeEditor.deleteNode(signatureNode.previousSibling)
              }
              messageComposeEditor.deleteNode(signatureNode)
              messageComposeEditor.endTransaction();
            }          	
          }
        }
        else {
          for(var i = messageBody.childNodes.length -1; i >= 0; i--) {
            try {
              if (messageBody.childNodes[i].nodeName == "BR" && messageBody.childNodes[i-1].nodeValue == "-- " && messageBody.childNodes[i-2].nodeName == "BR") {
               signatureNode = messageBody.childNodes[i-2];
               break;
              }
            }
            catch (err) {
              break;
            }
          }

          if (signatureNode) {
            var signatureNodeChild;

            messageComposeEditor.beginTransaction();

            while ((signatureNodeChild = signatureNode.nextSibling)) {
              messageComposeEditor.deleteNode(signatureNodeChild);
            }

            messageComposeEditor.deleteNode(signatureNode);
            messageComposeEditor.endTransaction();
          }
        }
      }

      var signatureText = gMozTweakSignaturesRDF.getItemValue(aSigantureID, "text");
      
      messageComposeEditor.beginTransaction();
      messageComposeEditor.endOfDocument();

      if (getMessageComposeEditorType() == "htmlmail") {
        signatureText = '<br><pre class="moz-signature" cols="$mailwrapcol">-- <br>' + processMacros(signatureText) + '</pre>';
      }
      else {
        signatureText = '<br>-- <br>' + processMacros(signatureText);
      }

      messageComposeEditorHTML.insertHTML(signatureText.replace(/\\n/g, "\n"));
      messageComposeEditor.beginningOfDocument();
      messageComposeEditor.endTransaction();
    }
  }
  catch (err) {
    return;
  }
}

function openEditSignaturesWindow() {
  var signaturesSignature = document.getElementById("signaturesSignature");
  var signaturesGroup = document.getElementById("signaturesGroup");

  window.openDialog("chrome://moztweak/content/moztweak-signature-window.xul", "_blank", "chrome,close,modal,titlebar", gMozTweakSignaturesRDF, signaturesGroup, signaturesSignature);
  window._content.focus();
}

function processMacros (aSignature) {
  var identityElement = document.getElementById("msgIdentity");

  if (identityElement) {
    var gCurrentIdentity = MozTweakMsgAccountManager.getIdentity(identityElement.value);
    
    if (gCurrentIdentity.fullName) {
      aSignature = aSignature.replace(/%FullName%/, gCurrentIdentity.fullName);
    }

    if (gCurrentIdentity.email) {
      aSignature = aSignature.replace(/%Email%/, gCurrentIdentity.email);
      aSignature = aSignature.replace(/%EmailProtected%/, gCurrentIdentity.email.replace(/@/, "(at)"));
    }

    if (gCurrentIdentity.replyTo) {
      aSignature = aSignature.replace(/%ReplyTo%/, gCurrentIdentity.replyTo);
      aSignature = aSignature.replace(/%ReplyToProtected%/, gCurrentIdentity.replyTo.replace(/@/, "(at)"));
    }

    if (gCurrentIdentity.organization) {
      aSignature = aSignature.replace(/%Organization%/, gCurrentIdentity.organization);
    }
  }

  aSignature = aSignature.replace(/%MozillaPL%/, getString("MozillaPLMacro.property"));

  if (typeof(navigator.userAgent) != "undefined") {
    aSignature = aSignature.replace(/%UserAgent%/, navigator.userAgent);
  }

  if (typeof(navigator.appCodeName) != "undefined") {
    aSignature = aSignature.replace(/%AppCodeName%/, navigator.appCodeName);
  }
  
  if (typeof(navigator.appName) != "undefined") {
    aSignature = aSignature.replace(/%AppName%/, navigator.appName);
  }
  
  if (typeof(navigator.appVersion) != "undefined") {
    aSignature = aSignature.replace(/%AppVersion%/, navigator.appVersion);
  }
  
  if (typeof(navigator.language) != "undefined") {
    aSignature = aSignature.replace(/%Language%/, navigator.language);
  }
  
  if (typeof(navigator.oscpu) != "undefined") {
    aSignature = aSignature.replace(/%OSCPU%/, navigator.oscpu);
  }
  
  if (typeof(navigator.platform) != "undefined") {
    aSignature = aSignature.replace(/%Platform%/, navigator.platform);
  }
  
  if (typeof(navigator.product) != "undefined") {
    aSignature = aSignature.replace(/%Product%/, navigator.product);
  }
  
  if (typeof(navigator.productSub) != "undefined") {
    aSignature = aSignature.replace(/%ProductSub%/, navigator.productSub);
  }
  
  if (typeof(navigator.vendor) != "undefined") {
    aSignature = aSignature.replace(/%Vendor%/, navigator.vendor);
  }
  
  if (typeof(navigator.vendorSub) != "undefined") {
    aSignature = aSignature.replace(/%VendorSub%/, navigator.vendorSub);
  }
  
  if (typeof(screen.width) != "undefined") {
    aSignature = aSignature.replace(/%ScreenWidth%/, screen.width);
  }
  
  if (typeof(screen.height) != "undefined") {
    aSignature = aSignature.replace(/%ScreenHeight%/, screen.height);
  }
  
  if (typeof(screen.availHeight) != "undefined") {
    aSignature = aSignature.replace(/%ScreenAvailHeight%/, screen.availHeight);
  }
  
  if (typeof(screen.availWidth) != "undefined") {
    aSignature = aSignature.replace(/%ScreenAvailWidth%/, screen.availWidth);
  }
  
  if (typeof(screen.pixelDepth) != "undefined") {
    aSignature = aSignature.replace(/%ScreenPixelDepth%/, screen.pixelDepth);
  }
  
  if (typeof(screen.colorDepth) != "undefined") {
    aSignature = aSignature.replace(/%ScreenColorDepth%/, screen.colorDepth);
  }

  return aSignature;
}
