/* ***** BEGIN LICENSE BLOCK *****
   - Version: MPL 1.1/GPL 2.0/LGPL 2.1
   -
   - The contents of this file are subject to the Mozilla Public License Version
   - 1.1 (the "License"); you may not use this file except in compliance with
   - the License. You may obtain a copy of the License at
   - http://www.mozilla.org/MPL/
   -
   - Software distributed under the License is distributed on an "AS IS" basis,
   - WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
   - for the specific language governing rights and limitations under the
   - License.
   -
   - The Original Code is MozTweak.
   -
   - The Initial Developer of the Original Code is Marek Wawoczny.
   - Portions created by the Initial Developer are Copyright (C) 2002
   - the Initial Developer. All Rights Reserved.
   -
   - Contributor(s):
   - Marek Wawoczny (Marek.Wawoczny@GmbH.rubikon.pl)
   -
   - Alternatively, the contents of this file may be used under the terms of
   - either the GNU General Public License Version 2 or later (the "GPL"), or
   - the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
   - in which case the provisions of the GPL or the LGPL are applicable instead
   - of those above. If you wish to allow use of your version of this file only
   - under the terms of either the GPL or the LGPL, and not to allow others to
   - use your version of this file under the terms of the MPL, indicate your
   - decision by deleting the provisions above and replace them with the notice
   - and other provisions required by the LGPL or the GPL. If you do not delete
   - the provisions above, a recipient may use your version of this file under
   - the terms of any one of the MPL, the GPL or the LGPL.
   -
   - ***** END LICENSE BLOCK ***** */

function initMozTweakContextMenuROT13(aEvent) {

  var messagePaneContext = document.getElementById("messagePaneContext");
  if (messagePaneContext)
    messagePaneContext.addEventListener("popupshowing", moztweakContextMenuROT13, false);

  var msgComposeContext = document.getElementById("msgComposeContext");
  if (msgComposeContext)
    msgComposeContext.addEventListener("popupshowing", moztweakContextMenuROT13, false);

  window.removeEventListener("load", initMozTweakContextMenuROT13, true);
}

function moztweakContextMenuROT13(aEvent) {
  var hideMozTweakContextMenuROT13 = !getPref("moztweak.mail.menu.rot13", "bool", true);

  var MozTweakSeparator = document.getElementById("MozTweakSeparator");
  if (MozTweakSeparator)
    MozTweakSeparator.setAttribute("hidden", hideMozTweakContextMenuROT13);

  var MozTweakMenuROT13Message = document.getElementById("MozTweakMenuROT13Message");
  if (MozTweakMenuROT13Message)
    MozTweakMenuROT13Message.setAttribute("hidden", hideMozTweakContextMenuROT13);

  var MozTweakMenuROT13Composer = document.getElementById("MozTweakMenuROT13Composer");
  if (MozTweakMenuROT13Composer)
    MozTweakMenuROT13Composer.setAttribute("hidden", hideMozTweakContextMenuROT13);
}


function replaceROT13Tree(aRootElement, aSelectionRange) {
  if (aRootElement.hasChildNodes()) {
    var nodeList = aRootElement.childNodes;

    for (var i=0; i<nodeList.length; i++) {
      if (nodeList[i].nodeType == Node.TEXT_NODE) {
        if (aSelectionRange.compareNode(nodeList[i]) == 3) {
           nodeList[i].nodeValue = encryptDecryptROT13(nodeList[i].nodeValue);
        }
      }
      else {
        if (nodeList[i].hasChildNodes()) {
          replaceROT13Tree(nodeList[i], aSelectionRange);
        }
      }
    }
  }
}

function selectionROT13(aRootElement, aSelection) {
  if (aSelection.rangeCount == 1 && !aSelection.isCollapsed) {
    var selectionRange = aSelection.getRangeAt(0);

    var startContainer = selectionRange.startContainer;
    var endContainer = selectionRange.endContainer;
    var startOffset = selectionRange.startOffset;
    var endOffset = selectionRange.endOffset;

    if (endContainer.nodeName == "BODY") {
      endContainer = selectionRange.commonAncestorContainer.childNodes[endOffset];
    }

    if (startContainer != endContainer) {
      if (startContainer.nodeType == 3) {
        startContainer.replaceData(startOffset, startContainer.nodeValue.length - startOffset, encryptDecryptROT13(startContainer.nodeValue.substring(startOffset, startContainer.nodeValue.length)));
      }

      if (endContainer.nodeType == 3) {
        endContainer.replaceData(0, endOffset, encryptDecryptROT13(endContainer.nodeValue.substring(0, endOffset)));
      }

      replaceROT13Tree(aRootElement, selectionRange);
    }
    else {
      if (startContainer.nodeType == 3) {
        startContainer.replaceData(startOffset, endOffset - startOffset, encryptDecryptROT13(startContainer.nodeValue.substring(startOffset, endOffset)));
      }
    }
    
    aSelection.collapse(startContainer, startOffset);
  }
}

function encryptDecryptROT13(aString) {
  var inAlphabet = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
  var outAlphabet = "nopqrstuvwxyzabcdefghijklmNOPQRSTUVWXYZABCDEFGHIJKLM";
  var outString = "";
  
  var i;

  for (i=0; i< aString.length; i++) {
    var currentChar = aString.charAt(i);
    outString += (currentChar >= 'a' && currentChar <= 'z' || currentChar >= 'A' && currentChar <= 'Z' ? outAlphabet.charAt(inAlphabet.indexOf(currentChar)) : currentChar);
  }

	return outString;
}

function messageComposeEditorROT13() {
  var messageComposeEditor = getMessageComposeEditor();

  if (messageComposeEditor) {
    messageComposeEditor.beginTransaction();
    selectionROT13(messageComposeEditor.rootElement, messageComposeEditor.selection);
    messageComposeEditor.endTransaction();
  }
}

function messageContentFrameROT13() {
  var messageContentFrame = document.getElementById("messagepane");

  if (messageContentFrame) {
    selectionROT13(messageContentFrame.contentWindow.document, messageContentFrame.contentWindow.getSelection());
  }
}