function verifyDiskSpace(dirPath, spaceRequired)
{
  var spaceAvailable;

  spaceAvailable = fileGetDiskSpaceAvailable(dirPath);

  spaceAvailable = parseInt(spaceAvailable / 1024);

  if(spaceAvailable < spaceRequired)
  {
    logComment("Insufficient disk space: " + dirPath);
    logComment("  required : " + spaceRequired + " K");
    logComment("  available: " + spaceAvailable + " K");
    return(false);
  }

  return(true);
}

var srDest;
var err;
var fProgram;
var prettyName = "Mozilla PL - Dodatkowe ustawienia";
var regName    = "moztweak"

srDest = 865;
err    = initInstall(prettyName, regName, "1.0.x");
logComment("initInstall: " + err);

fProgram = getFolder("Program");
logComment("fProgram: " + fProgram);

if(verifyDiskSpace(fProgram, srDest))
{
  setPackageFolder(fProgram);
  err = addDirectory("",
                     "1.0.x",
                     "bin",
                     fProgram,
                     "",
                     true);
  logComment("addDirectory() returned: " + err);
  
  registerChrome(CONTENT | DELAYED_CHROME, getFolder("Chrome", "moztweak.jar"), "content/moztweak/");
  registerChrome(LOCALE | DELAYED_CHROME, getFolder("Chrome", "moztweak.jar"), "locale/en-US/moztweak/");
  registerChrome(LOCALE | DELAYED_CHROME, getFolder("Chrome", "moztweak.jar"), "locale/pl-PL/moztweak/");

    if (err == SUCCESS)
    {
        err = performInstall();
        logComment("performInstall() returned: " + err);
        alert("Instalacja zosta\u0142a zako\u0144czona pomy\u015Blnie. Nale\u017Cy ponownie uruchomi\u0107 przegl\u0105dark\u0119.");
    }
    else
    {
        cancelInstall(err);
        logComment("cancelInstall due to error: " + err);
        alert("Instalacja zosta\u0142a anulowana. Wyst\u0105pi\u0142 b\u0142\u0105d " + err);
    }
}
else
  cancelInstall(INSUFFICIENT_DISK_SPACE);
