function verifyDiskSpace(dirPath, spaceRequired)
{
  var spaceAvailable;

  spaceAvailable = fileGetDiskSpaceAvailable(dirPath);

  spaceAvailable = parseInt(spaceAvailable / 1024);

  if(spaceAvailable < spaceRequired)
  {
    logComment("Insufficient disk space: " + dirPath);
    logComment("  required : " + spaceRequired + " K");
    logComment("  available: " + spaceAvailable + " K");
    return(false);
  }

  return(true);
}

var srDest;
var err;
var fProgram;
var prettyName = "Hermes - your cute messenger";
var regName    = "xhermes"

srDest = 865;
err    = initInstall(prettyName, regName, "0.3.x");
logComment("initInstall: " + err);

fProgram = getFolder("Program");
logComment("fProgram: " + fProgram);

if(verifyDiskSpace(fProgram, srDest))
{
  setPackageFolder(fProgram);
  err = addDirectory("",
                     "0.3.x",
                     "bin",
                     fProgram,
                     "",
                     true);
  logComment("addDirectory() returned: " + err);
  
  registerChrome(CONTENT | DELAYED_CHROME, getFolder("Chrome", "xhermes.jar"), "content/");
  registerChrome(LOCALE | DELAYED_CHROME, getFolder("Chrome", "xhermes.jar"), "locale/en-US/");
  registerChrome(LOCALE | DELAYED_CHROME, getFolder("Chrome", "xhermes.jar"), "locale/pl-PL/");

//registering Service files
  registerChrome(CONTENT | DELAYED_CHROME, getFolder("Chrome", "xservices"), "content/");

//not too much to register right now ;)
//  registerChrome(LOCALE | DELAYED_CHROME, getFolder("Chrome", "xservices"), "locale/en-US/");
//  registerChrome(LOCALE | DELAYED_CHROME, getFolder("Chrome", "xservices"), "locale/pl-PL/");

// If you have localized Hermes remove comment tags /* ...  */  
// from line below and change ab-CD to your locale name. Comment out any locales from 
// above list if you do not want to register them. 

/* registerChrome(LOCALE | DELAYED_CHROME, getFolder("Chrome", "xhermes.jar"), "locale/ab-CD/"); */
/* registerChrome(SKIN | DELAYED_CHROME, getFolder("Chrome", "xhermes.jar"), "skin/"); */



    if (err == SUCCESS)    {
        err = performInstall();
        logComment("performInstall() returned: " + err);
        alert("xHermes was successfuly installed on your system. \nRestart Mozilla and go to Tools > xHermes.\n\nInstalacja zosta\u0142a zako\u0144czona pomy\u015Blnie. Nale\u017Cy ponownie uruchomi\u0107 przegl\u0105dark\u0119, a nast\u0119pnie otworzy\u0107 menu Narz\u0119dzia > xHermes.");
    }
    else
    {
        cancelInstall(err);
        logComment("cancelInstall due to error: " + err);
        alert("Installation has been cancelled. Error code below. \nInstalacja zosta\u0142a anulowana. Wyst\u0105pi\u0142 b\u0142\u0105d\n\n" + err);
    }
}
else
  cancelInstall(INSUFFICIENT_DISK_SPACE);
