!+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
!.IDENTIFICATION: PEPSYS.PRG
!.PURPOSE:        Install PEPSYS table files in DB_PEPSYS directory
!.USE:            
!.AUTHOR:         Andrew T. Young
! ----------------------------------------------------------------------
!
!
!     -->  DON'T FORGET to run 	. dbassign.sh  (or whatever) FIRST !!
!
!
! ********* BEGIN EXECUTION  **********
!
WRITE/OUT " "
WRITE/OUT "Making table files for PEPSYS context..."
WRITE/OUT " "
!
!	Get rid of existing copies...
!
IF AUX_MODE(1) .LE. 1 THEN              !branch for VMS or UNIX
   $ DELETE/NOCONF esotel.tbl
   $ DELETE/NOCONF DB_PEPSYS:esotel.tbl.*
   $ DELETE/NOCONF UBVSTD.tbl
   $ DELETE/NOCONF DB_PEPSYS:UBVSTD.tbl.*
   $ DELETE/NOCONF UVBYST.tbl
   $ DELETE/NOCONF DB_PEPSYS:UVBYST.tbl.*
   $ DELETE/NOCONF esoblue.tbl
   $ DELETE/NOCONF DB_PEPSYS:esoblue.tbl.*
   $ DELETE/NOCONF esored.tbl
   $ DELETE/NOCONF DB_PEPSYS:esored.tbl.*
   $ DELETE/NOCONF danphot.tbl
   $ DELETE/NOCONF DB_PEPSYS:danphot.tbl.*
   $ DELETE/NOCONF saaoUBVRI.tbl
   $ DELETE/NOCONF DB_PEPSYS:saaoUBVRI.tbl.*
   $ DELETE/NOCONF saaouvbyHB.tbl
   $ DELETE/NOCONF DB_PEPSYS:saaouvbyHB.tbl.*
ELSE
   $ rm -f $DB_PEPSYS/esotel.tbl
   $ rm -f esotel.tbl
   $ rm -f $DB_PEPSYS/UBVSTD.tbl
   $ rm -f UBVSTD.tbl
   $ rm -f $DB_PEPSYS/UVBYST.tbl
   $ rm -f UVBYST.tbl
   $ rm -f $DB_PEPSYS/esoblue.tbl
   $ rm -f esoblue.tbl
   $ rm -f $DB_PEPSYS/esored.tbl
   $ rm -f esored.tbl
   $ rm -f $DB_PEPSYS/danphot.tbl
   $ rm -f danphot.tbl
   $ rm -f $DB_PEPSYS/saaoUBVRI.tbl
   $ rm -f saaoUBVRI.tbl
   $ rm -f $DB_PEPSYS/saaouvbyHB.tbl
   $ rm -f saaouvbyHB.tbl
ENDIF
!
!	Restore esotel.tbl
!
INTAPE/FITS 1 esot RAW_PEPSYS:esotel.mt
RESTORE/NAME esot0001.tbl
DELETE/DESC esotel.tbl FILENAME
WRITE/DESC esotel.tbl OBSERVATORY/C/1/72 "La Silla station of European Southern Observatory (ESO)"
IF AUX_MODE(1) .LE. 1 THEN              !branch for VMS or UNIX
   $COPY esotel.tbl DB_PEPSYS:esotel.tbl
ELSE
   $cp esotel.tbl $DB_PEPSYS/esotel.tbl
ENDIF
WRITE/OUT " "
!
!
!	Restore UBVSTD.tbl
!
INTAPE/FITS 1 UBVS RAW_PEPSYS:UBVSTD.mt
RESTORE/NAME UBVS0001.tbl
DELETE/DESC UBVSTD.tbl FILENAME
IF AUX_MODE(1) .LE. 1 THEN              !branch for VMS or UNIX
   $COPY UBVSTD.tbl DB_PEPSYS:UBVSTD.tbl
ELSE
   $cp UBVSTD.tbl $DB_PEPSYS/UBVSTD.tbl
ENDIF
WRITE/OUT " "
!
!
!	Restore UVBYST.tbl
!
INTAPE/FITS 1 UVBY RAW_PEPSYS:UVBYST.mt
RESTORE/NAME UVBY0001.tbl
DELETE/DESC UVBYST.tbl FILENAME
IF AUX_MODE(1) .LE. 1 THEN              !branch for VMS or UNIX
   $COPY UVBYST.tbl DB_PEPSYS:UVBYST.tbl
ELSE
   $cp UVBYST.tbl $DB_PEPSYS/UVBYST.tbl
ENDIF
WRITE/OUT " "
!
!
!	Restore esoblue.tbl
!
INTAPE/FITS 1 esob RAW_PEPSYS:esoblue.mt
RESTORE/NAME esob0001.tbl
DELETE/DESC esoblue.tbl FILENAME
WRITE/DESC esoblue.tbl INSTNAM/C/1/72 "ESO 1-m photometer with BLUE tube and filters"
WRITE/DESC esoblue.tbl FILTCAT/C/1/80 " " all
IF AUX_MODE(1) .LE. 1 THEN              !branch for VMS or UNIX
   $COPY esoblue.tbl DB_PEPSYS:esoblue.tbl
ELSE
   $cp esoblue.tbl $DB_PEPSYS/esoblue.tbl
ENDIF
WRITE/OUT " "
!
!
!	Restore esored.tbl
!
INTAPE/FITS 1 esor RAW_PEPSYS:esored.mt
RESTORE/NAME esor0001.tbl
DELETE/DESC esored.tbl FILENAME
WRITE/DESC esored.tbl INSTNAM/C/1/72 "ESO 1-m photometer with RED tube and filters"
WRITE/DESC esored.tbl FILTCAT/C/1/80 " " all
IF AUX_MODE(1) .LE. 1 THEN              !branch for VMS or UNIX
   $COPY esored.tbl DB_PEPSYS:esored.tbl
ELSE
   $cp esored.tbl $DB_PEPSYS/esored.tbl
ENDIF
WRITE/OUT " "
!
!
!	Restore danphot.tbl
!
INTAPE/FITS 1 danp RAW_PEPSYS:danphot.mt
RESTORE/NAME danp0001.tbl
DELETE/DESC danphot.tbl FILENAME
WRITE/DESC danphot.tbl INSTNAM/C/1/72 "Danish 6-channel photometer on 50-cm SAT"
WRITE/DESC danphot.tbl FILTCAT/C/1/80 " " all
IF AUX_MODE(1) .LE. 1 THEN              !branch for VMS or UNIX
   $COPY danphot.tbl DB_PEPSYS:danphot.tbl
ELSE
   $cp danphot.tbl $DB_PEPSYS/danphot.tbl
ENDIF
WRITE/OUT " "
!
!
!	Restore saaoUBVRI.tbl
!
INTAPE/FITS 1 UVBY RAW_PEPSYS:saaoUBVRI.mt
RESTORE/NAME UVBY0001.tbl
DELETE/DESC saaoUBVRI.tbl FILENAME
IF AUX_MODE(1) .LE. 1 THEN              !branch for VMS or UNIX
   $COPY saaoUBVRI.tbl DB_PEPSYS:saaoUBVRI.tbl
ELSE
   $cp saaoUBVRI.tbl $DB_PEPSYS/saaoUBVRI.tbl
ENDIF
WRITE/OUT " "
!
!
!	Restore saaouvbyHB.tbl
!
INTAPE/FITS 1 UVBY RAW_PEPSYS:saaouvbyHB.mt
RESTORE/NAME UVBY0001.tbl
DELETE/DESC saaouvbyHB.tbl FILENAME
IF AUX_MODE(1) .LE. 1 THEN              !branch for VMS or UNIX
   $COPY saaouvbyHB.tbl DB_PEPSYS:saaouvbyHB.tbl
ELSE
   $cp saaouvbyHB.tbl $DB_PEPSYS/saaouvbyHB.tbl
ENDIF
WRITE/OUT " "
!
!
!	Get rid of local copies.
!
IF AUX_MODE(1) .LE. 1 THEN              !branch for VMS or UNIX
   $ DELETE/NOCONF esotel.tbl.*
   $ DELETE/NOCONF UBVSTD.tbl.*
   $ DELETE/NOCONF UVBYST.tbl.*
   $ DELETE/NOCONF esoblue.tbl.*
   $ DELETE/NOCONF esored.tbl.*
   $ DELETE/NOCONF danphot.tbl.*
   $ DELETE/NOCONF saaoUBVRI.tbl.*
   $ DELETE/NOCONF saaouvbyHB.tbl.*
ELSE
   $ rm -f esotel.tbl
   $ chmod 444 $DB_PEPSYS/esotel.tbl
   $ rm -f UBVSTD.tbl
   $ chmod 444 $DB_PEPSYS/UBVSTD.tbl
   $ rm -f UVBYST.tbl
   $ chmod 444 $DB_PEPSYS/UVBYST.tbl
   $ rm -f esoblue.tbl
   $ chmod 444 $DB_PEPSYS/esoblue.tbl
   $ rm -f esored.tbl
   $ chmod 444 $DB_PEPSYS/esored.tbl
   $ rm -f danphot.tbl
   $ chmod 444 $DB_PEPSYS/danphot.tbl
   $ rm -f saaoUBVRI.tbl
   $ chmod 444 $DB_PEPSYS/saaoUBVRI.tbl
   $ rm -f saaouvbyHB.tbl
   $ chmod 444 $DB_PEPSYS/saaouvbyHB.tbl
ENDIF
!
WRITE/OUT " "
WRITE/OUT "PEPSYS table files are done."
WRITE/OUT " "
WRITE/OUT "Please make sure they have READ permissions and no WRITE perms."
WRITE/OUT " "
!
