!+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
!
!.IDENTIFICATION
!        filters.prg
!.PURPOSE
!        Creation of the database for the Filters GUI.
! .COMMENTS
!        do not forget to run "source dbassign.csh" or ". dbassign.sh"
!        before.
!---------------------------------------------------------------------
!
IF AUX_MODE .LE. 1 THEN                   !in VMS
  write/out "Filters GUI not supported in VMS"
  return
ENDIF
!
!=== Initialization of the database
!
write/out --------------- remove the current database  --------------------
!
$ rm -rf $DB_TRANS
$ mkdir $DB_TRANS
$ mkdir $DB_FILTERS
$ mkdir $DB_CCD
$ mkdir $DB_HST
!
!=== Creation of the filter tables
!
@@ filttab
!
!=== Creation of the CCD tables
!
@@ filtccd
!
!=== Creation of the HST standard tables
!
@@ filthst
!
!=== Transference of the ASCII files
!
write/out --------------- copy the ASCII tables  --------------------
!
$ cp -r $RAW_TRANS/atmos $DB_TRANS/atmos
$ cp -r $RAW_TRANS/bc $DB_TRANS/bc
$ cp -r $RAW_TRANS/efosc1 $DB_TRANS/efosc1
$ cp -r $RAW_TRANS/efosc2 $DB_TRANS/efosc2
$ cp -r $RAW_TRANS/emmi $DB_TRANS/emmi
$ cp -r $RAW_TRANS/emmib $DB_TRANS/emmib
$ cp -r $RAW_TRANS/emmir $DB_TRANS/emmir
$ cp -r $RAW_TRANS/inst $DB_TRANS/inst
$ cp -r $RAW_TRANS/susi $DB_TRANS/susi
$ cp $RAW_TRANS/README $DB_TRANS/README
!
write/out --------------- generate links to existent data  --------------------
!
$ ln -s ../spec/flux $DB_TRANS/esostd
$ ln -s ../spec/ctio $DB_TRANS/ctiostd
