#! /bin/tcsh -f
#
# ------------------------------------------------------
#
# shell procedure dbassign.sh
# define logical names for calibration database
#
# J.D.Ponz 890130
#
# ------------------------------------------------------
#
setenv DB_DATA $MIDASHOME/calib/data

setenv DB_CASPEC $MIDASHOME/calib/data/inst/caspec
setenv RAW_CASPEC $MIDASHOME/calib/raw/inst/caspec
setenv DB_EFOSC $MIDASHOME/calib/data/inst/efosc
setenv RAW_EFOSC $MIDASHOME/calib/raw/inst/efosc
setenv DB_IRSPEC $MIDASHOME/calib/data/inst/irspec
setenv RAW_IRSPEC $MIDASHOME/calib/raw/inst/irspec
setenv DB_EMMI    $MIDASHOME/calib/data/inst/emmi 
setenv RAW_EMMI   $MIDASHOME/calib/raw/inst/emmi
setenv DB_FEROS    $MIDASHOME/calib/data/inst/feros
setenv RAW_FEROS   $MIDASHOME/calib/raw/inst/feros

setenv DB_CTIO  $MIDASHOME/calib/data/spec/ctio
setenv RAW_CTIO  $MIDASHOME/calib/raw/spec/ctio
setenv DB_FLUX  $MIDASHOME/calib/data/spec/flux
setenv RAW_FLUX  $MIDASHOME/calib/raw/spec/flux
setenv DB_OFLUX $MIDASHOME/calib/data/spec/flux_old
setenv RAW_OFLUX $MIDASHOME/calib/raw/spec/flux_old
setenv DB_LYM    $MIDASHOME/calib/data/spec/lyman
setenv RAW_LYM   $MIDASHOME/calib/raw/spec/lyman

setenv DB_EXTI $MIDASHOME/calib/data/spec/exti
setenv RAW_EXTI $MIDASHOME/calib/raw/spec/exti
setenv DB_LINE $MIDASHOME/calib/data/spec/line
setenv RAW_LINE $MIDASHOME/calib/raw/spec/line
setenv DB_PEPSYS $MIDASHOME/calib/data/pepsys
setenv RAW_PEPSYS $MIDASHOME/calib/raw/pepsys

setenv DB_TRANS $MIDASHOME/calib/data/datatrans
setenv RAW_TRANS $MIDASHOME/calib/raw/datatrans
setenv DB_FILTERS $DB_TRANS/filters
setenv RAW_FILTERS $RAW_TRANS/filters
setenv DB_CCD $DB_TRANS/ccd
setenv RAW_CCD $RAW_TRANS/ccd
setenv DB_HST $DB_TRANS/hststd
setenv RAW_HST $RAW_TRANS/hststd

# Creating directories for data if they do not exist.
foreach dir ($DB_DATA $DB_DATA/inst $DB_DATA/spec $DB_CASPEC $DB_EFOSC $DB_IRSPEC $DB_EMMI $DB_EXTI $DB_FLUX $DB_LINE $DB_PEPSYS $DB_CTIO $DB_OFLUX $DB_TRANS $DB_LYM $DB_FEROS)
	if ( ! -d $dir ) then
		echo "	creating $dir"
		mkdir $dir
	endif
end
