!  @(#)verify11.prg	16.1.1.1 (ESO-DMD) 06/19/01 15:44:01 
! ++++++++++++++++++++++++++++++++++++++++++++++++++++++
!
!  MIDAS procedure verify11.prg  to verify MIDAS commands
!  K. Banse     991013, 991222, 001123, 0101
!
!  use as @@ verify11 ffffffff             with f = 1 or 0 (on/off)
!
! ++++++++++++++++++++++++++++++++++++++++++++++++++++++
!
define/par p1 11111111111 n "Enter control flags for entries: "
!
define/local loop/i/1/1 0
define/local rval/r/1/1 0. ? +lower
define/local ival/i/1/5 0 all +lower
define/local rcorr/r/1/20 0. all +lower
define/local icorr/i/1/50 0 all +lower
define/local errsum/i/1/1 0 ? +lower
define/local ccc/c/1/12 "0" all
define/local scale/i/1/1 1 ? +lower
define/local seconds/i/1/2 0,0? +lower
!
delete/temp				!get rid of old temporary files
seconds(1) = m$secs()
write/key sizez/i/1/5 600,600,0,0,0
write/key dispyes/i/1/2 0,0
write/key stop/i/1/1 0
! 
write/out +------------------------------------------+
write/out Start of procedure verify11.prg
write/out +------------------------------------------+
!
write/key ccc {p1}
set/format i1
do loop = 1 11
   if ccc({loop}:{loop}) .eq. "1" @@ verify11,000{loop}
   if errsum .gt. 0 then
      write/out "We got problems with entry 000{loop} in verify11.prg!"
      stop = 1
      return
   endif
enddo
! 
seconds(2) = m$secs()
ival = seconds(2)-seconds(1)
!
write/out +------------------------------------------+
write/out procedure verify11.prg:
write/out Total time elapsed = {ival} seconds.
write/out All tests o.k. - you deserve a coffee now...
write/out +------------------------------------------+
!
!  here the different sub-procedures
!
entry 0001
!
write/out test of CREATE/DISPLAY 
write/out "----------------------"
!
reset/display  >Null
create/display 7 512,512,616,300
dispyes(1) = 1                          !mark that we have display + graphic
dispyes(2) = 1
load/lut rainbow
!
entry 0002
!
write/out test of LOAD/TABLE
write/out "------------------"
!
write/out > build artificial table
! 
create/table middumma
create/colu middumma :x "Frame Pixels" i4 I*4
create/colu middumma :y "Frame Pixels" i4 I*4
create/colu middumma :id "None" a4 C*4
middumma,:x,@1 = 333
middumma,:y,@1 = 456
middumma,:id,@1 = "M"
middumma,:id,@1 = "M"
middumma,:x,@2 = 333
middumma,:y,@2 = 565
middumma,:id,@2 = "M"
middumma,:x,@3 = 368
middumma,:y,@3 = 511
middumma,:id,@3 = "M"
middumma,:x,@4 = 399
middumma,:y,@4 = 565
middumma,:id,@4 = "M"
middumma,:x,@5 = 399
middumma,:y,@5 = 456
middumma,:id,@5 = "M"
! 
middumma,:x,@6 = 459
middumma,:y,@6 = 456
middumma,:id,@6 = "I"
middumma,:x,@7 = 459
middumma,:y,@7 = 565
middumma,:id,@7 = "I"
! 
middumma,:x,@8 = 523
middumma,:y,@8 = 456
middumma,:id,@8 = "D"
middumma,:x,@9 = 523
middumma,:y,@9 = 565
middumma,:id,@9 = "D"
middumma,:x,@10 = 560
middumma,:y,@10 = 549
middumma,:id,@10 = "D"
middumma,:x,@11 = 580
middumma,:y,@11 = 524
middumma,:id,@11 = "D"
middumma,:x,@12 = 580
middumma,:y,@12 = 494
middumma,:id,@12 = "D"
middumma,:x,@13 = 560
middumma,:y,@13 = 470
middumma,:id,@13 = "D"
middumma,:x,@14 = 523
middumma,:y,@14 = 456
middumma,:id,@14 = "D"

middumma,:x,@15 = 620
middumma,:y,@15 = 456
middumma,:id,@15 = "A"
middumma,:x,@16 = 655
middumma,:y,@16 = 565
middumma,:id,@16 = "A"
middumma,:x,@17 = 690
middumma,:y,@17 = 456
middumma,:id,@17 = "A"
 
middumma,:x,@18 = 635
middumma,:y,@18 = 505
middumma,:id,@18 = "AX"
middumma,:x,@19 = 674
middumma,:y,@19 = 505
middumma,:id,@19 = "AX"

middumma,:x,@20 = 734
middumma,:y,@20 = 456
middumma,:id,@20 = "S"
middumma,:x,@21 = 767
middumma,:y,@21 = 456
middumma,:id,@21 = "S"
middumma,:x,@22 = 780
middumma,:y,@22 = 484
middumma,:id,@22 = "S"
middumma,:x,@23 = 767
middumma,:y,@23 = 511
middumma,:id,@23 = "S"
middumma,:x,@24 = 743
middumma,:y,@24 = 511
middumma,:id,@24 = "S"
middumma,:x,@25 = 731
middumma,:y,@25 = 537
middumma,:id,@25 = "S"
middumma,:x,@26 = 743
middumma,:y,@26 = 565
middumma,:id,@26 = "S"
middumma,:x,@27 = 777
middumma,:y,@27 = 565
middumma,:id,@27 = "S"

indisk/fits nttexample.mt wuff.bdf

if dispyes(1) .eq. 1 then
   load/image wuff cuts=470,540
   load/tab middumma :x :y :id,no 1 3 white -1
   wait/secs 1
   clear/chan ov
   load/tab middumma :x :y :id,no 3 5 red -1
   wait/secs 1
   clear/chan ov
   load/tab middumma :x :y ? ? 5 cyan 
   wait/secs 1
   clear/chan ov
   load/tab middumma :x :y :id,no 101 6 yellow 0
   load/tab middumma :x :y ? 1 7 blue 0
else
   write/out No display! You won't see much...
endif
! 
delete/table middumma no
!
entry 0003
!
write/out test of CONVERT/COORDS
write/out "----------------------"
!
in_a = "wcstest.mt"
write/out > indisk/fits {in_a} wcs.bdf
indisk/fits {in_a} wcs.bdf
read/descr wcs
write/keyw outputd 0.0 all
write/out > convert/coords wcs @216,@189
convert/coords wcs @216,@189
do inputi = 1 12
   outputr({inputi}) = outputd({inputi})
enddo
write/keyw rcorr 40.7306,18.356,0,2,42,55.34,18,21,21.73,216,189,1
@@ kcompare rcorr outputr 1,2 0.0001
@@ kcompare rcorr outputr 4,11 0.0001
write/keyw outputd 0.0 all
write/out > convert/coords wcs 40.730574,18.356036
convert/coords wcs 40.730574,18.356036
do inputi = 1 12
   outputr({inputi}) = outputd({inputi})
enddo
@@ kcompare rcorr outputr 1,2 0.0001
@@ kcompare rcorr outputr 4,11 0.0001
write/keyw outputd 0.0 all
write/out > convert/coords wcs 2:42:55.34,18:21:21.73
convert/coords wcs 2:42:55.34,18:21:21.73
do inputi = 1 12
   outputr({inputi}) = outputd({inputi})
enddo
@@ kcompare rcorr outputr 1,2 0.0001
@@ kcompare rcorr outputr 4,11 0.0001
!
entry 0004
!
write/out test of 3d tables
write/out "-----------------"
!
write/out > indisk/fits in3d.mt in3d.tbl
indisk/fits in3d.mt in3d.tbl
! 
write/out > show/table in3d
show/table in3d
! 
define/local pos/i/1/1       0
define/local ndata/i/1/1     0
define/local source/c/1/60   in3d.tbl
define/local scolumn/c/1/16  LAMBDA
define/local srow/i/1/1      1
define/local target/c/1/60   out2d.tbl
define/local tcolumn/c/1/16  tmp
define/local create/i/1/1    1
!
if m$exist(target) .ne. 0 then
  delete/table {target} NO
endif
! 
run MID_EXE:tb3dtest.exe
! 
if m$exist(target) .eq. 0 then
   write/out "we have a problem with 3d table" `in3d.tbl'!
   errsum = errsum+1
   return
endif
! 
write/out > show/table out2d
show/table out2d
! 
entry 0005
!
write/out test of catalog creation from FITS files
write/out "----------------------------------------"
!
inputi(19) = 0
if aux_mode(1) .eq. 1 then		!for VMS
   $ ASSIGN VER11.DAT SYS$OUTPUT
   $ DIR/TOTAL tst*.mt
   $ DEASSIGN SYS$OUTPUT
   define/local vmsfc/i/1/2 0,0
   open/file VER11.DAT read vmsfc
   if vmsfc(1) .lt. 1 then
      write/out "Could not open file VER11.DAT with dir contents..."
      errsum = errsum+1
      return
   endif
  read_loop:
   read/file {vmsfc(1)} inputc
   if vmsfc(2) .gt. -1 then
      if inputc(1:8) .eq. "Total of" then
         inputi(19) = {inputc(9:)}
         write/out total count: {inputi(19)} tst*.mt files
         close/file {vmsfc(1)}
      else
         goto read_loop
      endif
   else
      close/file {vmsfc(1)}
      write/out "Could not find info in file VER11.DAT with dir contents..."
      errsum = errsum+1
      return
   endif
else					!for Unix
   $ls tst*.mt >middumm.dat
   $wc <middumm.dat >indisk.dat	!get the no. of Preben's tst*.mt files
   write/keyw inputi/i/19/1 <indisk.dat
endif
! 
if inputi(19) .gt. 0 then	!we only do it, if verifydio was executed
   create/icat fitsimas tst*.mt
   show/icat fitsimas 
   if outputi .ne. inputi(19) then
      write/out "problem with creating a catalog from FITS files..."
      errsum = errsum+1
      return
   endif
   read/icat fitsimas
endif
! 
entry 0006
!
write/out test of char. keyword arrays
write/out "----------------------------"
! 
define/local charbuf/c*40/1/3 " " all
write/keyw charbuf/c*40/1/1 "This is the first line of keyword: charbuf "
write/keyw charbuf/c*40/2/1 "Here we find the second record... "
write/keyw charbuf/c*40/3/1 "Finally, the last line of `charbuf' "
read/keyw charbuf
write/out ...{charbuf(2)}
inputc = "aaaaaaaaaaaaaa"
inputc = "{charbuf(1)(13:17)}"
if inputc(1:5) .ne. "first" then
   write/out "problem with character keyword arrays..."
   errsum = errsum+1
   return
endif
! 
inputc = "You" // charbuf(2)(9:13) //"the" // charbuf(3)(14:22)
if inputc(1:19) .ne. "Youfindthelast line" then
   write/out "problem with character keyword arrays..."
   errsum = errsum+1
   return
endif
! 
entry 0007
!
if m$existk("alltutos") .eq. 1 then
   if alltutos .eq. 1 return
endif
! 
write/out test of zoom window
write/out "-----------------"
!
if dispyes(1) .ne. 1 then
   write/out "test skipped - no display in use..."
   return
endif
!
write/out "... in the following GET/CURSOR command a zoom window will pop up"
write/out -
"... click once in the main window, then click once in the zoom window"
write/out "... after getting the output, exit from the command by"
write/out "... clicking the right mouse button in the zoom window and "
write/out "... clicking the right mouse button in the main window"
write/out "... you can ignore the text displayed when GET/CURSOR starts"
inquire/keyw inputc "Now, hit RETURN (ENTER) to execute the command"
write/out 
! 
write/out > get/cursor p5=w
get/cursor p5=w
delete/display all
! 
entry 0008
!
write/out  test of MODIFY/DISP parent
write/out "---------------------------"
!
if dispyes(1) .ne. 1 return
! 
reset/display
create/image &u 2,256,256 ? gauss 128,128,128,128
! 
set/graph default
create/disp 0 800,400,0,20 ? no
modify/disp parent
crea/disp 1 400,400,0,0 p4=yes,2                !white background
crea/gra 4 400,400,401,0
set/graph bcol=5
load/lut heat ? d
load/image &u
statist/ima &u
plot/histo &u
!
extract/ima &r = &u [<,@123:>,@123]
find/minmax &r
compute/ima &rr = {outputr(2)}-&r
!
modify/disp parent=root
!
create/gra 0 600,400,401,400
set/graph bcol=0
modify/graph parent
create/gra 1 600,200,0,0
set/gra colo=2
plot/row &r
create/gra 2 600,200,0,201
set/gra colo=4
plot/row &rr
!
modify/disp parent=root
!
crea/random &x = &r F
comp/ima &rr = (&r*500000.) + &x
!
create/disp 9 600,400,0,500 ? no
modify/disp parent
create/gra 3 600,400,0,0
set/graph colo=1
plot/row &rr
modify/gra parent
create/disp 5 210,180,180,40 ? no
modify/disp parent
load/lut rainbow3
load/image &u
create/gra 5 190,80,5,5
set/graph colo=4
plot/row &r
display/lut off
!
delete/graph 0
set/graph bcol=5
plot/row &r
delete/graph 5
!
label/disp "End Subwindow demo" 100,8 O blue 1
show/display all
!
entry 0009
!
write/out  test of heavy memory usage...
write/out "------------------------------"
!
write/out > rebin/linear wuff waff 0.25,0.25
rebin/linear wuff waff 0.25,0.25
write/out > compute/image &a = waff*(1.0-sin(waff))
compute/image &a = waff*(1.0-sin(waff))
write/out > replace/image waff &b <,800=middumma.bdf
replace/image waff &b <,800=middumma.bdf
write/out > write/descr wuff npix 1024,1024
write/descr wuff npix 1024,1024
write/out > fft/frequ wuff ? &a &b
fft/frequ wuff ? &a &b
!
entry 00010
!
write/out  test of MODIFY/DISP, DELETE/GRAPH, ASSIGN/DISP
write/out "----------------------------------------------"
!
if m$existk("alltutos") .eq. 1 then
   if alltutos .eq. 1 return
endif
! 
define/local wini/i/1/20 0 all +lower
! 
if dispyes(1) .eq. 1 then
   reset/display
   write/out > create 4 graphic windows
   create/grap 1 250,100,50,500
   create/grap 2 250,150,250,400
   create/grap 3 300,200,500,300
   create/grap 4 400,300,300,200
   write/key icorr/i/32/2 400,300
   @@ kcompare icorr ididev 32,34
   write/key icorr/i/39/4 100000,0,400,300
   @@ kcompare icorr ididev 39,42
   !
   write/out > create 2 display windows
   create/disp 
   create/disp 1 250,250,600,300
   write/key icorr/i/2/2 250,250
   @@ kcompare icorr ididev 2,3
   write/key icorr/i/9/4 10000,99,250,250
   @@ kcompare icorr ididev 9,12
   write/key icorr/i/14/3 1,0,1
   @@ kcompare icorr ididev 14,16
   !
   wait/secs 0.5
   write/out > move active graphics (4) + display window (1) to icons
   modify/gra icon
   modify/disp icon
   @@ kcompare icorr ididev 2,3
   @@ kcompare icorr ididev 9,12
   @@ kcompare icorr ididev 32,34
   @@ kcompare icorr ididev 39,42
   write/keyw wini/i/1/2 1,2
   write/keyw wini/i/12/4 1,1,1,2
   @@ kcompare wini winopen 1,20
   !
   wait/secs 0.2
   write/out > make graphics window 2 the active one
   assign/gra g,2
   write/keyw icorr/i/32/2 250,150
   @@ kcompare icorr ididev 32,34
   write/key icorr/i/39/4 100000,0,250,150
   @@ kcompare icorr ididev 39,42
   !
   wait/secs 0.2
   write/out >  make display window 0 the active one
   assign/disp d,0
   display/chan 1
   write/key icorr/i/2/2 512,512
   @@ kcompare icorr ididev 2,3
   write/key icorr/i/9/4 30000,99,512,512
   @@ kcompare icorr ididev 9,12
   write/key icorr/i/14/3 2,1,2
   @@ kcompare icorr ididev 14,16
   !
   wait/secs 0.5
   write/out > delete graphics w. 2
   dele/graph 2
   write/keyw icorr/i/32/2 250,100
   @@ kcompare icorr ididev 32,34
   write/key icorr/i/39/4 100000,0,250,100
   @@ kcompare icorr ididev 39,42
   ! 
   wait/secs 0.5
   write/out > delete graphics w. 4 and make graphics w. 3 the active one
   dele/graph 4
   assign/gra g,3
   write/keyw icorr/i/32/2 300,200
   @@ kcompare icorr ididev 32,34
   write/key icorr/i/39/4 100000,0,300,200
   @@ kcompare icorr ididev 39,42
   !
   wait/secs 0.5
   write/out > delete display window 0
   dele/disp 0
   write/key icorr/i/2/2 250,250
   @@ kcompare icorr ididev 2,3
   write/key icorr/i/9/4 10000,99,250,250
   @@ kcompare icorr ididev 9,12
   write/key icorr/i/14/3 1,0,1
   @@ kcompare icorr ididev 14,16
   !
   wait/secs 0.5
   write/out > move active display window back to screen
   modify/disp win
   write/keyw wini/i/1/2 0,1
   write/keyw wini/i/12/4 1,0,1,0
   @@ kcompare wini winopen 1,20
   !
   wait/secs 0.5
   write/out > delete graphics w. 3
   dele/graph 3
   write/keyw icorr/i/32/2 250,100
   @@ kcompare icorr ididev 32,34
   write/key icorr/i/39/4 100000,0,250,100
   @@ kcompare icorr ididev 39,42
   @@ kcompare icorr ididev 2,3
   @@ kcompare icorr ididev 9,12
   @@ kcompare icorr ididev 14,16
   ! 
   write/keyw wini/i/12/4 1,0,0,0
   @@ kcompare wini winopen 1,20
   write/out > show/display
   show/display
   !
   wait/secs 0.5
   write/out > reset/display
   reset/disp
endif   
!
entry 00011
! 
write/out  test of `drs' command (Midas command from Unix command line)
write/out "------------------------------------------------------------"
!
if m$existk("alltutos") .eq. 1 then
   if alltutos .eq. 1 return
endif
! 
if aux_mode(1) .eq. 1 then
   write/out this test only on Unix systems...
   return
endif
! 
! use keywords for safety
in_a = m$symbol("MIDASHOME")
in_b = m$symbol("MIDVERS")
! 
! copy shell script + make it executable
$ cp $MIDASHOME/$MIDVERS/test/prim/testdrs.sh testdrs.sh
$ chmod +x testdrs.sh
if dispyes(1) .ne. 1 then
   $ ./testdrs.sh {in_a} {in_b}
else
   $ xterm -geometry 80x25+10+10 -e ./testdrs.sh {in_a} {in_b}
endif
!
copy/dk kukiwuki statistic outputr
write/key rcorr/r/1/4  0.0,418100.2,122077.9,98424.14
@@ kcompare rcorr outputr 1,4 0.1
write/key rcorr/r/5/2  0.6793876,2.514770
@@ kcompare rcorr outputr 5,6 0.0001
write/key rcorr/r/8/5   99092.72,819.804,256.0,1639.609,819.8043
@@ kcompare rcorr outputr 8,12 0.01
$ rm -f kukiwuki.bdf testdrs.sh

