! @(#)Xverify1.prg	16.1.1.1 (ESO-DMD) 06/19/01 15:43:50 
! ++++++++++++++++++++++++++++++++++++++++++++++++++++++
!
!  MIDAS procedure Xverify1.prg  to verify MIDAS commands
!  K. Banse     010302
!
!  use as @@ Xverify1 ffffffffff             with f = 1 or 0 (on/off)
!
! ++++++++++++++++++++++++++++++++++++++++++++++++++++++
!
define/par p1 1111111111 n "Enter control flags for entries: "
!
define/local loop/i/1/1 0
define/local rval/r/1/1 0. ? +lower
define/local ival/i/1/5 0 all +lower
define/local seconds/i/1/2 0,0 ? +lower
define/local rcorr/r/1/20 0. all +lower
define/local icorr/i/1/20 0 all +lower
define/local errsum/i/1/1 0 ? +lower
define/local ccc/c/1/10 0000000000
define/local secs/i/1/2 0,0 ? +lower
define/local myvals/i/1/2 0,0 ? +lower
!
delete/temp                             !get rid of old temporary files
! 
write/key sizez/i/1/5 600,600,0,0,0
write/key dispyes/i/1/2 0,0
write/key stop/i/1/1 0
!
write/out +------------------------------------------+
write/out Start of procedure Xverify1.prg
write/out +------------------------------------------+
!
seconds(1) = m$secs()
write/key ccc {p1}
set/format i1
do loop = 1 4
   if ccc({loop}:{loop}) .eq. "1" @@ Xverify1,000{loop}
   if errsum .gt. 0 then
      write/out "We got problems with entry 000{loop} in Xverify1.prg!"
      stop = 1
      return
   endif
enddo
seconds(2) = m$secs()
ival = seconds(2)-seconds(1)
!
write/out +------------------------------------------+
write/out procedure Xverify1.prg:
write/out Total time elapsed = {ival} seconds.
write/out All tests o.k. - you deserve a coffee now...
write/out +------------------------------------------+
!
!  here the different sub-procedures
!
entry 0001
!
write/out test of CREATE/DISPLAY + CREATE/GRAPHICS
write/out "----------------------------------------"
!
create/display 7 512,512,616,300
create/gra 3 600,400,0,380
dispyes(1) = 1                          !mark that we have display + graphic
dispyes(2) = 1
display/lut off
load/lut smooth
!
entry 0002
!
write/out test of REBIN/TT, SELECT/TABLE, ...
write/out "-----------------------------------"
!
! this is procedure w200mb.prg of Marc S.
! inserted into the verification setup by KB
! 
! it's quite an old procedure and worked happily until 98NOV
! then "fixes" of Midas screwed it up, only since 01FEB it's working again
! it's not the best example of a Midas procedure...
! - commands are abbreviated and the old syntax 'keyword' is used
! so it also serves as a test for backwards compatibility
! 
define/par P1 2000p C  "year and site:YYYYS"
define/local avein/R/1/1 0.0
define/local aveout/R/1/1 0.0
define/local avewhat/R/1/1 0.0
define/local rangemin/R/1/1 0.0
define/local rangemax/R/1/1 0.0
! 
set/format i1
write/out > "now, we read in a big FITS table, please, be patient"
display/long
! 
secs(1) = m$secs()
indisk/fits phot2000p.tfits phot2000p.tbl
secs(2) = m$secs()
ival = secs(2)-secs(1)
write/out > indisk/fits of `phot2000p.tfits' took {ival} seconds ...
! 
show/table phot2000p.tbl
indisk/fits ws200mb2000p.tfits ws200mb2000p.tbl
show/table ws200mb2000p.tbl
!
crea/tab bias-5ms-11cm 2 1000 bias-5ms-11cm.asc
name/colu bias-5ms-11cm #1 :wfspeed "m/s"
name/colu bias-5ms-11cm #2 :bias "attenuation"
!
sele/tab  phot'P1' all
copy/tab phot'P1' mix'P1'
!
sele/tab  ws200mb'P1' all
compu/tab ws200mb'P1' :bin=0.25
compu/tab mix'P1' :bin=1./24./60.
rebin/tt mix'P1' :yearly99,:w200mb,:bin ws200mb'P1' -
         :yearly99,:jetspeed,:bin LIN 0.,1. LIN
sele/tab mix'P1' :w200mb.gt.0
stat/tab mix'P1' :w200mb
compute/key aveout = OUTPUTR(3)
stat/tab mix'P1' :yearly99
compute/key rangemin = OUTPUTR(1)
compute/key rangemax = OUTPUTR(2)
sele/tab ws200mb'P1' :yearly99.le. 'rangemax'.and. -
         :yearly99.ge. 'rangemin'
stat/tab ws200mb'P1' :jetspeed
compute/key avein = OUTPUTR(3)
compu/tab mix'P1' :w200mb = :w200mb * 'avein' / 'aveout' / 10.
name/colu mix'P1' :w200mb "velocity,m/s"
sele/tab ws200mb'P1' all
!
compu/tab mix'P1' :wfspeed=:w200mb+0.001*MOD(:w200mb,:scint)
sort/tab mix'P1' :wfspeed
project/tab mix'P1' test :yearly99 :filfwhm :filscintz :filisopla :w200mb
!
compu/tab test :w400mb=0.5*:w200mb
name/colu test :w400mb "half w200mb, m/s"
rebin/tt test :w200mb,:bias0 bias-5ms-11cm :wfspeed,:bias lin 0,1 lin
try2000-1:
compu/tab test :bias0=abs(:bias0)
sele/tab test :w200mb.ge.30.0.and.:w200mb.le.30.01
stat/tab test :bias0
compute/key aveout = OUTPUTR(3)
sele/tab test all
sele/tab  bias-5ms-11cm :wfspeed.eq.30
stat/tab bias-5ms-11cm :bias
compute/key avein = OUTPUTR(3)
sele/tab  bias-5ms-11cm all
compu/tab test :bias200mb=:bias0* 'avein' / 'aveout'
compu/tab test :filscintzc=:filscintz/:bias200mb
name/colu test :filscintzc "10mn ave,zenith@0.5mu"
compu/tab test :filisoplac=:filisopla*(:bias200mb)**(3./5.)
name/colu test :filisoplac "10mn ave,arcsec@0.5mu"
compu/tab test :hbarc=6.52/:filfwhm/:filisoplac
name/colu test :hbarc "altitude, km above site"
compu/tab test :tau0c=0.98*0.31*5E-07/:filfwhm/:w200mb/5E-6
name/colu test :tau0c "AO time constant, second"
!
! now for half the velocity
rebin/tt test :w400mb,:bias0 bias-5ms-11cm :wfspeed,:bias lin 0,1 lin
compu/tab test :bias0=abs(:bias0)
sele/tab test :w400mb.ge.16.0.and.:w400mb.le.16.01
stat/tab test :bias0
compute/key aveout = OUTPUTR(3)
sele/tab test all
sele/tab  bias-5ms-11cm :wfspeed.eq.16
stat/tab bias-5ms-11cm :bias
compute/key avein = OUTPUTR(3)
sele/tab  bias-5ms-11cm all
compu/tab test :bias400mb=:bias0* 'avein' / 'aveout'
compu/tab test :filscintzcc=:filscintz/:bias400mb
name/colu test :filscintzcc "10mn ave,zenith@0.5mu"
compu/tab test :filisoplacc=:filisopla*(:bias400mb)**(3./5.)
name/colu test :filisoplacc "10mn ave,arcsec@0.5mu"
compu/tab test :hbarcc=6.52/:filfwhm/:filisoplacc
name/colu test :hbarcc "altitude, km above site"
compu/tab test :tau0cc=0.98*0.31*5E-07/:filfwhm/:w400mb/5E-6
name/colu test :tau0cc "AO time constant, second"
compu/tab test :tau0ms=0.98*0.31*5E-07/:filfwhm/5E-6
compu/tab test :tau0ms=1000.*:tau0ms*5./2./MAX(14,:w200mb)
name/colu test :tau0ms "AO Time Cst, ms"
!
-rename test.tbl mix'P1'.tbl
sort/tab  mix'P1' :yearly99
compu/tab mix'P1' :time=24.*(:yearly99-int(:yearly99-0.5))
name/colu  mix'P1' :time "U.T"
write/out w200mb.prg successfully terminated...
!
if aux_mode(1) .eq. 1 then
   -delete phot*.tbl.*
   -delete phot*.tfits.*
   -delete vimos200mb20*.*.*
   -delete mix*.tbl.*
else
   -delete phot*.tbl
   -delete phot*.tfits
   -delete vimos200mb20*.*
   -delete mix*.tbl.*
endif
! 
entry 0003
!
write/out  test of memory leaks  
write/out "--------------------"
!
set/format i1
write/out > while this loop is running 100 times, 
write/out > check the memory usage (via ps, top, ...)
! 
do ival = 1 100
   write/out mem_loop no. {ival}
   @@ Xverify1,memory timmi2.fits
enddo
! 
entry memory
!
! this is a procedure from M. Sperl from Vienna
! used in the context of the TIMMI2 data pipeline
! 
!check input parameter
DEFINE/MAXPAR 1
DEFINE/PARAMETER P1 ? I "Frame to process"
DEFINE/LOCAL BDFIN/C/1/200 "{P1}" ? +lower_levels
!common defines
DEFINE/LOCAL MAJOR/I/1/1       {{BDFIN},ESO.OBS.MAJOR}          ? +lower_levels
DEFINE/LOCAL MINOR/I/1/1       {{BDFIN},ESO.OBS.MINOR}          ? +lower_levels
DEFINE/LOCAL FINISH/I/1/1      {{BDFIN},ESO.PRO.REDU.FINISH}    ? +lower_levels
DEFINE/LOCAL NAXIS/I/1/1       {{BDFIN},NAXIS}                  ? +lower_levels
DEFINE/LOCAL PARMSET/C/1/200   "{{BDFIN},ESO.PRO.REDU.PPARSET}" ? +lower_levels
!define PATHs
DEFINE/LOCAL BASENAME/C/1/200  "x"                              ? +lower_levels
if aux_mode(1) .eq. 1 then
   $ dir
else
   $ basename {P1} .fits | WRITE/KEYWORD BASENAME
endif
!redefine BDFIN copy if necessary
BDFIN = "{BASENAME}_in.bdf"
INDISK/FITS {P1} {BDFIN} NO >Null
!define BDFOUT
DEFINE/LOCAL BDFOUT/C/1/200 "{BDFIN}" ? +lower_levels

