/* @(#)mtest.c	16.1.1.1 (ES0-DMD) 06/19/01 15:42:52 */
/*===========================================================================
  Copyright (C) 1995 European Southern Observatory (ESO)
 
  This program is free software; you can redistribute it and/or 
  modify it under the terms of the GNU General Public License as 
  published by the Free Software Foundation; either version 2 of 
  the License, or (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public 
  License along with this program; if not, write to the Free 
  Software Foundation, Inc., 675 Massachusetss Ave, Cambridge, 
  MA 02139, USA.
 
  Corresponding concerning ESO-MIDAS should be addressed as follows:
	Internet e-mail: midas@eso.org
	Postal address: European Southern Observatory
			Data Management Division 
			Karl-Schwarzschild-Strasse 2
			D 85748 Garching bei Muenchen 
			GERMANY
===========================================================================*/

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
.TYPE        Program
.NAME        mtest.c
.LANGUAGE    C
.AUTHOR      IPG-ESO Garching
.CATEGORY    Stand-alone program to test ioctl's for Tapes
.COMMENTS    Tape management. 
		The program writes 2 10k files, separated by a tape-mark.
		The device is given as $TAPE.
.VERSION 1.0 19-Dec-1989: Creation.
.ENVIRONMENT UNIX
------------------------------------------------------------*/

#define BLKSIZE	2048	
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <sys/mtio.h>
#include <errno.h>

char *getenv();

static int iostat(fd)
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
.PURPOSE Get status.
.RETURNS Not-zero when error
------------------------------------------------------------*/
int fd;                 /* IN:  Tape device file descriptor */
{
        static struct mtget mt;

        if (ioctl(fd,MTIOCGET,&mt) == -1) {
                perror("****Can'tget Status ! ");
                return(-1);
                }

        return(mt.mt_erreg);
}

static int ioctop(fd,op,count)
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
.PURPOSE Execute requested operation
.RETURNS 0 / -1 (error)
------------------------------------------------------------*/
int fd;                 /* IN:  Tape device file descriptor */
int op;                 /* IN:  Operation */
int count;              /* IN:  How many of them */
{
        static struct mtget mtget;
        static struct mtop mtop;
        int stat, ret;

        mtop.mt_op = op;
        mtop.mt_count = count;

        /*
        ** First try to execute the command.
        ** Even if fails, try to read the status
        */
        if ((ret = ioctl(fd,MTIOCTOP,&mtop)) == -1)
                perror("****Failed in ioctl");

        /*
        ** Get status of last command
        */
        stat = iostat(fd);

        return(stat);
}



main()
{
	int i, n, fd, st;
	static char buffer[10*BLKSIZE] = "Test buffer";

	/* 1) Open the Exabyte in WRITE mode */
    fd = open(getenv("TAPE"), 1);
    if (fd < 0)	{ perror("****Can't open in Write mode"); return; }

	/* 2) Rewind the Tape */
    if (ioctop(fd,MTREW,0) < 0)	perror("****Failed to Rewind");

	/* 3) Write 2 files made of 10 blocks followed by a TM */
    for (n=0; n<2; n++)
    {	for (i=0; i<10; i++)
	{    st = write(fd, buffer, BLKSIZE);
	     printf("Written file %d, block %d - Status=%d\n", 
		n, i, st);
	}
        if (ioctop(fd,MTWEOF,1) < 0)	perror("****Failed in WEOF");
	printf("....TM written\n");
    }

    close(fd);

	/* 4) Reopen the Tape in Read Mode, rewind */
    fd = open(getenv("TAPE"), 0);	/* Open in READ mode */
    if (fd < 0)	{ perror("****Can't open in Read mode"); return; }

    if (ioctop(fd,MTREW,0) < 0)	perror("****Failed to Rewind");

	/* 5) Read Record with 2k buffersize. Check that 10 are read... */
    for (n=0; n<2; n++)
    {	for (i=0; ; i++)
	{   buffer[0] = '\0';
	    st = read(fd, buffer, sizeof(buffer));
	    if (st == 0) { printf("....TM found\n"); break; }
	    printf("Read File #%d, block #%d: %s\n", n, i, buffer);
	    if (st != BLKSIZE) 
		printf("****Found %d-byte block instead of %d-byte\n", 
		st, BLKSIZE);
	}
	if (i != 10)	printf("****Found %d blocks instead of %d\n", 
		i, 10);
    }
    printf("\n====Test Program Terminated====\n");
}

