/* @(#)devtest.c	16.1.1.1 (ES0-DMD) 06/19/01 15:42:52 */
/*===========================================================================
  Copyright (C) 1995 European Southern Observatory (ESO)
 
  This program is free software; you can redistribute it and/or 
  modify it under the terms of the GNU General Public License as 
  published by the Free Software Foundation; either version 2 of 
  the License, or (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public 
  License along with this program; if not, write to the Free 
  Software Foundation, Inc., 675 Massachusetss Ave, Cambridge, 
  MA 02139, USA.
 
  Corresponding concerning ESO-MIDAS should be addressed as follows:
	Internet e-mail: midas@eso.org
	Postal address: European Southern Observatory
			Data Management Division 
			Karl-Schwarzschild-Strasse 2
			D 85748 Garching bei Muenchen 
			GERMANY
===========================================================================*/

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
.TYPE        Module
.NAME        iodev
.LANGUAGE    C
.AUTHOR      IPG-ESO Garching
.CATEGORY    Host operating system interfaces. Tape management.
.COMMENTS    Tape management. 
             The functions of this module perform basic i/o to
             magnetic tapes on Ultrix enviroments
.VERSION     [1.0] 12-Aug-1988   Implementation     C. Guirao
.VERSION     [1.1] 28-Nov-1988   Modifications in ioopen     C. Guirao
.VERSION     [2.0] 12-May-1989   For SUN TAPE driver 4.0.1   C. Guirao
.ENVIRONMENT SUN OS. Ver 4.0.1 
------------------------------------------------------------*/
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <strings.h>
#include <sys/ioctl.h>
#include <sys/mtio.h>

static char myname[80];
static	struct stat buf;

main()
{
   printf("Give a device name, e.g. /dev/nrst2 : ");
   gets(myname);
   ioopen(myname, 0, 0);
   ospexit(0);
}

ioopen(name,mode,den)
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
.PURPOSE Open a tape device
.RETURNS File descriptor / -1 (error)
.REMARKS System dependencies:
 -- UNIX: open(2), fstat(2)
------------------------------------------------------------*/
char *name;             /* IN:  Physical name of tape device */
int mode;               /* IN:  Open mode */
int den;                /* IN:  Density. Not used */
{
        int fd;
        int t;

        switch(mode) {          /* Open operations */
        case 0:      t = O_RDONLY; break;
        case 1:     t = O_WRONLY; break;
        case 2:     t = O_RDWR; break;
        case 3:    t = O_RDWR; break;
        default:        return(-1);
        }

        if ( (fd = open(name,t)) == -1) {
                return(-1);
                }


        if ( fstat(fd,&buf) == -1) {
                return(-1);
                }

        if ( (buf.st_mode & S_IFMT) != S_IFCHR) {
                return(-1);
                }
        return(fd);
}

