! @(#)verifydio.prg	16.1.1.2 (ESO-DMD) 07/08/01 10:46:29 
! +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
!.COPYRIGHT  (c) 1993  European Southern Observatory
!.TYPE       Procedure
!.IDENT      verifydio.prg
!.AUTHOR     P.Grosbol,   ESO/IPG
!.PURPOSE    Test and verification of FITS I/O commands
!.ALGORITHM  Read in a set of reference FITS files, check
!            some data values in them, re-do it after a
!            INTAPE/OUTTAPE cycle.
!.USAGE      @@ verifydio
!.VERSION    1.0  1993-Sep-17 : Creation,  PJG
!  010703	last modif
! ------------------------------------------------------------------
!
! Define local keywords for tests
!
if mid$sys(1:8) .eq. "Alpha/Li" .or. aux_mode(1) .eq. 1 then
   define/local  xxxCPU/i/1/1  1		!also for VMS
else
   define/local  xxxCPU/i/1/1  0
endif
DEFINE/LOCAL  REF/R/1/13  0.0 all
DEFINE/LOCAL  VAL/R/1/13  0.0 all
WRITE/KEY     FTEST/I/1/1 0
write/key stop/i/1/1 0
set/format ,e15.5			!set format for double data
!
! Reference values
!
ref(1)  = 1.273543E+2
val(1)  = 7.394488E+1
ref(2)  = 3.600000E+1
val(2)  = 2.107224E+1
ref(3)  = 1.856400E+4
val(3)  = 1.071779E+4
ref(4)  = 3.532000E+1
val(4)  = 1.129088E-1
ref(5)  = 0.000000
val(5)  = 9.560513E+1
ref(6)  = -3.560797E-8
val(6)  = 2.262827E+1
ref(7)  = 4.8446182E+02
val(7)  = -2.4352182E-02
ref(8)  = 2.10188154006588375E+19
val(8)  = -6.52064009369660060E-16
ref(9)  = -12300.1204232321033
val(9)  = 234567.89
ref(10) = 6.52064009369660060E-16
val(10) = -2.4352182E-02
ref(11) = 0.0
val(11) = 0.0
ref(12) = 0.0
val(12) = 0.0
ref(13) = 7.50000E+0
val(13) = 4.60991E+0
!
! Read standard FITS file in
!
if xxxCPU .eq. 1 then
   intape  1-6 zzz tst
   intape  9-13 zzz tst
else
   intape  1-13 zzz tst
endif
!
! Check frame  1:
!
stat/ima  zzz0001 ? ? ? SN
@@ verifysc  {outputr(3)}  {ref(1)}  "Frame 1 mean"
@@ verifysc  {outputr(4)}  {val(1)}  "Frame 1 rms."
!
! Check frame  2:
!
stat/ima  zzz0002 ? ? ? SN
@@ verifysc  {outputr(3)}  {ref(2)}  "Frame 2 mean"
@@ verifysc  {outputr(4)}  {val(2)}  "Frame 2 rms."
!
! Check frame  3:
!
stat/ima  zzz0003 ? ? ? SN
@@ verifysc  {outputr(3)}  {ref(3)}  "Frame 3 mean"
@@ verifysc  {outputr(4)}  {val(3)}  "Frame 3 rms."
!
! Check frame  4:
!
stat/ima  zzz0004 ? ? ? SN
@@ verifysc  {outputr(3)}  {ref(4)}  "Frame 4 mean"
@@ verifysc  {outputr(4)}  {val(4)}  "Frame 4 rms."
!
! Check frame  5:
!
stat/ima  zzz0005 ? ? ? SN
@@ verifysc  {outputr(3)}  {ref(5)}  "Frame 5 mean"
@@ verifysc  {outputr(4)}  {val(5)}  "Frame 5 rms."
!
! Check frame  6:
!
stat/ima  zzz0006 ? ? ? SN
@@ verifysc  {outputr(3)}  {ref(6)}  "Frame 6 mean"
@@ verifysc  {outputr(4)}  {val(6)}  "Frame 6 rms."
!
! Check frame  7:
!
if xxxCPU .eq. 1 then
   write/out "special data files zzz0007, zzz0008 omitted for Alpha-Linux..."
else
   @@ verifysc  {zzz0007[@24]}  {ref(7)}  "Frame 7 pixel 24"
   @@ verifysc  {zzz0007[@35]}  {val(7)}  "Frame 7 pixel 35"
   !
   ! Check frame  8:
   !
   @@ verifysc  {zzz0008[@24]}  {ref(8)}  "Frame 8 pixel 24"
   @@ verifysc  {zzz0008[@35]}  {val(8)}  "Frame 8 pixel 35"
endif
!
! Check frame  9:
!
@@ verifysc  {zzz0009,:mass,@8}   {ref(9)}  "Table 9 :Mass @8"
@@ verifysc  {zzz0009,:dist,@53}  {val(9)}  "Table 9 :Dist @53"
!
! Check frame 10:
!
@@ verifysc  {zzz0010,:coor,@4}   {ref(10)}  "Table 10 :Coor @4"
@@ verifysc  {zzz0010,:complex,@6}  {val(10)}  "Table 10 :Complex @6"
!
! Check frame 13:
!
stat/ima  zzz0013 ? ? ? SN
@@ verifysc  {outputr(3)}  {ref(13)}  "Frame 13 mean"
@@ verifysc  {outputr(4)}  {val(13)}  "Frame 13 rms."
!
! Write frames out again
!
create/icat zzzi zzz*.bdf
create/tcat zzzt zzz0009.tbl,zzz0010.tbl,zzz0011.tbl,zzz0012.tbl
add/tcat zzzt zzz0012a.tbl
!
! Write frames out with different options
!
!  Catalog option
!
outtape  zzzi  zzi NNN
outtape  zzzt  zzt NNN
!
!  Explicit
!
outtape  zzz0003.bdf  zzx0003.mt  NNN
!
! Read them back and check
!
if xxxCPU .eq. 1 then
   intape  12 zzi zzi N
   stat/ima  zzi0012 ? ? ? SN
else
   intape  14 zzi zzi N
   stat/ima  zzi0014 ? ? ? SN
endif
@@ verifysc  {outputr(3)}  {ref(13)}  "Frame 14 mean"
@@ verifysc  {outputr(4)}  {val(13)}  "Frame 14 rms."
!
intape 5 zzt zzt N
@@ verifysc  {zzt0005,:mass,@8}   {ref(9)}  "Table 9 :Mass @8"
@@ verifysc  {zzt0005,:dist,@53}  {val(9)}  "Table 9 :Dist @53"
! 
! check out INDISK/FITS for FITS extensions
write/out > checking INDISK/FITS for FITS file with extensions
write/out > indisk/fits tst0012.mt
indisk/fits tst0012.mt
if outputi(10) .ne. 4 then
   write/out problems with INDISK/FITS of tst0012.mt ...
   stop = 1
   return
endif
! 
crea/tcat klaus zzt*.mt origin
read/tcat klaus
write/out > indisk/fits klaus.cat lola*
indisk/fits klaus.cat lola*
inputc = "{lola0005.tbl,tlabl005} "
if inputc(1:5) .ne. "Mass " then
   write/out problems with INDISK/FITS klaus.cat lola* ...
   stop = 1
   return
endif
!
! Report status
!
IF FTEST(1) .eq. 0 THEN
 WRITE/OUT FITS I/O test completed and o.k.
 IF AUX_MODE(1) .EQ. 1 THEN		!VMS
   $ DELETE/NOCONF zz*.*.*
   $ DELETE/NOCONF toto0*.*.*
   $ DELETE/NOCONF lola0*.*.*
 ELSE					!UNIX
   $ rm -f zz* toto0*.* lola0*.*
 ENDIF
ELSE
 WRITE/OUT FITS I/O test completed with ERROR - check LIST!!!
 stop = 1
ENDIF
