/* @(#)textdemo.c	16.1.1.1 (ES0-DMD) 06/19/01 15:42:04 */
/*===========================================================================
  Copyright (C) 1995 European Southern Observatory (ESO)
 
  This program is free software; you can redistribute it and/or 
  modify it under the terms of the GNU General Public License as 
  published by the Free Software Foundation; either version 2 of 
  the License, or (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public 
  License along with this program; if not, write to the Free 
  Software Foundation, Inc., 675 Massachusetss Ave, Cambridge, 
  MA 02139, USA.
 
  Corresponding concerning ESO-MIDAS should be addressed as follows:
	Internet e-mail: midas@eso.org
	Postal address: European Southern Observatory
			Data Management Division 
			Karl-Schwarzschild-Strasse 2
			D 85748 Garching bei Muenchen 
			GERMANY
===========================================================================*/


# include <stdio.h>
# include <math.h>
#include <idi.h>
#include <x11defs.h>

static int virgin;

text_demo(w,kgc)
Window w;
GC  kgc;

{

char cbuf[20];
char **fontpntr, *pp, pattern[4];
int fcount, limi, i;


/* get a list of available fonts */

/*  strcpy(pattern,"-*-*-*-*-*-*-*-*-*-*-*-*-*-*");  */
strcpy(pattern,"*");
fontpntr = XListFonts(mydisp[0],pattern,3000,&fcount);
printf("total no. of available fonts = %d\n",fcount);

limi = 99999;			/* default for medium delay */
printf("Enter delay between different fonts, none/small/medium/large: ");
if (gets(cbuf) != (char *) 0)
   {
   if (cbuf[0] == 'n')
      limi = -1;
   else if (cbuf[0] == 's')
      limi = 20000;
   else if (cbuf[0] == 'l')
      limi = 200000;
   }

virgin = 0;

for (i=0; i<fcount; i++)
   {
   pp = *fontpntr++;
   show_text(w,kgc,pp,i,limi);
   virgin = 1;
   }

}

show_text(w,gc,fontnam,no,waitlim)
Window w;
GC  gc;
char     *fontnam;
int  no, waitlim;

{

double varia, res;
char   text[64];
int  x, y, ltxt, mm, kk;

if (virgin == 0) 
   {
   x = 0;
   y = 50;
   XClearArea(mydisp[0],w,x,y,0,0,True);
   goto do_it;
   }


/*  waiting loop  */

for (ltxt=0; ltxt<waitlim; ltxt++)
   {
   varia = ltxt;
   res = sqrt(varia);
   }

x = 0;
mm = no % 4;
y = 50 + mm*100;
if (mm == 3)
   kk = 0;
else
   kk = 100;

XClearArea(mydisp[0],w,x,y,0,kk,True);

do_it:
printf("(%d): %s\n",no,fontnam);
sprintf(text,"(%d):  Viva Portable Midas...",no);

myfont[0][0] = XLoadQueryFont(mydisp[0],fontnam);
if (myfont[0][0] == (XFontStruct *) 0)
   printf("Could not load the specified Font - so we skip ...\n");
else
   {
   XSetFont(mydisp[0],gc,myfont[0][0]->fid);
   x = 10;
   y = 100 + mm*100;
   ltxt = strlen(text);
   XDrawString(mydisp[0],w,gc,x,y,text,ltxt);
   XFlush(mydisp[0]);
   XFreeFont(mydisp[0],myfont[0][0]);
   }

}
