/* @(#)Xtest.c	16.1.1.1 (ESO-DMD) 06/19/01 15:42:03 */
/*===========================================================================
  Copyright (C) 1995 European Southern Observatory (ESO)
 
  This program is free software; you can redistribute it and/or 
  modify it under the terms of the GNU General Public License as 
  published by the Free Software Foundation; either version 2 of 
  the License, or (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public 
  License along with this program; if not, write to the Free 
  Software Foundation, Inc., 675 Massachusetts Ave, Cambridge, 
  MA 02139, USA.
 
  Correspondence concerning ESO-MIDAS should be addressed as follows:
	Internet e-mail: midas@eso.org
	Postal address: European Southern Observatory
			Data Management Division 
			Karl-Schwarzschild-Strasse 2
			D 85748 Garching bei Muenchen 
			GERMANY
===========================================================================*/


/* 
	Xtest.c  K.Banse   901206, 911018, 940111, 9800821

	execute via:  Xtest.exe option
        with option = P (PseudoColor)
                      T (TrueColor)
                      D (DirectColor)


  another way of obtaining the X11 capabilities of the display is to use
  the command: xdpyinfo

*/

# include <stdio.h>
# include <stdlib.h>
# include <idi.h>
# include <x11defs.h>

unsigned int border = 2;            /* pad border */
Window w, fw;

char  *cpntr, root, incr;

static char   *display = "";  
static char midas[6] = "MIDAS";
char  cbuf[22];

int   i, j, k, n;			/* cannot declare `int stat' here,
					   then it dies in Pseudomode in the
					   XAllocColor call ...    */
int   option, dwidth, dheight, ddepth, reqclass;
int   oldx, oldy;
int   xoff , yoff , status;
int   cbufsiz, count;
int   nf, winfla, dplanes;
int   sys_colors, plot_colors;
int   kred, jalloc, ioff, revert_to, iend;
unsigned int   xdim , ydim;
unsigned long int  mywhite, myblack, pixels[256], plane_mask[2], maska;
unsigned long int  valuemask;
long int    backpixel, mypixel;

GC     gcimb, newgc;
XColor wh1, wh2, bbl1, bbl2, bl1, bl2, red1, red2;
XColor green1, green2, yel1, yel2, blu1, blu2;
XColor mag1, mag2, cyan1, cyan2;
XKeyEvent   *xkeypntr;
XMappingEvent  *mapevent;
XVisualInfo *vlist, *vl;
Status  logstat;

static int   visclass[6] = {TrueColor, DirectColor, PseudoColor,
                    StaticColor, GrayScale, StaticGray};

static char *red_col = "red", *bl_col = "black", *wh_col = "white";
static char *blu_col = "blue", *yel_col = "yellow", *green_col = "green";
static char *mag_col = "magenta", *cyan_col = "cyan";

/*

*/

main(argc,argv)
int argc;
char *argv[];

{
int  stat, kargc;

char  *disp_var, *kargv;



(void) printf("\n******   X Window test program  (98NOV pl1.3)  ******\n");



/* Connect to X server */

#if vms
mydisp[0] = XOpenDisplay("DECW$DISPLAY");
#else

if (!(disp_var = getenv("DISPLAY")))
   {
   printf("\n<<<<<   You have to set the variable DISPLAY first!   >>>>>\n");
   exit(1);
   }
mydisp[0] = XOpenDisplay(display);
#endif

if (!mydisp[0])
   {
   printf("we got an error in XOpenDisplay!\n");
   return;
   }


oldx = -99;
root = 0;
incr = 1;
sys_colors = 0;
plot_colors = 0;

myscreen = DefaultScreen(mydisp[0]);
mywhite = WhitePixel(mydisp[0],myscreen);
myblack = BlackPixel(mydisp[0],myscreen);
rw[0] = RootWindow(mydisp[0],myscreen);

dwidth = DisplayWidth(mydisp[0],myscreen);
dheight = DisplayHeight(mydisp[0],myscreen);
ddepth = DefaultDepth(mydisp[0],myscreen);
dplanes = DisplayPlanes(mydisp[0],myscreen);
printf ("\nOn screen %d we have:\n", myscreen);
printf("Display width, height, depth, no_planes = %d, %d, %d, %d \n",
        dwidth,dheight,ddepth,dplanes);

myvis[0] = XDefaultVisual(mydisp[0],myscreen);
if (myvis[0]->class == GrayScale)
   strcpy(cbuf,"GrayScale");
else if (myvis[0]->class == StaticGray)
   strcpy(cbuf,"StaticGray");
else if (myvis[0]->class == PseudoColor)
   strcpy(cbuf,"PseudoColor");
else if (myvis[0]->class == StaticColor)
   strcpy(cbuf,"StaticColor");
else if (myvis[0]->class == TrueColor)
   strcpy(cbuf,"TrueColor");
else if (myvis[0]->class == DirectColor)
   strcpy(cbuf,"DirectColor");
else
   {
   printf("class looks exotic, value = %d\n",myvis[0]->class);
   exit(1);
   }

printf("\nDefault Visual (id = 0x%x) is %s\n",myvis[0]->visualid,cbuf);



/*  get list of all possible Visuals */

vlist = XGetVisualInfo(mydisp[0],VisualNoMask,&vinfo,&nf);
if (nf < 1)
   {
   printf("\nNo Visuals available...\n");
   exit(1);
   }


k = 0;
for (vl=vlist; vl<vlist+nf; vl++)
   {
   if (vl->screen == myscreen) k++;
   }
printf("\nNo. of Visuals: %d\n",k);

for (vl=vlist; vl<vlist+nf; vl++)
   {
   if (vl->screen == myscreen)
      {
      for (n=0; n<6; n++)
         {
         if (vl->class == visclass[n])
            {
            if (visclass[n] == GrayScale)
               strcpy(cbuf,"GrayScale");
            else if (visclass[n] == StaticGray)
               strcpy(cbuf,"StaticGray");
            else if (visclass[n] == PseudoColor)
               strcpy(cbuf,"PseudoColor");
            else if (visclass[n] == StaticColor)
               strcpy(cbuf,"StaticColor");
            else if (visclass[n] == TrueColor)
               strcpy(cbuf,"TrueColor");
            else if (visclass[n] == DirectColor)
               strcpy(cbuf,"DirectColor");
            }
         }
      j = vl->colormap_size;
      printf("visual id: 0x%x\n",vl->visualid); 
      printf("  class: %s\n",cbuf);
      printf("  depth: %d planes, colormap size: %d entries\n",vl->depth,j);
      }
   }

printf("\n\n");


winfla = 1;
option = 0;
reqclass = PseudoColor;

if (argc > 1)
   {
   cpntr = argv[1];
   if ((*cpntr == '?') || (*cpntr == 'h'))
      {
      printf("usage:\nXtest.exe arg1\n");
      printf("arg1 = T for using TrueColor visual mode (if available)\n");
      printf("     = D for using DirectColor visual mode (if available)\n");
      printf
      ("     = P for using PseudoColor visual mode - which is the default\n");
      exit(1);
      }

   if ((*cpntr == 'T') || (*cpntr == 't'))
      {
      reqclass = TrueColor;
      option = 2;
      }
   else if ((*cpntr == 'D') || (*cpntr == 'd'))
      {
      reqclass = DirectColor;
      option = 1;
      }
   else if ((*cpntr == 'P') || (*cpntr == 'p'))
      {
      cpntr += 2;
      if ((*cpntr == 'L') || (*cpntr == 'l')) option = -1;
      }
   }

getvisual();


xdim = 530;
ydim = 530;
xoff = 200;
yoff = dheight - 1 - ydim - (2*border) + 200;


/* we have to set the border, background pixel (default is CopyFromParent,
   which could lead to BadMatch) ... */

valuemask = CWBorderPixel | CWBackPixel | CWColormap | CWOverrideRedirect;
backpixel = myblack;
sattributes.border_pixel = (unsigned long int) backpixel;
sattributes.background_pixel = (unsigned long int) backpixel;
sattributes.colormap = cmap[0][winfla];
sattributes.override_redirect = False;
w = XCreateWindow (mydisp[0],rw[0],
                   xoff, yoff, xdim, ydim, border,ddepth,
                   InputOutput,myvis[0],valuemask,&sattributes);
if (w == 0)
   {
   printf("we got an error in XCreateWindow!\n");
   exit(1);
   }

XFlush (mydisp[0]);


/* set Window Manager hints  */

xwmh.initial_state = NormalState;
xwmh.input = True;
xwmh.flags = InputHint | StateHint;
XSetWMHints(mydisp[0],w,&xwmh);

myhint[0].x = xoff, myhint[0].y = yoff;
myhint[0].width = xdim;
myhint[0].height = ydim;
myhint[0].flags = USPosition | USSize;

kargc = 0;
XSetStandardProperties(mydisp[0],w,midas,midas,
                       None,&kargv,kargc,&myhint[0]);

gcimb = XCreateGC(mydisp[0],w,0,&xgcvals);
maska = 0xffffffff;
XSetBackground(mydisp[0],gcimb,0);
XSetForeground(mydisp[0],gcimb,0xffffffff);
XSetPlaneMask(mydisp[0],gcimb,maska);
XSetFunction(mydisp[0],gcimb,GXxor);

red1.pixel = mycolr[0][kred].pixel;
mycurs[0][0] = XCreateFontCursor(mydisp[0],XC_arrow);
XRecolorCursor(mydisp[0],mycurs[0][0],&red1,&wh1);
XDefineCursor(mydisp[0],w,mycurs[0][0]);

event_mask = KeyPressMask | PointerMotionMask | ButtonPressMask | ExposureMask;

XSync(mydisp[0],1);
XSelectInput(mydisp[0],w,event_mask);

XMapRaised (mydisp[0],w);

printf("we now make a %d*%d window\n",xdim,ydim);
xdim = 530, ydim = 200;
printf("and fill it with a %d*%d intensity image at the top\n",xdim,ydim);

XWindowEvent(mydisp[0],w,event_mask,&myevent);
XFlush (mydisp[0]);


/* prepare the image  */

if (option > 0)
   nf = 32;                       /* bitmap pad */
else
   nf = 8;
myima = XCreateImage(mydisp[0],myvis[0],ddepth,ZPixmap,0,0,xdim,ydim,
                     nf,0);

printf("\nImage structure attributes:\n");
printf("width = %d, height = %d\n",myima->width,myima->height);
printf("xoffset = %d, format = %d\n",myima->xoffset,myima->format);
printf("bitmap_unit = %d, bitmap_pad = %d, depth = %d\n",
       myima->bitmap_unit,myima->bitmap_pad,myima->depth);
printf("bytes_per_line = %d, bits_per_pixel = %d\n",
       myima->bytes_per_line,myima->bits_per_pixel);

n = myima->bytes_per_line * ydim;
myima->data = malloc(n);

if (myima->data == 0)
   {
   printf("problems allocating %d bytes\n",n);
   exit(1);
   }



/***************************************************/
/* now build the image  */
/***************************************************/

if (option > 0)
   {
   if (ddepth == 32)
      build32(myima->data,xdim,ydim,root,incr);
   else
      build24(myima->data,xdim,ydim,root,incr);
   }
else
   build8(myima->data,xdim,ydim,root,incr);



xoff = 0;
yoff = 0;
newgc = XCreateGC(mydisp[0],w,0,&xgcvals);
XPutImage(mydisp[0],w,newgc,myima,0,0,xoff,yoff,xdim,ydim);

printf("\n>> move the pointer into the window + press any mouse button...\n\n");

printf("the pointer should be a red arrow inside the mapped window...\n");


/***************************************************/
/* now set up the event loop for mouse buttons */
/***************************************************/

event_loop:
XWindowEvent(mydisp[0],w,event_mask,&myevent);
XRecolorCursor(mydisp[0],mycurs[0][0],&red1,&wh1);
XDefineCursor(mydisp[0],w,mycurs[0][0]);

switch (myevent.type)
   {
   case MotionNotify:
   printf(" the pointer moved ...\n");
   event_mask = ButtonPressMask ;
   XSync(mydisp[0],1);
   XSelectInput(mydisp[0],w,event_mask);
   goto event_loop;

   case ButtonPress:
   printf(" button state, no., x, y : %d, %d, %d, %d \n",
   myevent.xbutton.state,myevent.xbutton.button,
   myevent.xbutton.x,myevent.xbutton.y);
   if (myevent.xbutton.button == 1)
      {
      event_mask = ButtonPressMask ;
      XSync(mydisp[0],1);
      XSelectInput(mydisp[0],w,event_mask);
      goto event_loop;
      }
   if (myevent.xbutton.button == 2)
      {
      XRecolorCursor(mydisp[0],mycurs[0][0],&bl1,&wh1);
      XDefineCursor(mydisp[0],w,mycurs[0][0]);
      XSetFunction(mydisp[0],gcimb,GXxor);
      XFlush(mydisp[0]);
      if (oldx != -99)
         {
         XDrawLine(mydisp[0],w,gcimb,0,oldy,511,oldy);
         XDrawLine(mydisp[0],w,gcimb,oldx,0,oldx,511);
         XFlush(mydisp[0]);
         }
      XDrawLine(mydisp[0],w,gcimb,0,myevent.xbutton.y,511,myevent.xbutton.y);
      XDrawLine(mydisp[0],w,gcimb,myevent.xbutton.x,0,myevent.xbutton.x,511);
      oldx = myevent.xbutton.x;
      oldy = myevent.xbutton.y;
      event_mask = ButtonPressMask ;
      XSync(mydisp[0],1);
      XSelectInput(mydisp[0],w,event_mask);
      goto event_loop;
      }
   if (myevent.xbutton.button == 3)
      {
      printf("press any key on the keyboard, RETURN to exit\n");
      printf("press 'up_arrow' for a demo of the X cursors\n");
      printf("press 'down_arrow' for a demo of the X fonts\n");
      goto next_step;
      }
   }

next_step:
XGetInputFocus(mydisp[0],&fw,&revert_to);
if (fw == None)
   printf("focus window = None\n");
else
   printf("focus window, root window, image window = %d, %d, %d\n",
          fw,rw[0],w);
if (revert_to == RevertToParent)
   printf("revert_to = RevertToParent\n");
else if (revert_to == RevertToPointerRoot)
   printf("revert_to = RevertToPointerRoot\n");
else if (revert_to == RevertToNone)
   printf("revert_to = RevertToNone\n");
else
   printf("revert_to = %d (what is it?)\n",revert_to);

XSetInputFocus(mydisp[0],w,RevertToParent,CurrentTime);

mapevent = (XMappingEvent *) &myevent;
xkeypntr = (XKeyEvent *) &myevent;
XRefreshKeyboardMapping(mapevent);
XSync(mydisp[0],1);
event_mask = KeyPressMask ;
XSync(mydisp[0],1);
XSelectInput(mydisp[0],w,event_mask);

nevent_loop:
XWindowEvent(mydisp[0],w,event_mask,&myevent);
cbufsiz = 20;

switch (myevent.type)
   {
   case KeyPress:
   count = XLookupString(xkeypntr,cbuf,cbufsiz,&mykey,&xcstat);
   cbuf[count] = '\0';
   printf("count, cbuf = %d, %s\n",count,cbuf);
   printf(".xkey.keycode = %d\n",myevent.xkey.keycode);
   printf(".xkey.x, .xkey.y = %d,%d\n",myevent.xkey.x,myevent.xkey.y);
   if (mykey == XK_Up)
      {
      printf("key is XK_Up\n");
      curs_demo(w);
      printf("press any key on the keyboard, RETURN to exit\n");
      }
   else if (mykey == XK_Down)
      {
      printf("key is XK_Down\n");
      text_demo(w,gcimb);
      printf("press any key on the keyboard, RETURN to exit\n");
      }
   else if (mykey == XK_Left)
      printf("key is XK_Left\n");
   else if (mykey == XK_Right)
      printf("key is XK_Right\n");

   if (mykey == XK_Return) goto end_of_it;
   break;

   case MappingNotify:
   XRefreshKeyboardMapping(mapevent);
   break;

   default:
   printf("default case: eventtype = %d\n",myevent.type);
   break;
   }

goto nevent_loop;


end_of_it:
(void) printf("\n\nAdios muchachos - this is the end ... \n");

exit(0);
}

/*

*/

getvisual()

{
int  isw, isb;

void makeLUT(), makeRGBLUT();

char   visbuf[16];



if (option == 1)
   {
   (void) strcpy(visbuf,"DirectColor");
   isw = DirectColor;
   ddepth = 24;
   }

else if (option == 2)
   {
   (void) strcpy(visbuf,"TrueColor");
   isw = TrueColor;
   ddepth = 24;
   }
else
   {
   (void) strcpy(visbuf,"PseudoColor");
   isw = PseudoColor;
   ddepth = 8;
   }


(void) printf("\n******   using %s Mode   ******\n\n",visbuf);


if (myvis[0]->class != reqclass)
   {
   logstat = XMatchVisualInfo(mydisp[0],myscreen,ddepth,isw,&vinfo);
   if (logstat)
      {
      myvis[0] = vinfo.visual;
      (void) printf
         ("We found %sVisual (id 0x%x) with depth = %d, colormap_size = %d\n",
         visbuf,vinfo.visualid,vinfo.depth,vinfo.colormap_size);
      ddepth = vinfo.depth;
      }
   else
      {
      printf("we could not get a %s Visual ...!\n",visbuf);
      exit(1);
      }
   }
else
  (void) printf("We take default Visual (id 0x%x) with default depth = %d\n",
                myvis[0]->visualid,ddepth);


(void) printf
       ("red_mask = %6.6x, green_mask = %6.6x, blue_mask = %6.6x\n",
       myvis[0]->red_mask,myvis[0]->green_mask,myvis[0]->blue_mask);
(void) printf
       ("bits_per_rgb = %d\n\n",myvis[0]->bits_per_rgb);


if (option < 1)
   {
   cmap[0][0] = DefaultColormap(mydisp[0],myscreen);
   if (option == 0)
      winfla = 0;
   else
      cmap[0][1] = XCreateColormap(mydisp[0],rw[0],myvis[0],AllocNone);
   }
else
   cmap[0][1] = XCreateColormap(mydisp[0],rw[0],myvis[0],AllocNone);


if (option == 1)
   makeRGBLUT(myvis[0]->map_entries);
else if (option == 2)
   getsomecols(1);
else
   {
   if (option == -1)
      {
      makeRGBLUT(myvis[0]->map_entries);
      getsomecols(0);
      }
   else
      makeLUT();
   }
}

/*

*/

build8(data,xsiz,ysiz,root,incr)

char  *data, root, incr;
int            xsiz, ysiz;

{
int nx,ny;
char  *jdata, sroot;

jdata = data;
sroot = root;

for (ny=0; ny<ysiz; ny++)
   {
   root = sroot;
   for (nx=0; nx<xsiz; nx+=2)
      {
      *jdata++ = root;
      *jdata++ = root;
      root += incr;
      }
   }
}


build16(data,xsiz,ysiz,root,incr)

char  *data, root, incr;
int            xsiz, ysiz;

{
short int *jdata;
int nx,ny;
short int myroot, myincr;
char  sroot;

jdata = (short int *) data;
myincr = (short int) incr;
sroot = root;

for (ny=0; ny<ysiz; ny++)
   {
   root = sroot;
   myroot = (short int) root;
   for (nx=0; nx<xsiz; nx+=2)
      {
      *jdata++ = myroot;
      *jdata++ = myroot;
      myroot += myincr;
      }
   }
}


build24(data,xsiz,ysiz,root,incr)

char  *data, root, incr;
int            xsiz, ysiz;

{
int *jdata;
int nx, ny, pixval, red, green, blue;
int myroot, myincr;

jdata = (int *) data;
myincr = (int) incr;

for (ny=0; ny<ysiz-150; ny++)
   {
   myroot = (int) root;
   for (nx=0; nx<xsiz; nx+=2)
      {
      red = myroot;
      green = myroot << 8;
      blue = myroot << 16;
      pixval = 0;
      pixval = (red | green | blue);
      *jdata++ = pixval;
      *jdata++ = pixval;
      myroot += myincr;
      if (myroot > 255) myroot = 255;
      }
   }

for (ny=0; ny<50; ny++)
   {
   myroot = (int) root;
   for (nx=0; nx<xsiz; nx+=2)
      {
      *jdata++ = myroot;
      *jdata++ = myroot;
      myroot += myincr;
      if (myroot > 255) myroot = 255;
      }
   }

for (ny=0; ny<50; ny++)
   {
   myroot = (int) root;
   for (nx=0; nx<xsiz; nx+=2)
      {
      pixval = myroot << 8;
      *jdata++ = pixval;
      *jdata++ = pixval;
      myroot += myincr;
      if (myroot > 255) myroot = 255;
      }
   }

for (ny=0; ny<50; ny++)
   {
   myroot = (int) root;
   for (nx=0; nx<xsiz; nx+=2)
      {
      pixval = myroot << 16;
      *jdata++ = pixval;
      *jdata++ = pixval;
      myroot += myincr;
      if (myroot > 255) myroot = 255;
      }
   }

}


build32(data,xsiz,ysiz,root,incr)

char  *data, root, incr;
int            xsiz, ysiz;

{
long int *jdata;
int nx,ny;
long int myroot, myincr;
char  sroot;

jdata = (long int *) data;
myincr = (long int) incr;
sroot = root;


for (ny=0; ny<ysiz; ny++)
   {
   root = sroot;
   myroot = (long int) root;
   for (nx=0; nx<xsiz; nx+=2)
      {
      *jdata++ = myroot;
      *jdata++ = myroot;
      myroot += myincr;
      }
   }
}


build1(data,xbytes,ysiz,root,incr)

char  *data, root, incr;
int   xbytes, ysiz;

{

int nx,ny,kcount;
char  *jdata;
char  sroot;

jdata = data;
sroot = root;
kcount = 0;


for (ny=0; ny<ysiz; ny++)
   {
   root = sroot;
   for (nx=0; nx<xbytes; nx ++)
      {
      *jdata++ = root;
      kcount ++;
      if (kcount == 4)
         {
         kcount = 0;
         root += incr;
         }
      }
   }
}

/*

*/

getsomecols(indx)
int  indx;

{
XAllocNamedColor(mydisp[0],cmap[0][indx],wh_col,&wh1,&wh2) ;
XAllocNamedColor(mydisp[0],cmap[0][indx],bl_col,&bl1,&bl2);
XAllocNamedColor(mydisp[0],cmap[0][indx],bl_col,&bbl1,&bbl2);
XAllocNamedColor(mydisp[0],cmap[0][indx],red_col,&red1,&red2);
XAllocNamedColor(mydisp[0],cmap[0][indx],green_col,&green1,&green2);
XAllocNamedColor(mydisp[0],cmap[0][indx],blu_col,&blu1,&blu2);
XAllocNamedColor(mydisp[0],cmap[0][indx],yel_col,&yel1,&yel2);
XAllocNamedColor(mydisp[0],cmap[0][indx],mag_col,&mag1,&mag2);
XAllocNamedColor(mydisp[0],cmap[0][indx],cyan_col,&cyan1,&cyan2);
}

/*

*/

void makeLUT()

{
float  lutval, rval, fval;


k = 512;
color_loop:
x11stat = XAllocColorCells(mydisp[0],cmap[0][winfla],0,plane_mask,0,pixels,k);
if (x11stat)
   {
   xoff = 0;			/* find first hole in contiguous array */
   for (n=0; n<k/2; n++)
      {
      if ((pixels[n+1] - pixels[n]) > 1)
         {
         xoff = n + 1;
         break;
         }
      }

   if (xoff > 0)
      {
      k -= xoff;
      for (n=0; n<k; n++)
         pixels[n] = pixels[n+xoff];
      }
   } 
else
   {
   k -= 2;
   if (k < 8)
      {
      printf("could not allocate at least %d colours... \n",k);
      k = 0;
      }
   else
      goto color_loop;
   }
   
jalloc = k;
k = myvis[0]->map_entries - k;
printf("%d colours already allocated by the XWindow Manager\n",k);

if (jalloc > 256)
   {
   n = jalloc / 256;
   if (n > 4) n = 4;			/* max 4 LUTs  */
   jalloc = 256;				/* max 256 colours */
   }
else if (jalloc > 0)
   n = 1;
else
   {
   jalloc = 256;
   n = 0;
   }

for (i=0; i<jalloc; i++)
   {
   mycolr[0][i].pixel = i;
   mycolr[0][i].flags = DoRed | DoGreen | DoBlue;
   }

getsomecols(winfla);


/*  get 16 default colours */

if (sys_colors > 0)
   {
   XQueryColors(mydisp[0],DefaultColormap(mydisp[0],myscreen),
             &mycolr[0][0],jalloc);
   XSync(mydisp[0],1);

   if (mywhite > 2)		/* we keep the high end of the LUT  */
      {
      k = jalloc - sys_colors - plot_colors;
      ioff = 0;
      iend = k;
      }
   else				/* we keep the low end of the LUT   */
      {
      k = sys_colors;
      ioff = sys_colors + plot_colors;
      iend = jalloc;
      }
   kred = k + 2;		/* save index  */
   }
else
   {
   ioff = 0;
   iend = jalloc;
   kred = 0;
   k = 0;
   }

mycolr[0][k].red = wh1.red;
mycolr[0][k].green = wh1.green;
mycolr[0][k].blue = wh1.blue;
mycolr[0][k+1].red = bl1.red;
mycolr[0][k+1].green = bl1.green;
mycolr[0][k+1].blue = bl1.blue;
mycolr[0][k+2].red = red1.red;
mycolr[0][k+2].green = red1.green;
mycolr[0][k+2].blue = red1.blue;
mycolr[0][k+3].red = green1.red;
mycolr[0][k+3].green = green1.green;
mycolr[0][k+3].blue = green1.blue;
mycolr[0][k+4].red = blu1.red;
mycolr[0][k+4].green = blu1.green;
mycolr[0][k+4].blue = blu1.blue;
mycolr[0][k+5].red = yel1.red;
mycolr[0][k+5].green = yel1.green;
mycolr[0][k+5].blue = yel1.blue;
mycolr[0][k+6].red = mag1.red;
mycolr[0][k+6].green = mag1.green;
mycolr[0][k+6].blue = mag1.blue;
mycolr[0][k+7].red = cyan1.red;
mycolr[0][k+7].green = cyan1.green;
mycolr[0][k+7].blue = cyan1.blue;


/* load grayscale LUT  */

for (i=0; i<jalloc; i++)			/* reset pixels  */
   mycolr[0][i].pixel = pixels[i];

fval = 0.0;
rval = 1.0 / (jalloc - sys_colors - plot_colors - 1);

for (i=ioff; i<iend; i++)
   {
   lutval = fval * XLUTFACT;
   mycolr[0][i].red = (unsigned short) lutval;
   mycolr[0][i].green = (unsigned short) lutval;
   mycolr[0][i].blue = (unsigned short) lutval;
   fval += rval;
   }

XStoreColors(mydisp[0],cmap[0][winfla],mycolr[0],jalloc);
XFlush(mydisp[0]);

if (sys_colors > 0)
   {
   printf("We copy %d system colours and use %d plot colours\n",
          sys_colors,plot_colors);
   jalloc -= (sys_colors+plot_colors);
   }
   
if (n == 0)
   {
   printf("so we can use no LUT for Midas - bye, bye...\n\n");
   exit(1);
   }

if (n == 1)
   printf("so we can use a LUT of %d colours.\n\n",jalloc);
else
   {
   printf("We can use %d LUTs of %d colours each for Midas\n\n",n,jalloc);
   printf("You have to edit the file syskeys.dat (see the installation doc)");
   printf(" to modify\nthe contents of the keyword DAZDEVR:\n");
   printf("DAZDEVR(2) = %d, DAZDEVR(3) = %d\n",n,jalloc);
   printf("Another possibility is to execute the MIDAS command\n");
   printf("'initialize/display %d,%d' each time you get into MIDAS.\n\n",
       n,jalloc);
   }
}

/*

*/

void makeRGBLUT(mplen)
int mplen;

{
int    ifact, isw;



if (mplen>256) mplen=256;
 

/* let's build a grayscale LUT */ 
 
ifact = 0xffff / (mplen - 1);
j = 0;
isw = 0;
wh1.flags = DoRed | DoGreen | DoBlue;

for (i=0; i<mplen; i++) 
   {
   wh1.red = wh1.green = wh1.blue = j;
   j += ifact;

   if (XAllocColor(mydisp[0], cmap[0][winfla], &wh1)) isw++;
   }


if (isw != mplen)
   {
   if (isw == 0)
      {
      (void) printf("No entries in LUT!\n");
      exit(1);
      }
   else
      (void) 
      printf("Only %d entries in LUT (of size %d)!\n",isw,mplen);
   }

getsomecols(winfla);
}


