#define vmr	vmr_		/* parameter for Name Translation is l_ */
#define ROUTINE int
/* @(#)ftoc_vmrc.fc	16.1.1.1 (ES0-DMD) 06/19/01 15:41:55 */
/*===========================================================================
  Copyright (C) 1995 European Southern Observatory (ESO)
 
  This program is free software; you can redistribute it and/or 
  modify it under the terms of the GNU General Public License as 
  published by the Free Software Foundation; either version 2 of 
  the License, or (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public 
  License along with this program; if not, write to the Free 
  Software Foundation, Inc., 675 Massachusetss Ave, Cambridge, 
  MA 02139, USA.
 
  Corresponding concerning ESO-MIDAS should be addressed as follows:
	Internet e-mail: midas@eso.org
	Postal address: European Southern Observatory
			Data Management Division 
			Karl-Schwarzschild-Strasse 2
			D 85748 Garching bei Muenchen 
			GERMANY
===========================================================================*/

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
.COPYRIGHT:  Copyright (c) 1988 European Southern Observatory,
.TYPE	     Test module
.IDENT       ftoc_vmrc.c
.LANGUAGE    C
.AUTHOR      Carlos Guirao [ESO/IPG]
.ENVIRONMENT UNIX
.COMMENT     Print in the standard output the code for the name convention 
             used by Fortran COMMON variables (in particular for the MIDAS
             variable "vmr")
             This programm is tried to be compiled and linked in two different
             forms:
	     -Compiled with the same name convention for variables and routines.
              The name convention for routines is given by the command:
	      ../exec/ftoc_names.exe. In this case the ouput is empty.
	     -Compiled with the definition of the name-convention for routines.
              Then we define COMMON variables with an extra underscore at the 
              beggining. If the linker gives no problem the program will 
              printout the name convention needed for COMMON variables.
.REMARKS
.VERSION     1.1   12-Aug-1988: Creation,     CG
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

#include <varargs.h>

#define fl	0
#define fl_ 	1
#define f_l_ 	2
#define f_l 	3
#define fu 	4
#define fu_ 	5
#define f_u_ 	6
#define f_u 	7

# undef vmr
#if NAMES == fl
#   define vmr _vmr
#   define msg "-v_l"
#elif NAMES == f_l
#   define vmr __vmr
#   define msg "-v__l"
#elif NAMES == fl_
#   define vmr _vmr_
#   define msg "-v_l_"
#elif NAMES == f_l_
#   define vmr __vmr_
#   define msg "-v__l_"
#elif NAMES == fu
#   define vmr _VMR
#   define msg "-v_u"
#elif NAMES == f_u
#   define vmr __VMR
#   define msg "-v__u"
#elif NAMES == fu_
#   define vmr _VMR_
#   define msg "-v_u_"
#elif NAMES == f_u_
#   define vmr __VMR_
#   define msg "-v__u_"
#endif /* NAMES */

extern struct { int addr; } vmr ;

#define csub	csub_
ROUTINE csub()
{
    vmr.addr=0;
    printf("%s\n",msg);
    exit(vmr.addr);
}
