! @(#)norm1d.prg	16.1.1.1 (ES0-DMD) 06/19/01 15:40:47
!++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
!
! . IDENTIFICATION
!
! MIDAS COMMAND PROCEDURE : NORM1D.PRG
!
! D. Baade, ST-ECF, Garching           version 1.0               281085
!    920413  KB
!
! .PURPOSE
!
! execute the command :
!
! NORMALIZE/1D inimage fitimage [mode] [table batch_flag]
!
! inimage:   input frame
! fitimage:  fit to the continuum
! mode:      GCURSOR - create new table FIT1D, input from graphics cursor
!            ADD     - add new points to table FIT1D
!            DELETE  - delete points from table FIT1D
!            TABLE   - get positions and bin widths from "table", integrate
!		       in "inimage" over corresponding bins
! batch_flag  if equal to Y suppress all plots
!
!-------------------------------------------------------------------------------
!
DEFINE/PARAM P1 ? IMAGE "Enter input image:"
DEFINE/PARAM P2 ? IMAGE "Enter output image:"
DEFINE/PARAM P3 G C
DEFINE/PARAM P4 TABLE C
DEFINE/PARAM P5 N ?
!
IF P3(1:1) .EQ. "T"  THEN
   IF P4(1:1) .EQ. "?" THEN
      WRITE/OUT "Please supply name of table with wavelengths and bin widths !"
      RETURN
   ELSE
      GOTO TABLE
   ENDIF
ENDIF
IF P3(1:1) .EQ. "A"  GOTO ADD
IF P3(1:1) .EQ. "D"  GOTO DELETE
!
GCURSOR: 			! 1st case: start from scratch
!
PLOT/ROW {P1}
WRITE/OUT "                       >>> Use graphics cursor to enter data <<<"
GET/GCURS FIT1D
GOTO FIT
!
ADD: 			! 2nd case: add points to previoulsy created table FIT1D
!
PLOT/ROW {P1}
OVERPLOT/TABLE FIT1D :X_AXIS :Y_AXIS
GET/GCURS FIT1D ADD
GOTO FIT
!
DELETE: 	! 3rd case: delete points from previously created table FIT1D
!
PLOT/ROW {P1}
OVERPLOT/TABLE FIT1D :X_AXIS :Y_AXIS
IDENT/GCURS FIT1D :X_AXIS :X_AXIS :Y_AXIS 3
GOTO FIT
!
TABLE: 				! 4th case: integrate over bins in inmage
!
IF P5(1:1) .NE. "Y" PLOT/ROW {P1}
WRITE/KEYW NFIMAGE/C/1/60 {P1}
WRITE/KEYW NFTABLE/C/1/60 "FIT1D"
-COPY {P4}.tbl FIT1D.tbl
CREATE/COLUMN FIT1D :Y_AXIS
RUN STD_EXE:INTEGBIN
IF P5(1:1) .NE. "Y" OVERPLOT/TABLE FIT1D :X_AXIS :Y_AXIS
!
FIT: 				! do the spline fit
!
SORT/TABLE FIT1D :X_AXIS
CONVERT/TABLE {P2} = FIT1D :X_AXIS :Y_AXIS {P1} SPLINE
IF P5(1:1) .NE. "Y" OVER {P2}

