/* @(#)lntest.c	16.1.1.1 (ES0-DMD) 06/19/01 15:38:42 */
/*===========================================================================
  Copyright (C) 1995 European Southern Observatory (ESO)
 
  This program is free software; you can redistribute it and/or 
  modify it under the terms of the GNU General Public License as 
  published by the Free Software Foundation; either version 2 of 
  the License, or (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public 
  License along with this program; if not, write to the Free 
  Software Foundation, Inc., 675 Massachusetss Ave, Cambridge, 
  MA 02139, USA.
 
  Corresponding concerning ESO-MIDAS should be addressed as follows:
	Internet e-mail: midas@eso.org
	Postal address: European Southern Observatory
			Data Management Division 
			Karl-Schwarzschild-Strasse 2
			D 85748 Garching bei Muenchen 
			GERMANY
===========================================================================*/

/* @(#)lntest.c	16.1.1.1  (ESO)  06/19/01  15:38:42 */
/* +++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
/* .COPYRIGHT   (C) 1993 European Southern Observatory     */
/* .IDENT       .prg                                       */
/* .AUTHORS     Pascal Ballester (ESO/Garching)            */
/*              Cristian Levin   (ESO/La Silla)            */
/* .KEYWORDS    Spectroscopy, Long-Slit                    */
/* .PURPOSE                                                */
/* .VERSION     1.0  Package Creation  17-MAR-1993         */
/* ------------------------------------------------------- */

#include <math.h>

main()

{

double    x[100],l[100],lev[100], lid[100],ldif[100],ly[100];
int       reject[100];
int       nval=90;
int       i;
double    dif, maxdif, alpha=0.45;
void      fit_disp(), eval_disp();


for (i=1; i<=nval; i++) {
     x[i] = i + 1.;
     l[i] = 6000. + x[i]*0.15 + x[i]*x[i]*0.003;
   }

fit_disp(x,l,nval, 2);

eval_disp(x,lev,nval);

maxdif = 0.;

for (i=1; i<=nval; i++) {
     dif = l[i] - lev[i];
     printf("Initial, Computed  : %f  %f  \n",l[i],lev[i]);
     if (dif<0) dif = (-1.)*dif;
     if (dif>maxdif) maxdif = dif;
     ly[i] = 1.;
   }

printf ("Maximum absolute value of the error (must be small) : %f\n",maxdif);

printf ("Number of idents %d\n",match(1, lid, lev, 
                   ly, ldif, nval, l, nval, alpha, reject));

maxdif = 0.;

for (i=1; i<=nval; i++) {
     if (reject[i] > 0) {
        dif = ldif[i];
        if (dif<0) dif = (-1.)*dif;
        if (dif>maxdif) maxdif = dif;
      }
   else
     printf ("Rejected identification line %f (index %d), Reason %d\n",lev[i],i,reject[i]);

}

printf ("Maximum matching error (must be equal to the previous number) : %f\n",maxdif);

}







