! @(#)lnverif.prg	16.1.1.1 (ES0-DMD) 06/19/01 15:38:29
!+++++++++++++++++++++++++++++++++++++++++++++++++++++++
!.COPYRIGHT   (C) 1993 European Southern Observatory
!.IDENT       lnverif.prg
!.AUTHORS     Pascal Ballester (ESO/Garching) 
!             Cristian Levin   (ESO/La Silla)
!.KEYWORDS    Spectroscopy, Long-Slit
!.PURPOSE     
!.VERSION     1.0  Package Creation  17-MAR-1993  
!-------------------------------------------------------
!
DEFINE/PARAM  P1  ?  CHAR  "Input file:"
DEFINE/PARAM  P2  ?  CHAR  "Type (IMA/TAB/OTIME/AIRMASS) :"

! Before any further test, checks that the file exists.

DEFINE/LOCAL EXIST/I/1/1 0
DEFINE/LOCAL INDEX/I/1/1 0
DEFINE/LOCAL INPFIL/C/1/80 " " ALL
DEFINE/LOCAL ERROR/I/1/1   0

INDEX = M$INDEX(P1,".")
WRITE/KEYW INPFIL {P1}

IF INDEX .EQ. 0 THEN
   IF P2(1:1) .EQ. "T"  THEN
          WRITE/KEYW INPFIL {P1}.tbl
   ELSE
          WRITE/KEYW INPFIL {P1}.bdf
   ENDIF
ENDIF

EXIST = M$EXIST(INPFIL)

IF EXIST .EQ. 0 THEN
   IF P2(1:1) .EQ. "O"  WRITE/OUT "Error ** Could not find file : {P1}"
   IF P2(1:1) .EQ. "I"  WRITE/OUT "Error ** Could not find image : {P1}"
   IF P2(1:1) .EQ. "T"  WRITE/OUT "Error ** Could not find table : {P1}"
   IF P2(1:1) .EQ. "A"  WRITE/OUT "Error ** Could not find file : {P1}"
   RETURN/EXIT
ENDIF

IF P2(1:1) .EQ. "O" THEN

   IF M$EXISTD(P1,"O_TIME") .LE. 0 THEN
      WRITE/OUT "Error: Descriptor not present : O_TIME in file {P1}"
      ERROR = 1
   ELSE
      IF {{P1},O_TIME(7)} .LE. 0.  THEN
         WRITE/OUT "Error: Incorrect time {{P1,O_TIME(7)} in file {P1}"
         ERROR = 1
      ENDIF
   ENDIF

   IF ERROR .EQ. 1 THEN
      WRITE/KEYW   INPUTD/D/1/20  0. ALL
      INQUIRE/KEYW INPUTD/D/7/1 "Enter Observation time (in seconds) : "
      COPY/KD     INPUTD/D/1/7 {P1}   O_TIME/D/1/7
   ENDIF

ENDIF

IF P2(1:1) .EQ. "A" THEN

   IF M$EXISTD(P1,"O_AIRM") .LE. 0 THEN
      WRITE/OUT "Error: Descriptor not present : O_AIRM in file {P1}"
      ERROR = 1
   ELSE
      IF {{P1},O_AIRM} .LE. 0.  THEN
         WRITE/OUT "Error: Incorrect descriptor O_AIRM : {{P1},O_AIRM} in file {P1}"
         ERROR = 1
      ENDIF
   ENDIF

   IF ERROR .EQ. 1 THEN
      WRITE/KEYW   INPUTR/R/1/20  0. ALL
      INQUIRE/KEYW INPUTR/R/1/1 "Enter Airmass : "
      COPY/KD     INPUTR/R/1/1 {P1}   O_AIRM/R/1/1
   ENDIF

ENDIF



